/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.activitymap;

import java.util.Date;
import org.eclipse.scout.rt.client.ui.basic.activitymap.IActivityCellObserver;
import org.eclipse.scout.rt.shared.data.basic.MemoryOptimizedObject;

public class ActivityCell
extends MemoryOptimizedObject {
    private static final long serialVersionUID = 1L;
    public static final int OBSERVER_BIT = 0;
    public static final int RESOURCE_ID_BIT = 1;
    public static final int ACTIVITY_ID_BIT = 2;
    public static final int BEGIN_TIME_BIT = 3;
    public static final int END_TIME_BIT = 4;
    public static final int TEXT_BIT = 5;
    public static final int BACKGROUND_COLOR_BIT = 6;
    public static final int FOREGROUND_COLOR_BIT = 7;
    public static final int MAJOR_VALUE_BIT = 8;
    public static final int MAJOR_COLOR_BIT = 9;
    public static final int MINOR_VALUE_BIT = 10;
    public static final int MINOR_COLOR_BIT = 11;
    public static final int DURATION_MINUTES_BIT = 12;
    public static final int TOOLTIP_TEXT_BIT = 13;
    public static final int ICON_ID_BIT = 14;
    public static final int CUSTOM_DATA = 15;

    private ActivityCell() {
    }

    public ActivityCell(long resourceId, long activityId) {
        this.setValueInternal(1, resourceId);
        this.setValueInternal(2, activityId);
    }

    public ActivityCell(long resourceId, long activityId, Date startTime, Date endTime, String text, String tooltipText, String iconId, float majorValue, float minorValue) {
        this.setValueInternal(1, resourceId);
        this.setValueInternal(2, activityId);
        this.setValueInternal(3, startTime);
        this.setValueInternal(4, endTime);
        this.setValueInternal(5, text);
        this.setValueInternal(13, tooltipText);
        this.setValueInternal(14, iconId);
        this.setValueInternal(8, Float.valueOf(majorValue));
        this.setValueInternal(10, Float.valueOf(minorValue));
    }

    public ActivityCell(Object[] row) {
        if (row == null || row.length < 2) {
            throw new IllegalArgumentException("row must not be null or shorted than 2 elements");
        }
        if (row[0] == null) {
            throw new IllegalArgumentException("resourceId must not be null");
        }
        if (row[1] == null) {
            throw new IllegalArgumentException("itemid must not be null");
        }
        int i = 0;
        while (i < row.length) {
            if (row[i] != null) {
                switch (i) {
                    case 0: {
                        this.setValueInternal(1, ((Number)row[i]).longValue());
                        break;
                    }
                    case 1: {
                        this.setValueInternal(2, ((Number)row[i]).longValue());
                        break;
                    }
                    case 2: {
                        this.setValueInternal(3, row[i]);
                        break;
                    }
                    case 3: {
                        this.setValueInternal(4, row[i]);
                        break;
                    }
                    case 4: {
                        this.setText((String)row[i]);
                        break;
                    }
                    case 5: {
                        this.setTooltipText((String)row[i]);
                        break;
                    }
                    case 6: {
                        this.setIconId((String)row[i]);
                        break;
                    }
                    case 7: {
                        this.setMajorValue(((Number)row[i]).floatValue());
                        break;
                    }
                    case 8: {
                        this.setMinorValue(((Number)row[i]).floatValue());
                    }
                }
            }
            ++i;
        }
    }

    public IActivityCellObserver getObserver() {
        return (IActivityCellObserver)this.getValueInternal(0);
    }

    public void setObserver(IActivityCellObserver observer) {
        this.setValueInternal(0, observer);
    }

    protected boolean setValueInternal(int bitPos, Object o) {
        boolean b = super.setValueInternal(bitPos, o);
        if (this.getObserver() != null && bitPos != 0) {
            this.getObserver().cellChanged(this, bitPos);
        }
        return b;
    }

    public long getActivityId() {
        Object o = this.getValueInternal(2);
        return o != null ? (Long)o : null;
    }

    public long getResourceId() {
        Object o = this.getValueInternal(1);
        return o != null ? (Long)o : null;
    }

    public Date getBeginTime() {
        return (Date)this.getValueInternal(3);
    }

    public void setBeginTime(Date d) {
        this.setValueInternal(3, d);
    }

    public Date getEndTime() {
        return (Date)this.getValueInternal(4);
    }

    public void setEndTime(Date d) {
        this.setValueInternal(4, d);
    }

    public int getDurationMinutes() {
        Integer o = (Integer)this.getValueInternal(12);
        return o != null ? o : 0;
    }

    public float getMajorValue() {
        Float o = (Float)this.getValueInternal(8);
        return o != null ? o.floatValue() : 0.0f;
    }

    public void setMajorValue(float f) {
        this.setValueInternal(8, Float.valueOf(f));
    }

    public float getMinorValue() {
        Float o = (Float)this.getValueInternal(10);
        return o != null ? o.floatValue() : 0.0f;
    }

    public void setMinorValue(float f) {
        this.setValueInternal(10, Float.valueOf(f));
    }

    public String getMajorColor() {
        return (String)this.getValueInternal(9);
    }

    public void setMajorColor(String s) {
        this.setValueInternal(9, s);
    }

    public String getMinorColor() {
        return (String)this.getValueInternal(11);
    }

    public void setMinorColor(String s) {
        this.setValueInternal(11, s);
    }

    public String getTooltipText() {
        return (String)this.getValueInternal(13);
    }

    public void setTooltipText(String s) {
        this.setValueInternal(13, s);
    }

    public String getText() {
        return (String)this.getValueInternal(5);
    }

    public void setText(String s) {
        this.setValueInternal(5, s);
    }

    public String getIconId() {
        return (String)this.getValueInternal(14);
    }

    public void setIconId(String icon) {
        this.setValueInternal(14, icon);
    }

    public String getBackgroundColor() {
        return (String)this.getValueInternal(6);
    }

    public void setBackgroundColor(String c) {
        this.setValueInternal(6, c);
    }

    public String getForegroundColor() {
        return (String)this.getValueInternal(7);
    }

    public void setForegroundColor(String c) {
        this.setValueInternal(7, c);
    }

    public Object getCustomData() {
        return this.getValueInternal(15);
    }

    public void setCustomData(Object o) {
        this.setValueInternal(15, o);
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "[" + this.getText() + "]";
    }
}

