/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.tree.IActionNode;

public class ActionFinder {
    public <T extends IAction> T findAction(IAction[] actionTree, Class<T> searchType) {
        return this.findAction(Arrays.asList(actionTree), searchType);
    }

    public <T extends IAction> T findAction(List<? extends IAction> actionTree, Class<T> searchType) {
        for (IAction iAction : actionTree) {
            T t;
            if (searchType.isAssignableFrom(iAction.getClass())) {
                return (T)iAction;
            }
            if (!(iAction instanceof IActionNode) || (t = this.findAction(((IActionNode)iAction).getChildActions(), searchType)) == null) continue;
            return t;
        }
        return null;
    }

    public <T extends IAction> List<T> findActions(IAction[] actionTree, Class<T> searchType) {
        return this.findActions(Arrays.asList(actionTree), searchType);
    }

    public <T extends IAction> List<T> findActions(List<? extends IAction> actionTree, Class<T> searchType) {
        ArrayList list = new ArrayList();
        for (IAction iAction : actionTree) {
            this.findActionsRec(iAction, searchType, list);
        }
        return list;
    }

    private <T extends IAction> void findActionsRec(IAction parent, Class<T> searchType, List<T> list) {
        if (searchType.isAssignableFrom(parent.getClass())) {
            list.add(parent);
        }
        if (parent instanceof IActionNode) {
            for (IAction a : ((IActionNode)parent).getChildActions()) {
                this.findActionsRec(a, searchType, list);
            }
        }
    }
}

