/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.pwd;

import java.util.Date;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.form.useradmin.DefaultPasswordForm;
import org.eclipse.scout.rt.client.ui.messagebox.MessageBox;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.common.pwd.IPasswordManagementService;
import org.eclipse.scout.service.SERVICES;

public class PasswordPolicyVerifier {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(PasswordPolicyVerifier.class);

    public boolean verify(String userId, int warnInAdvanceDays) {
        IPasswordManagementService service = (IPasswordManagementService)SERVICES.getService(IPasswordManagementService.class);
        if (service == null) {
            LOG.error("missing client service proxy for " + IPasswordManagementService.class.getName() + "; check plugin extensions");
            return false;
        }
        IDesktop desktop = ClientSyncJob.getCurrentSession().getDesktop();
        if (desktop == null) {
            LOG.error("desktop is null");
            return false;
        }
        if (!desktop.isOpened()) {
            LOG.error("desktop is available, but there is not yet a GUI attached. Make sure to calll this verifier at earliest in the Desktop.execGuiAvailable callback");
            return false;
        }
        try {
            boolean changeNow = false;
            Date now = new Date();
            Date expiryDate = service.getPasswordExpirationDate(userId);
            if (expiryDate.after(now)) {
                int answer;
                long remainDays = (expiryDate.getTime() - now.getTime()) / 3600000L / 24L;
                if (remainDays < (long)warnInAdvanceDays && (answer = MessageBox.showYesNoCancelMessage(ScoutTexts.get((String)"PasswordWillExpireTitle", (String[])new String[0]), remainDays == 0L ? ScoutTexts.get((String)"PasswordWillExpireHeaderX", (String[])new String[]{ScoutTexts.get((String)"Today", (String[])new String[0])}) : (remainDays == 1L ? ScoutTexts.get((String)"PasswordWillExpireHeaderX", (String[])new String[]{ScoutTexts.get((String)"Tomorrow", (String[])new String[0])}) : ScoutTexts.get((String)"PasswordWillExpireHeaderX", (String[])new String[]{ScoutTexts.get((String)"InDaysX", (String[])new String[]{"" + remainDays})})), ScoutTexts.get((String)"PasswordWillExpireInfo", (String[])new String[0]))) == 0) {
                    changeNow = true;
                }
            } else {
                MessageBox.showOkMessage(ScoutTexts.get((String)"PasswordHasExpiredTitle", (String[])new String[0]), ScoutTexts.get((String)"PasswordHasExpiredHeader", (String[])new String[0]), null);
                changeNow = true;
            }
            if (changeNow) {
                this.callPasswordForm(userId);
                expiryDate = service.getPasswordExpirationDate(userId);
            }
            return expiryDate.after(now);
        }
        catch (Throwable t) {
            ProcessingException pe = t instanceof ProcessingException ? (ProcessingException)t : new ProcessingException("Unexpected", t);
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(pe);
            return false;
        }
    }

    protected void callPasswordForm(String userId) throws ProcessingException {
        DefaultPasswordForm form = new DefaultPasswordForm();
        form.setUserId(userId);
        form.startChange();
        form.waitFor();
    }
}

