/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.java.internal;

import java.util.SortedSet;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.ReferenceValue;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeConstraintBehavior;
import org.eclipse.sapphire.java.JavaTypeConstraintService;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.java.JavaTypeName;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ValidationService;

public final class JavaTypeValidationService
extends ValidationService {
    @Text(value="Class {0} does not implement or extend {1}")
    private static LocalizableText classDoesNotImplementOrExtend;
    @Text(value="Interface {0} does not extend {1}")
    private static LocalizableText interfaceDoesNotExtend;
    @Text(value="Class {0} does not implement or extend one of [{1}]")
    private static LocalizableText classDoesNotImplementOrExtendOneOf;
    @Text(value="Interface {0} does not extend one of [{1}]")
    private static LocalizableText interfaceDoesNotExtendOneOf;
    @Text(value="Type {0} is an abstract class, which is not allowed for {1}")
    private static LocalizableText abstractClassNotAllowed;
    @Text(value="Type {0} is a class, which is not allowed for {1}")
    private static LocalizableText classNotAllowed;
    @Text(value="Type {0} is an interface, which is not allowed for {1}")
    private static LocalizableText interfaceNotAllowed;
    @Text(value="Type {0} is an annotation, which is not allowed for {1}")
    private static LocalizableText annotationNotAllowed;
    @Text(value="Type {0} is an enum, which is not allowed for {1}")
    private static LocalizableText enumNotAllowed;

    static {
        LocalizableText.init(JavaTypeValidationService.class);
    }

    protected void initValidationService() {
        Property property = (Property)this.context(Property.class);
        JavaTypeConstraintService javaTypeConstraintService = (JavaTypeConstraintService)property.service(JavaTypeConstraintService.class);
        if (javaTypeConstraintService != null) {
            javaTypeConstraintService.attach(new Listener(){

                public void handle(Event event) {
                    JavaTypeValidationService.this.refresh();
                }
            });
        }
    }

    protected Status compute() {
        ReferenceValue value = (ReferenceValue)this.context(ReferenceValue.class);
        JavaTypeConstraintService javaTypeConstraintService = (JavaTypeConstraintService)value.service(JavaTypeConstraintService.class);
        if (javaTypeConstraintService == null) {
            return Status.createOkStatus();
        }
        SortedSet<JavaTypeKind> kinds = javaTypeConstraintService.kinds();
        SortedSet<String> requiredBaseTypes = javaTypeConstraintService.types();
        JavaTypeConstraintBehavior behavior = javaTypeConstraintService.behavior();
        String val = value.text(false);
        if (val != null) {
            JavaType type = (JavaType)value.resolve();
            if (type == null) {
                return Status.createOkStatus();
            }
            JavaTypeKind kind = type.kind();
            switch (kind) {
                case CLASS: {
                    if (kinds.contains((Object)JavaTypeKind.CLASS)) break;
                    String label = value.definition().getLabel(true, CapitalizationType.NO_CAPS, false);
                    String msg = classNotAllowed.format(new Object[]{val, label});
                    return Status.createErrorStatus((String)msg);
                }
                case ABSTRACT_CLASS: {
                    if (kinds.contains((Object)JavaTypeKind.ABSTRACT_CLASS)) break;
                    String label = value.definition().getLabel(true, CapitalizationType.NO_CAPS, false);
                    String msg = abstractClassNotAllowed.format(new Object[]{val, label});
                    return Status.createErrorStatus((String)msg);
                }
                case INTERFACE: {
                    if (kinds.contains((Object)JavaTypeKind.INTERFACE)) break;
                    String label = value.definition().getLabel(true, CapitalizationType.NO_CAPS, false);
                    String msg = interfaceNotAllowed.format(new Object[]{val, label});
                    return Status.createErrorStatus((String)msg);
                }
                case ANNOTATION: {
                    if (kinds.contains((Object)JavaTypeKind.ANNOTATION)) break;
                    String label = value.definition().getLabel(true, CapitalizationType.NO_CAPS, false);
                    String msg = annotationNotAllowed.format(new Object[]{val, label});
                    return Status.createErrorStatus((String)msg);
                }
                case ENUM: {
                    if (kinds.contains((Object)JavaTypeKind.ENUM)) break;
                    String label = value.definition().getLabel(true, CapitalizationType.NO_CAPS, false);
                    String msg = enumNotAllowed.format(new Object[]{val, label});
                    return Status.createErrorStatus((String)msg);
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (kind != JavaTypeKind.ENUM && kind != JavaTypeKind.ANNOTATION) {
                if (behavior == JavaTypeConstraintBehavior.ALL) {
                    for (String baseType : requiredBaseTypes) {
                        if (type.isOfType(baseType)) continue;
                        LocalizableText template = type.kind() == JavaTypeKind.INTERFACE ? interfaceDoesNotExtend : classDoesNotImplementOrExtend;
                        String msg = template.format(new Object[]{val, baseType});
                        return Status.createErrorStatus((String)msg);
                    }
                } else {
                    boolean satisfied = false;
                    for (String baseType : requiredBaseTypes) {
                        if (!type.isOfType(baseType)) continue;
                        satisfied = true;
                        break;
                    }
                    if (!satisfied) {
                        StringBuilder list = new StringBuilder();
                        for (String baseType : requiredBaseTypes) {
                            if (list.length() > 0) {
                                list.append(", ");
                            }
                            list.append(baseType);
                        }
                        LocalizableText template = type.kind() == JavaTypeKind.INTERFACE ? interfaceDoesNotExtendOneOf : classDoesNotImplementOrExtendOneOf;
                        String msg = template.format(new Object[]{val, list.toString()});
                        return Status.createErrorStatus((String)msg);
                    }
                }
            }
        }
        return Status.createOkStatus();
    }

    public static final class Condition
    extends ServiceCondition {
        public boolean applicable(ServiceContext context) {
            Reference referenceAnnotation;
            Property property = (Property)context.find(Property.class);
            if (property != null && property.definition().getTypeClass() == JavaTypeName.class && (referenceAnnotation = (Reference)property.definition().getAnnotation(Reference.class)) != null && referenceAnnotation.target() == JavaType.class) {
                return property.service(JavaTypeConstraintService.class) != null;
            }
            return false;
        }
    }
}

