/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.textsize;

import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.ProtocolMessageWriter;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.textsize.MeasurementItem;
import org.eclipse.rap.rwt.internal.textsize.MeasurementOperator;
import org.eclipse.rap.rwt.internal.textsize.Probe;
import org.eclipse.rap.rwt.service.UISession;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.internal.graphics.FontUtil;

public class MeasurementUtil {
    private static final String ATTR_OPERATOR = String.valueOf(MeasurementUtil.class.getName()) + "#operator";

    public static void installMeasurementOperator(UISession uiSession) {
        uiSession.setAttribute(ATTR_OPERATOR, new MeasurementOperator());
    }

    public static void appendStartupTextSizeProbe(ProtocolMessageWriter writer) {
        JsonArray startupProbes = MeasurementUtil.getStartupProbes();
        if (!startupProbes.isEmpty()) {
            JsonObject parameters = new JsonObject().add("items", startupProbes);
            writer.appendCall("rwt.client.TextSizeMeasurement", "measureItems", parameters);
        }
    }

    private static JsonArray getStartupProbes() {
        Probe[] probes = ContextProvider.getApplicationContext().getProbeStore().getProbes();
        JsonArray result = new JsonArray();
        Probe[] probeArray = probes;
        int n = probes.length;
        int n2 = 0;
        while (n2 < n) {
            Probe probe = probeArray[n2];
            result.add(MeasurementUtil.createProbeParamObject(probe));
            ++n2;
        }
        return result;
    }

    public static void renderMeasurementItems() {
        MeasurementUtil.getMeasurementOperator().renderMeasurementItems();
    }

    static void addItemToMeasure(String toMeasure, Font font, int wrapWidth, int mode) {
        FontData fontData = FontUtil.getData(font);
        MeasurementItem newItem = new MeasurementItem(toMeasure, fontData, wrapWidth, mode);
        MeasurementUtil.getMeasurementOperator().addItemToMeasure(newItem);
    }

    public static MeasurementOperator getMeasurementOperator() {
        UISession uiSession = ContextProvider.getUISession();
        return (MeasurementOperator)uiSession.getAttribute(ATTR_OPERATOR);
    }

    static JsonArray createItemParamObject(MeasurementItem item) {
        FontData fontData = item.getFontData();
        JsonArray result = new JsonArray().add(MeasurementUtil.getId(item)).add(item.getTextToMeasure()).add(JsonUtil.createJsonArray(ProtocolUtil.parseFontName(fontData.getName()))).add(fontData.getHeight()).add((fontData.getStyle() & 1) != 0).add((fontData.getStyle() & 2) != 0).add(item.getWrapWidth()).add(MeasurementUtil.isMarkup(item.getMode()));
        return result;
    }

    static JsonArray createProbeParamObject(Probe probe) {
        FontData fontData = probe.getFontData();
        JsonArray result = new JsonArray().add(MeasurementUtil.getId(probe)).add(probe.getText()).add(JsonUtil.createJsonArray(ProtocolUtil.parseFontName(fontData.getName()))).add(fontData.getHeight()).add((fontData.getStyle() & 1) != 0).add((fontData.getStyle() & 2) != 0).add(-1).add(true);
        return result;
    }

    static String getId(Probe probe) {
        return MeasurementUtil.getId(probe.getFontData());
    }

    static String getId(MeasurementItem item) {
        return "t" + Integer.toString(item.hashCode());
    }

    static String getId(FontData fontData) {
        return "p" + Integer.toString(fontData.hashCode());
    }

    private static boolean isMarkup(int mode) {
        return mode == 2;
    }

    private MeasurementUtil() {
    }
}

