/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.service;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rap.rwt.internal.application.ApplicationContextImpl;
import org.eclipse.rap.rwt.internal.protocol.ProtocolMessageWriter;
import org.eclipse.rap.rwt.internal.service.ServiceStore;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.rap.rwt.service.UISession;

public final class ServiceContext {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private ServiceStore serviceStore;
    private boolean disposed;
    private UISession uiSession;
    private ApplicationContextImpl applicationContext;
    private ProtocolMessageWriter protocolWriter;

    public ServiceContext(HttpServletRequest request, HttpServletResponse response, ApplicationContextImpl applicationContext) {
        this.request = request;
        this.response = response;
        this.applicationContext = applicationContext;
    }

    public ServiceContext(HttpServletRequest request, HttpServletResponse response, UISession uiSession) {
        this.request = request;
        this.response = response;
        this.uiSession = uiSession;
        this.applicationContext = (ApplicationContextImpl)uiSession.getApplicationContext();
    }

    public HttpServletRequest getRequest() {
        this.checkState();
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletResponse getResponse() {
        this.checkState();
        return this.response;
    }

    public ServiceStore getServiceStore() {
        this.checkState();
        return this.serviceStore;
    }

    public void setServiceStore(ServiceStore serviceStore) {
        this.checkState();
        ParamCheck.notNull(serviceStore, "serviceStore");
        if (this.serviceStore != null) {
            String msg = "ServiceStore is already set and must not be replaced.";
            throw new IllegalStateException(msg);
        }
        this.serviceStore = serviceStore;
    }

    public ProtocolMessageWriter getProtocolWriter() {
        this.checkState();
        if (this.protocolWriter == null) {
            this.protocolWriter = new ProtocolMessageWriter();
        }
        return this.protocolWriter;
    }

    public void resetProtocolWriter() {
        this.protocolWriter = new ProtocolMessageWriter();
    }

    public UISession getUISession() {
        this.checkState();
        if (this.uiSession != null && !this.uiSession.isBound()) {
            this.uiSession = null;
        }
        return this.uiSession;
    }

    public void setUISession(UISession uiSession) {
        this.uiSession = uiSession;
    }

    public ApplicationContextImpl getApplicationContext() {
        this.checkState();
        if (this.applicationContext != null && this.applicationContext.isActive()) {
            return this.applicationContext;
        }
        return null;
    }

    public void dispose() {
        this.checkState();
        this.request = null;
        this.response = null;
        this.serviceStore = null;
        this.uiSession = null;
        this.applicationContext = null;
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    private void checkState() {
        if (this.disposed) {
            throw new IllegalStateException("The context has been disposed.");
        }
    }
}

