/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.p2.internal.aspect;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.packagedrone.repo.adapter.p2.internal.aspect.ArtifactStreamer;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.utils.io.IOConsumer;
import org.w3c.dom.Document;

public class DocumentCache {
    private final Map<String, Document> cacheMap = new HashMap<String, Document>(1024);
    private final DocumentBuilder documentBuilder;

    public DocumentCache(DocumentBuilder documentBuilder) {
        this.documentBuilder = documentBuilder;
    }

    public void stream(ArtifactInformation artifact, ArtifactStreamer streamer, DocumentConsumer consumer) throws Exception {
        String key = artifact.getId();
        Document doc = this.cacheMap.get(key);
        if (doc != null) {
            consumer.accept(artifact, doc);
        } else {
            streamer.stream(artifact.getId(), (IOConsumer<InputStream>)((IOConsumer)stream -> {
                try {
                    Document newDoc = this.documentBuilder.parse((InputStream)stream);
                    this.cacheMap.put(key, newDoc);
                    consumer.accept(artifact, newDoc);
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }));
        }
    }

    @FunctionalInterface
    public static interface DocumentConsumer {
        public void accept(ArtifactInformation var1, Document var2) throws Exception;
    }
}

