/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.manage.core.web;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.eclipse.packagedrone.repo.MetaKeys;
import org.eclipse.packagedrone.repo.manage.core.CoreService;
import org.eclipse.packagedrone.repo.manage.core.web.SiteInformation;
import org.eclipse.packagedrone.repo.manage.system.SystemService;
import org.eclipse.packagedrone.sec.web.controller.HttpConstraints;
import org.eclipse.packagedrone.sec.web.controller.HttpContraintControllerInterceptor;
import org.eclipse.packagedrone.sec.web.controller.Secured;
import org.eclipse.packagedrone.sec.web.controller.SecuredControllerInterceptor;
import org.eclipse.packagedrone.web.Controller;
import org.eclipse.packagedrone.web.LinkTarget;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.RequestMapping;
import org.eclipse.packagedrone.web.RequestMethod;
import org.eclipse.packagedrone.web.ViewResolver;
import org.eclipse.packagedrone.web.common.InterfaceExtender;
import org.eclipse.packagedrone.web.common.menu.MenuEntry;
import org.eclipse.packagedrone.web.controller.ControllerInterceptor;
import org.eclipse.packagedrone.web.controller.ControllerInterceptors;
import org.eclipse.packagedrone.web.controller.binding.BindingResult;
import org.eclipse.packagedrone.web.controller.form.FormData;

@Controller
@ViewResolver(value="/WEB-INF/views/%s.jsp")
@Secured
@RequestMapping(value={"/config/core"})
@ControllerInterceptors(value={@ControllerInterceptor(value=SecuredControllerInterceptor.class), @ControllerInterceptor(value=HttpContraintControllerInterceptor.class)})
@HttpConstraint(rolesAllowed={"ADMIN"})
public class CoreController
implements InterfaceExtender {
    private CoreService coreService;
    private SystemService systemService;
    private static final LinkTarget.ControllerMethod METHOD_LIST = LinkTarget.getControllerMethod(CoreController.class, (String)"list");
    private static final LinkTarget.ControllerMethod METHOD_SITE = LinkTarget.getControllerMethod(CoreController.class, (String)"site");

    public void setCoreService(CoreService service) {
        this.coreService = service;
    }

    public void setSystemService(SystemService systemService) {
        this.systemService = systemService;
    }

    public List<MenuEntry> getMainMenuEntries(HttpServletRequest request) {
        LinkedList<MenuEntry> result = new LinkedList<MenuEntry>();
        if (HttpConstraints.isCallAllowed((LinkTarget.ControllerMethod)METHOD_LIST, (HttpServletRequest)request)) {
            result.add(new MenuEntry("Administration", 1000, "View properties", 1000, LinkTarget.createFromController((LinkTarget.ControllerMethod)METHOD_LIST), null, null));
        }
        if (HttpConstraints.isCallAllowed((LinkTarget.ControllerMethod)METHOD_SITE, (HttpServletRequest)request)) {
            result.add(new MenuEntry("Administration", 1000, "Site", 500, LinkTarget.createFromController((LinkTarget.ControllerMethod)METHOD_SITE), null, null));
        }
        return result;
    }

    @RequestMapping(value={"/list"})
    public ModelAndView list() {
        HashMap model = new HashMap(1);
        model.put("properties", new TreeMap(this.coreService.list()));
        return new ModelAndView("list", model);
    }

    @RequestMapping(value={"/site"})
    public ModelAndView site() {
        HashMap<String, Object> model = new HashMap<String, Object>();
        Map props = this.coreService.list();
        SiteInformation site = new SiteInformation();
        try {
            MetaKeys.bind((Object)site, (Map)props);
        }
        catch (Exception exception) {}
        this.fillModel(model, site);
        return new ModelAndView("site", model);
    }

    protected void fillModel(Map<String, Object> model, SiteInformation site) {
        model.put("command", site);
        model.put("defaultSitePrefix", this.systemService.getDefaultSitePrefix());
    }

    @RequestMapping(value={"/site"}, method={RequestMethod.POST})
    public ModelAndView sitePost(@Valid @FormData(value="command") SiteInformation site, BindingResult result) throws Exception {
        HashMap<String, Object> model = new HashMap<String, Object>();
        if (!result.hasErrors()) {
            Map props = MetaKeys.unbind((Object)site);
            this.coreService.setCoreProperties(props);
        }
        this.fillModel(model, site);
        return new ModelAndView("site", model);
    }
}

