/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.web;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.channel.transfer.TransferService;
import org.eclipse.packagedrone.repo.channel.web.ExportAllFileSystemCommand;
import org.eclipse.packagedrone.sec.web.controller.HttpContraintControllerInterceptor;
import org.eclipse.packagedrone.sec.web.controller.Secured;
import org.eclipse.packagedrone.sec.web.controller.SecuredControllerInterceptor;
import org.eclipse.packagedrone.utils.Strings;
import org.eclipse.packagedrone.web.Controller;
import org.eclipse.packagedrone.web.LinkTarget;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.RequestMapping;
import org.eclipse.packagedrone.web.RequestMethod;
import org.eclipse.packagedrone.web.ViewResolver;
import org.eclipse.packagedrone.web.common.CommonController;
import org.eclipse.packagedrone.web.common.InterfaceExtender;
import org.eclipse.packagedrone.web.common.menu.MenuEntry;
import org.eclipse.packagedrone.web.controller.ControllerInterceptor;
import org.eclipse.packagedrone.web.controller.ControllerInterceptors;
import org.eclipse.packagedrone.web.controller.binding.BindingError;
import org.eclipse.packagedrone.web.controller.binding.BindingResult;
import org.eclipse.packagedrone.web.controller.binding.MessageBindingError;
import org.eclipse.packagedrone.web.controller.form.FormData;
import org.eclipse.packagedrone.web.controller.validator.ControllerValidator;
import org.eclipse.packagedrone.web.controller.validator.ValidationContext;

@Secured
@Controller
@ViewResolver(value="/WEB-INF/views/global/%s.jsp")
@ControllerInterceptors(value={@ControllerInterceptor(value=SecuredControllerInterceptor.class), @ControllerInterceptor(value=HttpContraintControllerInterceptor.class)})
@HttpConstraint(rolesAllowed={"MANAGER"})
public class StorageController
implements InterfaceExtender {
    private ChannelService service;
    private TransferService transferService;

    public void setService(ChannelService service) {
        this.service = service;
    }

    public void setTransferService(TransferService transferService) {
        this.transferService = transferService;
    }

    @RequestMapping(value={"/system/storage"})
    @HttpConstraint(rolesAllowed={"MANAGER", "ADMIN"})
    public ModelAndView index() {
        HashMap model = new HashMap();
        return new ModelAndView("index", model);
    }

    @RequestMapping(value={"/system/storage/wipe"}, method={RequestMethod.POST})
    public ModelAndView wipe() {
        this.service.wipeClean();
        return new ModelAndView("redirect:/channel");
    }

    @HttpConstraint(rolesAllowed={"ADMIN"})
    @RequestMapping(value={"/system/storage/exportAllFs"}, method={RequestMethod.GET})
    public ModelAndView exportAllFs() {
        return new ModelAndView("exportAllFs");
    }

    @HttpConstraint(rolesAllowed={"ADMIN"})
    @RequestMapping(value={"/system/storage/exportAllFs"}, method={RequestMethod.POST})
    public ModelAndView exportAllFsPost(@Valid @FormData(value="command") ExportAllFileSystemCommand command, BindingResult result) {
        File location;
        if (result.hasErrors()) {
            return new ModelAndView("exportAllFs");
        }
        try {
            location = this.performExport(command);
        }
        catch (IOException e) {
            return CommonController.createError((String)"Spool out", null, (Throwable)e, (Boolean)true);
        }
        String bytes = Strings.bytes((long)location.length());
        return CommonController.createSuccess((String)"Spool out", (String)"to file system", (String)String.format("<strong>Complete!</strong> Successfully spooled out all channels to <code>%s</code> (%s)", location, bytes));
    }

    public File performExport(ExportAllFileSystemCommand command) throws IOException {
        File file = new File(command.getLocation()).getAbsoluteFile();
        Files.createFile(file.toPath(), new FileAttribute[0]);
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));){
            this.transferService.exportAll((OutputStream)stream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return file;
    }

    @ControllerValidator(formDataClass=ExportAllFileSystemCommand.class)
    public void validateExportAll(ExportAllFileSystemCommand command, ValidationContext ctx) {
        String locationString = command.getLocation();
        if (locationString == null || locationString.isEmpty()) {
            return;
        }
        File location = new File(locationString).getAbsoluteFile();
        if (location.isDirectory()) {
            ctx.error("location", (BindingError)new MessageBindingError(String.format("'%s' must not be an existing directory", location)));
            return;
        }
        if (location.exists()) {
            ctx.error("location", (BindingError)new MessageBindingError(String.format("'%s' must not exist", location)));
            return;
        }
        if (!location.getParentFile().isDirectory()) {
            ctx.error("location", (BindingError)new MessageBindingError(String.format("'%s' must be an existing directory", location.getParentFile())));
            return;
        }
        if (!location.getParentFile().canWrite()) {
            ctx.error("location", (BindingError)new MessageBindingError(String.format("'%s' must be writable by the server", location.getParentFile())));
            return;
        }
    }

    public List<MenuEntry> getMainMenuEntries(HttpServletRequest request) {
        LinkedList<MenuEntry> result = new LinkedList<MenuEntry>();
        if (request.isUserInRole("MANAGER")) {
            result.add(new MenuEntry("System", Integer.MAX_VALUE, "Storage", 200, LinkTarget.createFromController(StorageController.class, (String)"index"), null, null));
        }
        return result;
    }
}

