/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.maven.upload;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.packagedrone.repo.adapter.maven.upload.Uploader;

public class Options {
    private static final Options DEFAULT_OPTIONS = new Options();
    private Set<String> ignoreExtensions;
    private Set<String> checksumExtensions;
    private Uploader.NoParentMode noParentMode;

    public Options() {
        this(DEFAULT_OPTIONS);
    }

    public Options(Options other) {
        if (other != null) {
            this.ignoreExtensions = new HashSet<String>(other.ignoreExtensions);
            this.checksumExtensions = new HashSet<String>(other.checksumExtensions);
            this.noParentMode = other.noParentMode;
        } else {
            this.ignoreExtensions = new HashSet<String>();
            this.checksumExtensions = new HashSet<String>(Arrays.asList("md5", "sha1"));
            this.noParentMode = Uploader.NoParentMode.IGNORE;
        }
    }

    public void setChecksumExtensions(Collection<String> checksumExtensions) {
        Objects.requireNonNull(checksumExtensions, "checksumExtensions");
        this.checksumExtensions = new HashSet<String>(checksumExtensions);
    }

    public Set<String> getChecksumExtensions() {
        return this.checksumExtensions;
    }

    public void setIgnoreExtensions(Collection<String> ignoreExtensions) {
        Objects.requireNonNull(ignoreExtensions, "ignoreExtensions");
        this.ignoreExtensions = new HashSet<String>(ignoreExtensions);
    }

    public Set<String> getIgnoreExtensions() {
        return this.ignoreExtensions;
    }

    public void setNoParentMode(Uploader.NoParentMode noParentMode) {
        Objects.requireNonNull(noParentMode, "noParentMode");
        this.noParentMode = noParentMode;
    }

    public Uploader.NoParentMode getNoParentMode() {
        return this.noParentMode;
    }
}

