/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.trigger.http;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import javax.servlet.Servlet;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.channel.ModifiableChannel;
import org.eclipse.packagedrone.repo.manage.system.SitePrefixService;
import org.eclipse.packagedrone.repo.trigger.ConfiguredTrigger;
import org.eclipse.packagedrone.repo.trigger.ConfiguredTriggerHandler;
import org.eclipse.packagedrone.repo.trigger.TriggerDescriptor;
import org.eclipse.packagedrone.repo.trigger.http.HttpTriggerConfiguration;
import org.eclipse.packagedrone.repo.trigger.http.TriggerServlet;
import org.osgi.service.http.HttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTrigger
implements ConfiguredTrigger {
    private static final Logger logger = LoggerFactory.getLogger(HttpTrigger.class);
    private final HttpService httpService;
    private final SitePrefixService prefixService;
    private final HttpTriggerConfiguration configuration;
    private final ChannelService channelService;
    private boolean registered;

    public HttpTrigger(SitePrefixService prefixService, HttpService httpService, HttpTriggerConfiguration configuration, ChannelService channelService) {
        this.prefixService = prefixService;
        this.httpService = httpService;
        this.configuration = configuration;
        this.channelService = channelService;
    }

    public void start(ConfiguredTriggerHandler context) throws Exception {
        String alias = this.makeAlias();
        logger.info("Registering trigger servlet: {}", (Object)alias);
        TriggerServlet servlet = new TriggerServlet(() -> this.runTrigger(context));
        Hashtable initparams = new Hashtable();
        this.httpService.registerServlet(alias, (Servlet)servlet, initparams, null);
        this.registered = true;
    }

    private void runTrigger(ConfiguredTriggerHandler context) {
        this.channelService.accessRun(ChannelService.By.id((String)context.getChannelId()), ModifiableChannel.class, arg_0 -> ((ConfiguredTriggerHandler)context).run(arg_0));
    }

    private String makeAlias() {
        return "/trigger/" + this.configuration.getEndpoint();
    }

    public TriggerDescriptor getState() {
        return new TriggerDescriptor(){

            public Class<?>[] getSupportedContexts() {
                return new Class[]{ModifiableChannel.class};
            }

            public String getLabel() {
                return "HTTP endpoint trigger";
            }

            public String getDescription() {
                return "This trigger will provide an HTTP endpoint which activates the trigger when getting called";
            }

            public String getHtmlState() {
                return HttpTrigger.this.renderHtmlState();
            }
        };
    }

    protected String renderHtmlState() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        String prefix = this.prefixService.getSitePrefix();
        pw.format("Run the trigger when a <code>POST</code> request is being made to: <a href=\"%1$s\">%1$s</a>", String.valueOf(prefix) + this.makeAlias());
        return sw.toString();
    }

    public void stop() {
        if (this.registered) {
            String alias = this.makeAlias();
            logger.info("Un-registering trigger servlet: {}", (Object)alias);
            this.httpService.unregister(alias);
            this.registered = false;
        }
    }
}

