/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.impl;

import java.util.Map;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.channel.impl.ChannelProviderTracker;
import org.eclipse.packagedrone.repo.channel.impl.ProviderListener;
import org.eclipse.packagedrone.repo.channel.provider.Channel;
import org.eclipse.packagedrone.repo.channel.provider.ChannelProvider;

public class ChannelInstance
implements ProviderListener {
    private Channel channel;
    private final @NonNull String channelId;
    private final @NonNull String providerId;
    private final @NonNull Map<MetaKey, String> configuration;
    private final @NonNull ChannelProviderTracker providerTracker;

    public ChannelInstance(@NonNull String channelId, @NonNull String providerId, @NonNull Map<MetaKey, String> configuration, @NonNull ChannelProviderTracker providerTracker) {
        this.channelId = channelId;
        this.providerId = providerId;
        this.configuration = configuration;
        this.providerTracker = providerTracker;
        providerTracker.addListener(providerId, this);
    }

    public @NonNull String getChannelId() {
        return this.channelId;
    }

    public @NonNull String getProviderId() {
        return this.providerId;
    }

    public @NonNull Map<MetaKey, String> getConfiguration() {
        return this.configuration;
    }

    public @NonNull Optional<Channel> getChannel() {
        return Optional.ofNullable(this.channel);
    }

    @Override
    public void bind(@NonNull ChannelProvider provider) {
        this.channel = provider.load(this.channelId, this.configuration);
    }

    @Override
    public void unbind() {
        if (this.channel != null) {
            this.channel.dispose();
            this.channel = null;
        }
    }

    public void dispose() {
        this.providerTracker.removeListener(this.providerId, this);
        this.unbind();
    }
}

