/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.p2.internal.servlet;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.packagedrone.repo.adapter.p2.internal.aspect.ChannelStreamer;
import org.eclipse.packagedrone.repo.aspect.common.osgi.OsgiExtractor;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.channel.ReadableChannel;
import org.eclipse.packagedrone.repo.servlet.Handler;
import org.eclipse.packagedrone.utils.io.IOConsumer;

public class ZippedHandler
implements Handler {
    private final ReadableChannel channel;
    private final Set<String> nameCache = new HashSet<String>();

    public ZippedHandler(ReadableChannel channel) {
        this.channel = channel;
    }

    public void process(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.nameCache.clear();
        resp.setContentType("application/zip");
        ZipOutputStream zos = new ZipOutputStream((OutputStream)resp.getOutputStream());
        String title = this.channel.getInformation().makeTitle();
        ChannelStreamer streamer = new ChannelStreamer(title, this.channel.getMetaData(), false, true);
        for (ArtifactInformation a : this.channel.getContext().getArtifacts().values()) {
            streamer.process(a, (String ai, IOConsumer<InputStream> receiver) -> {
                boolean bl = this.channel.getContext().stream(ai, receiver);
            });
            Map md = a.getMetaData();
            String classifier = (String)md.get(OsgiExtractor.KEY_CLASSIFIER);
            String symbolicName = (String)md.get(OsgiExtractor.KEY_NAME);
            String version = (String)md.get(OsgiExtractor.KEY_VERSION);
            if (classifier == null || symbolicName == null || version == null) continue;
            String name2 = String.format("%s_%s.jar", symbolicName, version);
            switch (classifier) {
                case "bundle": {
                    this.stream(zos, this.channel, a, "plugins/" + name2);
                    break;
                }
                case "eclipse.feature": {
                    this.stream(zos, this.channel, a, "features/" + name2);
                }
            }
        }
        streamer.spoolOut((id, name, mimeType, stream) -> {
            zos.putNextEntry(new ZipEntry(name));
            stream.accept((Object)zos);
            zos.closeEntry();
        });
        zos.close();
    }

    private void stream(ZipOutputStream zos, ReadableChannel channel, ArtifactInformation a, String name) throws IOException {
        if (!this.nameCache.add(name)) {
            return;
        }
        zos.putNextEntry(new ZipEntry(name));
        channel.getContext().stream(a, stream -> {
            long l = ByteStreams.copy((InputStream)stream, (OutputStream)zos);
        });
        zos.closeEntry();
    }
}

