/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal;

import java.util.concurrent.ConcurrentHashMap;
import org.ops4j.pax.web.extender.whiteboard.internal.WebApplication;
import org.osgi.framework.Bundle;

public class ExtenderContext {
    private final ConcurrentHashMap<ContextKey, WebApplication> webApplications = new ConcurrentHashMap();
    private final ConcurrentHashMap<WebApplication, Integer> sharedWebApplicationCounter = new ConcurrentHashMap();

    public WebApplication getWebApplication(Bundle bundle, String httpContextId, Boolean sharedHttpContext) {
        if (bundle == null) {
            return null;
        }
        ContextKey contextKey = new ContextKey(bundle, httpContextId, sharedHttpContext);
        WebApplication webApplication = this.webApplications.get(contextKey);
        if (webApplication == null) {
            webApplication = new WebApplication(bundle, httpContextId, sharedHttpContext);
            WebApplication existingWebApplication = this.webApplications.putIfAbsent(contextKey, webApplication);
            if (existingWebApplication == null) {
                webApplication.start();
            } else {
                webApplication = existingWebApplication;
            }
        }
        if (sharedHttpContext.booleanValue()) {
            Integer counter = this.sharedWebApplicationCounter.get(webApplication);
            if (counter == null) {
                counter = new Integer(0);
            }
            counter = counter + 1;
            this.sharedWebApplicationCounter.put(webApplication, counter);
        }
        return webApplication;
    }

    public WebApplication getExistingWebApplication(Bundle bundle, String httpContextId, Boolean sharedHttpContext) {
        if (bundle == null) {
            return null;
        }
        ContextKey contextKey = new ContextKey(bundle, httpContextId, sharedHttpContext);
        return this.webApplications.get(contextKey);
    }

    public void removeWebApplication(WebApplication webApplication) {
        ContextKey contextKey = new ContextKey(webApplication.getBundle(), webApplication.getHttpContextId(), webApplication.getSharedHttpContext());
        this.webApplications.remove(contextKey);
        webApplication.stop();
    }

    public Integer getSharedWebApplicationCounter(WebApplication webApplication) {
        return this.sharedWebApplicationCounter.get(webApplication);
    }

    public Integer reduceSharedWebApplicationCount(WebApplication webApplication) {
        Integer sharedCounter = this.sharedWebApplicationCounter.get(webApplication);
        if ((sharedCounter = Integer.valueOf(sharedCounter - 1)) <= 0) {
            this.sharedWebApplicationCounter.remove(webApplication);
        }
        return sharedCounter;
    }

    private static class ContextKey {
        Bundle bundle;
        String httpContextId;
        Boolean sharedHttpContext = false;

        private ContextKey(Bundle bundle, String httpContextId, Boolean sharedHttpContext) {
            this.bundle = bundle;
            this.httpContextId = httpContextId;
            this.sharedHttpContext = sharedHttpContext;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ContextKey that = (ContextKey)o;
            if (!this.sharedHttpContext.booleanValue() && (this.bundle != null ? !this.bundle.equals(that.bundle) : that.bundle != null)) {
                return false;
            }
            return !(this.httpContextId != null ? !this.httpContextId.equals(that.httpContextId) : that.httpContextId != null);
        }

        public int hashCode() {
            int result = this.sharedHttpContext == false ? (this.bundle != null ? this.bundle.hashCode() : 0) : 0;
            result = 31 * result + (this.httpContextId != null ? this.httpContextId.hashCode() : 0);
            return result;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{" + "bundle=" + this.bundle + ",httpContextId=" + this.httpContextId + "}";
        }
    }
}

