/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.ui.internal;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.IMenuService;

public class ShowPullDownMenu
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IMenuService menuService = this.getService(event, IMenuService.class);
        PopupMenu popup = new PopupMenu();
        popup.configure(menuService, event);
        popup.show();
        return null;
    }

    private <T> T getService(ExecutionEvent event, Class<T> clazz) throws ExecutionException {
        Object service;
        IWorkbenchSite locator = HandlerUtil.getActiveSite((ExecutionEvent)event);
        if (locator != null && (service = locator.getService(clazz)) != null) {
            return (T)service;
        }
        locator = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        if (locator != null && (service = locator.getService(clazz)) != null) {
            return (T)service;
        }
        throw new ExecutionException("Unable to locate service " + clazz);
    }

    private static class PopupMenu {
        private IMenuService menuService;
        private String menuId;
        private Control parent;
        private Point location;

        private PopupMenu() {
        }

        private void configure(IMenuService menuService, ExecutionEvent event) throws ExecutionException {
            this.menuService = menuService;
            if (!(event.getTrigger() instanceof Event) || ((Event)event.getTrigger()).type != 13 || !(((Event)event.getTrigger()).widget instanceof ToolItem)) {
                throw new ExecutionException("Unable to determine menu id");
            }
            ToolItem toolItem = (ToolItem)((Event)event.getTrigger()).widget;
            if (!(toolItem.getData() instanceof ContributionItem)) {
                throw new ExecutionException("Unable to determine menu id");
            }
            this.menuId = ((ContributionItem)toolItem.getData()).getId();
            this.parent = toolItem.getParent();
            Rectangle itemBounds = toolItem.getBounds();
            this.location = this.parent.toDisplay(new Point(itemBounds.x, itemBounds.y + itemBounds.height));
        }

        private void show() {
            final MenuManager menuManager = new MenuManager();
            Menu menu = menuManager.createContextMenu(this.parent);
            menuManager.addMenuListener((IMenuListener)new IMenuListener2(){

                public void menuAboutToHide(IMenuManager manager) {
                    PopupMenu.this.parent.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            PopupMenu.this.menuService.releaseContributions((ContributionManager)menuManager);
                            menuManager.dispose();
                        }
                    });
                }

                public void menuAboutToShow(IMenuManager manager) {
                    PopupMenu.this.menuService.populateContributionManager((ContributionManager)menuManager, "menu:" + PopupMenu.this.menuId);
                }
            });
            menu.setLocation(this.location);
            menu.setVisible(true);
        }
    }
}

