/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.internal.p2.artifact.processors.pgp.PGPPublicKeyStore;
import org.eclipse.equinox.internal.p2.engine.phases.AuthorityChecker;
import org.eclipse.equinox.internal.p2.engine.phases.CertificateChecker;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.internal.p2.ui.dialogs.PGPPublicKeyViewDialog;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKMessages;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKUIActivator;
import org.eclipse.equinox.internal.p2.ui.viewers.CertificateLabelProvider;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.repository.spi.PGPPublicKeyService;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.widgets.ButtonFactory;
import org.eclipse.jface.widgets.CompositeFactory;
import org.eclipse.jface.widgets.GroupFactory;
import org.eclipse.jface.widgets.LabelFactory;
import org.eclipse.jface.widgets.TableFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.framework.Bundle;

public class TrustPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String DEFAULT_AUTHORITY_PREFIX = "https://";
    private static final String EXPORT_FILTER_PATH = "exportFilterPath";
    private static final String ADD_FILTER_PATH = "addFilterPath";
    private static final List<Certificate> TBD = List.of();
    private boolean dirtyCertificates;
    private boolean artifactsTrustAlways;
    private CertificateChecker certificateChecker;
    private Set<Certificate> trustedCertificates;
    private PGPPublicKeyStore trustedKeys;
    private Map<PGPPublicKey, Set<Bundle>> contributedTrustedKeys;
    private TableViewer certificateViewer;
    private boolean dirtyAuthorities;
    private boolean authoritiesTrustAlways;
    private TableViewer authorityViewer;
    private AuthorityChecker authorityChecker;
    private Set<URI> trustedAuthorities;
    private ConcurrentHashMap<URI, List<Certificate>> authorityCertificates = new ConcurrentHashMap();
    private Job authorityCertificatesJob;
    private Transport transport;
    private Map<String, Transport.ProtocolRule> protocolRules;
    private final List<Runnable> restoreProtocolRules = new ArrayList<Runnable>();

    public TrustPreferencePage() {
        super(ProvSDKMessages.TrustPreferencePage_title);
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(final Composite parent) {
        IProvisioningAgent provisioningAgent = ProvSDKUIActivator.getDefault().getProvisioningAgent();
        IProfile profile = ((IProfileRegistry)provisioningAgent.getService(IProfileRegistry.class)).getProfile("_SELF_");
        this.authorityChecker = new AuthorityChecker(provisioningAgent, profile);
        this.trustedAuthorities = new TreeSet<URI>(this.authorityChecker.getPreferenceTrustedAuthorities());
        this.authoritiesTrustAlways = this.authorityChecker.isTrustAlways();
        final Display display = parent.getDisplay();
        this.authorityCertificatesJob = new Job(ProvSDKMessages.TrustPreferencePage_CertificatesJobName){

            protected IStatus run(IProgressMonitor monitor) {
                LinkedHashSet uris = new LinkedHashSet();
                TrustPreferencePage.this.authorityCertificates.forEach((key, value) -> {
                    if (value == TBD) {
                        uris.add(key);
                    }
                });
                Map certificates = AuthorityChecker.getCertificates(uris, (IProgressMonitor)monitor);
                TrustPreferencePage.this.authorityCertificates.putAll(certificates);
                if (!parent.isDisposed()) {
                    display.asyncExec(() -> {
                        if (!parent.isDisposed()) {
                            TrustPreferencePage.this.authorityViewer.refresh(true);
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        this.authorityCertificatesJob.setSystem(true);
        if (!this.trustedAuthorities.isEmpty()) {
            for (URI authority : this.trustedAuthorities) {
                this.putCertificates(authority, TBD);
            }
        }
        this.authorityCertificatesJob.schedule();
        PGPPublicKeyService keyService = (PGPPublicKeyService)provisioningAgent.getService(PGPPublicKeyService.class);
        this.certificateChecker = new CertificateChecker(provisioningAgent);
        this.certificateChecker.setProfile(profile);
        this.trustedCertificates = new LinkedHashSet<Certificate>(this.certificateChecker.getPreferenceTrustedCertificates());
        this.contributedTrustedKeys = this.certificateChecker.getContributedTrustedKeys();
        this.trustedKeys = this.certificateChecker.getPreferenceTrustedKeys();
        this.artifactsTrustAlways = this.certificateChecker.isTrustAlways();
        TabFolder tabFolder = new TabFolder(parent, 0);
        TabItem artifactsTab = new TabItem(tabFolder, 0);
        artifactsTab.setText(ProvSDKMessages.TrustPreferencePage_ArtifactsTabName);
        Composite artifactsComposite = new Composite((Composite)tabFolder, 0);
        artifactsComposite.setBackground(parent.getBackground());
        artifactsComposite.setLayout((Layout)new GridLayout(2, false));
        artifactsTab.setControl((Control)artifactsComposite);
        this.createArtifactsTab(artifactsComposite, keyService, parent.getFont());
        this.transport = (Transport)provisioningAgent.getService(Transport.class);
        this.protocolRules = new LinkedHashMap<String, Transport.ProtocolRule>(this.transport.getProtocolRules());
        TabItem authoritiesTab = new TabItem(tabFolder, 0);
        authoritiesTab.setText(ProvSDKMessages.TrustPreferencePage_AuthoritiesTabName);
        Composite authoritiesComposite = new Composite((Composite)tabFolder, 0);
        authoritiesComposite.setBackground(parent.getBackground());
        authoritiesComposite.setLayout((Layout)new GridLayout(2, false));
        this.createAuthoritiesTab(authoritiesComposite, parent.getFont());
        authoritiesTab.setControl((Control)authoritiesComposite);
        return tabFolder;
    }

    private void createArtifactsTab(Composite res, PGPPublicKeyService keyService, Font font) {
        GridData data = new GridData(4, -1, true, false, 2, 1);
        data.widthHint = this.convertWidthInCharsToPixels(90);
        LabelFactory factory = (LabelFactory)((LabelFactory)WidgetFactory.label((int)64).text(ProvSDKMessages.TrustPreferencePage_pgpIntro).font(font)).layoutData((Object)data);
        factory.create((Widget)res);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        Composite tableComposite = (Composite)((CompositeFactory)((CompositeFactory)WidgetFactory.composite((int)0).layoutData((Object)new GridData(4, 4, true, true))).layout((Layout)tableColumnLayout)).create((Widget)res);
        Table table = (Table)((TableFactory)WidgetFactory.table((int)68354).headerVisible(true).linesVisible(true).font(font)).create((Widget)tableComposite);
        this.certificateViewer = new TableViewer(table);
        table.setHeaderVisible(true);
        this.certificateViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        TableViewerColumn typeColumn = this.createColumn(this.certificateViewer, ProvSDKMessages.TrustPreferencePage_TypeColumn, key -> "PGP", cert -> "x509", tableColumnLayout, 1);
        this.createColumn(this.certificateViewer, ProvSDKMessages.TrustPreferencePage_FingerprintIdColumn, key -> PGPPublicKeyService.toHexFingerprint((PGPPublicKey)key), cert -> cert.getSerialNumber().toString(), tableColumnLayout, 10);
        this.createColumn(this.certificateViewer, ProvSDKMessages.TrustPreferencePage_NameColumn, key -> {
            ArrayList userIds = new ArrayList();
            key.getUserIDs().forEachRemaining(userIds::add);
            return String.join((CharSequence)", ", userIds);
        }, cert -> CertificateLabelProvider.getText((X509Certificate)cert), tableColumnLayout, 15);
        this.createColumn(this.certificateViewer, ProvSDKMessages.TrustPreferencePage_Contributor, key -> {
            Set<Bundle> bundles;
            LinkedHashSet<String> contributors = new LinkedHashSet<String>();
            if (this.trustedKeys.all().contains(key)) {
                contributors.add(ProvSDKMessages.TrustPreferencePage_PreferenceContributor);
            }
            if ((bundles = this.contributedTrustedKeys.get(key)) != null) {
                TreeSet bundleContributors = new TreeSet(Policy.getComparator());
                bundles.stream().map(bundle -> this.getBundleName((Bundle)bundle)).forEach(bundleContributors::add);
                contributors.addAll(bundleContributors);
            }
            return String.join((CharSequence)", ", contributors);
        }, cert -> ProvSDKMessages.TrustPreferencePage_PreferenceContributor, tableColumnLayout, this.contributedTrustedKeys.isEmpty() ? 8 : 15);
        this.createColumn(this.certificateViewer, ProvSDKMessages.TrustPreferencePage_ValidityColumn, pgp -> {
            Date verifiedRevocationDate;
            if (keyService != null && (verifiedRevocationDate = keyService.getVerifiedRevocationDate(pgp)) != null) {
                return NLS.bind((String)ProvSDKMessages.TrustPreferencePage_RevokedPGPKey, (Object)verifiedRevocationDate);
            }
            if (pgp.getCreationTime().after(Date.from(Instant.now()))) {
                return NLS.bind((String)ProvSDKMessages.TrustPreferencePage_DateNotYetValid, (Object)pgp.getCreationTime());
            }
            long validSeconds = pgp.getValidSeconds();
            if (validSeconds == 0L) {
                return ProvSDKMessages.TrustPreferencePage_DateValid;
            }
            Instant expires = pgp.getCreationTime().toInstant().plus(validSeconds, ChronoUnit.SECONDS);
            return expires.isBefore(Instant.now()) ? NLS.bind((String)ProvSDKMessages.TrustPreferencePage_DateExpiredSince, (Object)expires) : NLS.bind((String)ProvSDKMessages.TrustPreferencePage_DataValidExpires, (Object)expires);
        }, x509 -> {
            try {
                x509.checkValidity();
                return ProvSDKMessages.TrustPreferencePage_DateValid;
            }
            catch (CertificateExpiredException certificateExpiredException) {
                return ProvSDKMessages.TrustPreferencePage_DateExpired;
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                return ProvSDKMessages.TrustPreferencePage_DateNotYetvalid;
            }
        }, tableColumnLayout, 8);
        this.updateCertificateInput();
        Composite buttonComposite = this.createVerticalButtonBar(res);
        buttonComposite.setLayoutData((Object)new GridData(-1, 1, false, false));
        Button exportButton = new Button(buttonComposite, 8);
        exportButton.setText(ProvSDKMessages.TrustPreferencePage_export);
        this.setVerticalButtonLayoutData(exportButton);
        exportButton.setEnabled(false);
        exportButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            Object element = this.certificateViewer.getStructuredSelection().getFirstElement();
            FileDialog dialog = new FileDialog(this.getShell(), 8192);
            dialog.setFilterPath(this.getFilterPath(EXPORT_FILTER_PATH));
            dialog.setText(ProvSDKMessages.TrustPreferencePage_fileExportTitle);
            dialog.setFilterExtensions(new String[]{"*.asc"});
            FileDialog destination = new FileDialog(exportButton.getShell(), 8192);
            destination.setFilterPath(this.getFilterPath(EXPORT_FILTER_PATH));
            destination.setText(ProvSDKMessages.TrustPreferencePage_Export);
            Object object = element;
            if (object instanceof X509Certificate) {
                void certificate;
                X509Certificate x509Certificate = (X509Certificate)object;
                X509Certificate cfr_ignored_0 = (X509Certificate)object;
                destination.setFilterExtensions(new String[]{"*.der"});
                destination.setFileName(certificate.getSerialNumber().toString() + ".der");
                String path = destination.open();
                this.setFilterPath(EXPORT_FILTER_PATH, destination.getFilterPath());
                if (path == null) {
                    return;
                }
                File destinationFile = new File(path);
                try {
                    Throwable throwable = null;
                    Object var12_16 = null;
                    try (FileOutputStream output = new FileOutputStream(destinationFile);){
                        output.write(certificate.getEncoded());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException | CertificateEncodingException ex) {
                    ProvSDKUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.equinox.p2.ui.sdk", ex.getMessage(), (Throwable)ex));
                }
            } else {
                PGPPublicKey key = (PGPPublicKey)element;
                destination.setFilterExtensions(new String[]{"*.asc"});
                destination.setFileName(PGPPublicKeyService.toHexFingerprint((PGPPublicKey)key) + ".asc");
                String path = destination.open();
                this.setFilterPath(EXPORT_FILTER_PATH, destination.getFilterPath());
                if (path == null) {
                    return;
                }
                File destinationFile = new File(path);
                try {
                    Throwable throwable = null;
                    Object var13_22 = null;
                    try (ArmoredOutputStream output = new ArmoredOutputStream((OutputStream)new FileOutputStream(destinationFile));){
                        key.encode((OutputStream)output);
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (IOException ex) {
                    ProvSDKUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.equinox.p2.ui.sdk", ex.getMessage(), (Throwable)ex));
                }
            }
        }));
        Button addButton = new Button(buttonComposite, 8);
        addButton.setText(ProvSDKMessages.TrustPreferencePage_addPGPKeyButtonLabel);
        addButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            FileDialog dialog = new FileDialog(this.getShell(), 4096);
            dialog.setFilterPath(this.getFilterPath(ADD_FILTER_PATH));
            dialog.setText(ProvSDKMessages.TrustPreferencePage_fileImportTitle);
            dialog.setFilterExtensions(new String[]{"*.asc;*.der"});
            String path = dialog.open();
            this.setFilterPath(ADD_FILTER_PATH, dialog.getFilterPath());
            if (path == null) {
                return;
            }
            if (path.endsWith(".der")) {
                try {
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    Throwable throwable = null;
                    Object var6_10 = null;
                    try (InputStream input = Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);){
                        Collection<? extends Certificate> certificates = certificateFactory.generateCertificates(input);
                        this.trustedCertificates.addAll(certificates);
                        this.updateCertificateInput();
                        this.certificateViewer.setSelection((ISelection)new StructuredSelection(certificates.toArray()), true);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException | CertificateException ex) {
                    ProvSDKUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.equinox.p2.ui.sdk", ex.getMessage(), (Throwable)ex));
                }
            } else {
                HashSet oldKeys = new HashSet(this.trustedKeys.all());
                this.trustedKeys.add(new File(path));
                HashSet newKeys = new HashSet(this.trustedKeys.all());
                newKeys.removeAll(oldKeys);
                this.updateCertificateInput();
                this.certificateViewer.setSelection((ISelection)new StructuredSelection(newKeys.toArray()), true);
            }
            this.dirtyCertificates = true;
        }));
        this.setVerticalButtonLayoutData(addButton);
        Button removeButton = new Button(buttonComposite, 8);
        removeButton.setText(ProvSDKMessages.TrustPreferencePage_removePGPKeyButtonLabel);
        removeButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            for (Object key : this.getSelectedKeys()) {
                Object object = key;
                if (object instanceof PGPPublicKey) {
                    void pgp;
                    PGPPublicKey cfr_ignored_0 = (PGPPublicKey)object;
                    PGPPublicKey cfr_ignored_1 = (PGPPublicKey)object;
                    this.trustedKeys.remove((PGPPublicKey)pgp);
                    continue;
                }
                this.trustedCertificates.remove(key);
            }
            this.updateCertificateInput();
            this.dirtyCertificates = true;
        }));
        removeButton.setEnabled(false);
        this.setVerticalButtonLayoutData(removeButton);
        Runnable details = () -> {
            Object element = this.certificateViewer.getStructuredSelection().getFirstElement();
            Object object = element;
            if (object instanceof X509Certificate) {
                void certificate;
                X509Certificate x509Certificate = (X509Certificate)object;
                X509Certificate cfr_ignored_0 = (X509Certificate)object;
                CertificateLabelProvider.openDialog((Shell)this.getShell(), (X509Certificate)certificate);
            } else {
                new PGPPublicKeyViewDialog(this.getShell(), (PGPPublicKey)element, keyService).open();
            }
        };
        Button detailsButton = new Button(buttonComposite, 8);
        detailsButton.setText(ProvSDKMessages.TrustPreferencePage_Details);
        detailsButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> details.run()));
        detailsButton.setEnabled(false);
        this.setVerticalButtonLayoutData(detailsButton);
        this.certificateViewer.addPostSelectionChangedListener(e -> {
            List<Object> selectedKeys = this.getSelectedKeys();
            exportButton.setEnabled(selectedKeys.size() == 1);
            Collection keys = this.trustedKeys.all();
            removeButton.setEnabled(selectedKeys.stream().anyMatch(o -> keys.contains(o) || this.trustedCertificates.contains(o)));
            detailsButton.setEnabled(selectedKeys.size() == 1);
        });
        Button trustAllButton = (Button)((ButtonFactory)WidgetFactory.button((int)32).text(ProvSDKMessages.TrustPreferencePage_TrustAll).font(JFaceResources.getDialogFont())).create((Widget)res);
        this.setButtonLayoutData((Button)trustAllButton).verticalSpan = 2;
        trustAllButton.setSelection(this.artifactsTrustAlways);
        trustAllButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (trustAllButton.getSelection()) {
                MessageDialog messageDialog = new MessageDialog(this.getShell(), ProvSDKMessages.TrustPreferencePage_TrustAllConfirmationTitle, null, ProvSDKMessages.TrustPreferencePage_TrustAllConfirmationDescription, 3, new String[]{ProvSDKMessages.TrustPreferencePage_TrustAllYes, ProvSDKMessages.TrustPreferencePage_TrustAllNo}, 1){

                    public Image getImage() {
                        return this.getWarningImage();
                    }
                };
                int result = messageDialog.open();
                if (result != 0) {
                    trustAllButton.setSelection(false);
                } else {
                    this.artifactsTrustAlways = true;
                    this.dirtyCertificates = true;
                }
            } else {
                this.artifactsTrustAlways = false;
                this.dirtyCertificates = true;
            }
        }));
        this.certificateViewer.addDoubleClickListener(e -> details.run());
        typeColumn.getColumn().pack();
        Menu menu = new Menu((Control)table);
        table.setMenu(menu);
        MenuItem item = new MenuItem(menu, 8);
        item.setText(ProvSDKMessages.TrustPreferencePage_CopyFingerprint);
        item.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            Object element = this.certificateViewer.getStructuredSelection().getFirstElement();
            Object object = element;
            if (object instanceof PGPPublicKey) {
                void pgp;
                PGPPublicKey pGPPublicKey = (PGPPublicKey)object;
                PGPPublicKey cfr_ignored_0 = (PGPPublicKey)object;
                Clipboard clipboard = new Clipboard(this.getShell().getDisplay());
                clipboard.setContents(new Object[]{PGPPublicKeyService.toHexFingerprint((PGPPublicKey)pgp)}, new Transfer[]{TextTransfer.getInstance()});
                clipboard.dispose();
            }
        }));
        this.certificateViewer.addSelectionChangedListener(e -> item.setEnabled(this.certificateViewer.getStructuredSelection().getFirstElement() instanceof PGPPublicKey));
    }

    private void createAuthoritiesTab(Composite res, Font font) {
        GridData data = new GridData(4, -1, true, false, 2, 1);
        data.widthHint = this.convertWidthInCharsToPixels(90);
        LabelFactory factory = (LabelFactory)((LabelFactory)WidgetFactory.label((int)64).text(ProvSDKMessages.TrustPreferencePage_AuthoritiesTabDescription).font(font)).layoutData((Object)data);
        factory.create((Widget)res);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        Composite tableComposite = (Composite)((CompositeFactory)((CompositeFactory)WidgetFactory.composite((int)0).layoutData((Object)new GridData(4, 4, true, true))).layout((Layout)tableColumnLayout)).create((Widget)res);
        Table table = (Table)((TableFactory)WidgetFactory.table((int)68354).headerVisible(true).linesVisible(true).font(font)).create((Widget)tableComposite);
        this.authorityViewer = new TableViewer(table);
        table.setHeaderVisible(true);
        this.authorityViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.createColumn(this.authorityViewer, ProvSDKMessages.TrustPreferencePage_AuthorityColumnTitle, new ColumnLabelProvider(), tableColumnLayout, 10);
        TableViewerColumn securedColumn = this.createColumn(this.authorityViewer, ProvSDKMessages.TrustPreferencePage_SecuredColumnTitle, new ColumnLabelProvider(){

            public String getText(Object element) {
                List<Certificate> certificates = TrustPreferencePage.this.getCertificates((URI)element);
                if (certificates == TBD) {
                    return ProvSDKMessages.TrustPreferencePage_ComputingAuthoritySecurity;
                }
                if (certificates.isEmpty()) {
                    return ProvSDKMessages.TrustPreferencePage_InsecureAuthority;
                }
                return ProvSDKMessages.TrustPreferencePage_SecureAuthority;
            }
        }, tableColumnLayout, 1);
        this.updateAuthorityInput();
        Composite buttonComposite = this.createVerticalButtonBar(res);
        buttonComposite.setLayoutData((Object)new GridData(-1, 1, false, false));
        Button addButton = new Button(buttonComposite, 8);
        addButton.setText(ProvSDKMessages.TrustPreferencePage_addPGPKeyButtonLabel);
        addButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            InputDialog inputDialog = new InputDialog(this.getShell(), ProvSDKMessages.TrustPreferencePage_AddAuthorityTitle, ProvSDKMessages.TrustPreferencePage_AddAuthorityDescription, DEFAULT_AUTHORITY_PREFIX, it -> {
                try {
                    new URI(it);
                }
                catch (URISyntaxException ex) {
                    if (DEFAULT_AUTHORITY_PREFIX.equals(it)) {
                        return ProvSDKMessages.TrustPreferencePage_EmptyHostNameMessage;
                    }
                    return ex.getLocalizedMessage();
                }
                return null;
            });
            int open = inputDialog.open();
            if (open == 0) {
                URI authorityURI = URI.create(inputDialog.getValue());
                List authorityChain = AuthorityChecker.getAuthorityChain((URI)authorityURI);
                URI mainAuthority = (URI)authorityChain.get(0);
                if (authorityChain.size() == 2 && (String.valueOf(mainAuthority) + "/").equals(((URI)authorityChain.get(1)).toString())) {
                    authorityURI = mainAuthority;
                }
                this.trustedAuthorities.add(authorityURI);
                List filteredAuthorities = AuthorityChecker.getFilteredAuthorities(this.trustedAuthorities);
                this.trustedAuthorities.clear();
                this.trustedAuthorities.addAll(filteredAuthorities);
                this.authorityCertificates.put(mainAuthority, TBD);
                this.authorityCertificatesJob.schedule();
                this.updateAuthorityInput();
                this.dirtyAuthorities = true;
            }
        }));
        this.setVerticalButtonLayoutData(addButton);
        Button removeButton = new Button(buttonComposite, 8);
        removeButton.setText(ProvSDKMessages.TrustPreferencePage_removePGPKeyButtonLabel);
        removeButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.trustedAuthorities.removeAll(this.getSelectedAuthorities());
            this.updateAuthorityInput();
            this.dirtyAuthorities = true;
        }));
        removeButton.setEnabled(false);
        this.setVerticalButtonLayoutData(removeButton);
        Runnable details = () -> {
            Object element = this.authorityViewer.getStructuredSelection().getFirstElement();
            List<Certificate> certificates = this.getCertificates((URI)element);
            if (!certificates.isEmpty()) {
                Certificate certificate = certificates.get(0);
                CertificateLabelProvider.openDialog((Shell)this.getShell(), (X509Certificate)((X509Certificate)certificate));
            }
        };
        Button detailsButton = new Button(buttonComposite, 8);
        detailsButton.setText(ProvSDKMessages.TrustPreferencePage_Details);
        detailsButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> details.run()));
        detailsButton.setEnabled(false);
        this.setVerticalButtonLayoutData(detailsButton);
        this.authorityViewer.addPostSelectionChangedListener(e -> {
            List<URI> selectedAuthorities = this.getSelectedAuthorities();
            removeButton.setEnabled(!selectedAuthorities.isEmpty());
            detailsButton.setEnabled(!selectedAuthorities.isEmpty() && !this.getCertificates(selectedAuthorities.get(0)).isEmpty());
        });
        Button trustAllButton = (Button)((ButtonFactory)WidgetFactory.button((int)32).text(ProvSDKMessages.TrustPreferencePage_TrustAll).font(JFaceResources.getDialogFont())).create((Widget)res);
        this.setButtonLayoutData((Button)trustAllButton).verticalSpan = 2;
        trustAllButton.setSelection(this.authoritiesTrustAlways);
        trustAllButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (trustAllButton.getSelection()) {
                MessageDialog messageDialog = new MessageDialog(this.getShell(), ProvSDKMessages.TrustPreferencePage_TrustAllAuthoritiesConfirmationTitle, null, ProvSDKMessages.TrustPreferencePage_TrustAllAuthoritiesMessage, 3, new String[]{ProvSDKMessages.TrustPreferencePage_ConfirmTrustAllAuthorities, ProvSDKMessages.TrustPreferencePage_RejectTrustAllAuthorities}, 1){

                    public Image getImage() {
                        return this.getWarningImage();
                    }
                };
                int result = messageDialog.open();
                if (result != 0) {
                    trustAllButton.setSelection(false);
                } else {
                    this.authoritiesTrustAlways = true;
                    this.dirtyAuthorities = true;
                }
            } else {
                this.authoritiesTrustAlways = false;
                this.dirtyAuthorities = true;
            }
        }));
        if (!this.protocolRules.isEmpty()) {
            Map defaultProtocolRules = this.transport.getDefaultProtocolRules();
            GridData groupLayoutData = new GridData(4, 4, false, false, 2, 1);
            groupLayoutData.verticalIndent = 5;
            Group protocolRulesGroup = (Group)((GroupFactory)((GroupFactory)WidgetFactory.group((int)0).text(ProvSDKMessages.TrustPreferencePage_ProtocolRulesGroupLabel).layout((Layout)new GridLayout(2, false))).layoutData((Object)groupLayoutData)).create((Widget)res);
            for (Map.Entry<String, Transport.ProtocolRule> entry : this.protocolRules.entrySet()) {
                String protocol = entry.getKey();
                WidgetFactory.label((int)0).text(protocol + ":").create((Widget)protocolRulesGroup);
                Combo combo = new Combo((Composite)protocolRulesGroup, 8);
                LinkedHashMap<String, Transport.ProtocolRule> items = new LinkedHashMap<String, Transport.ProtocolRule>();
                String defaultItem = NLS.bind((String)ProvSDKMessages.TrustPreferencePage_DefaultProtocolRuleQualifier, (Object)TrustPreferencePage.getProtocolRuleLabel((Transport.ProtocolRule)defaultProtocolRules.get(protocol)));
                items.put(defaultItem, null);
                Transport.ProtocolRule[] protocolRuleArray = Transport.ProtocolRule.values();
                int n = protocolRuleArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Transport.ProtocolRule value = protocolRuleArray[n2];
                    items.put(TrustPreferencePage.getProtocolRuleLabel(value), value);
                    ++n2;
                }
                combo.setItems((String[])items.keySet().toArray(String[]::new));
                Transport.ProtocolRule rule = entry.getValue();
                this.restoreProtocolRules.add(() -> combo.setText(rule == null ? defaultItem : TrustPreferencePage.getProtocolRuleLabel(rule)));
                combo.addModifyListener(e -> {
                    Transport.ProtocolRule newRule = (Transport.ProtocolRule)items.get(combo.getText());
                    this.protocolRules.put(protocol, newRule);
                });
            }
            this.restoreProtocolRules.forEach(Runnable::run);
        }
        this.authorityViewer.addDoubleClickListener(e -> details.run());
        securedColumn.getColumn().pack();
        Menu menu = new Menu((Control)table);
        table.setMenu(menu);
        MenuItem item = new MenuItem(menu, 8);
        item.setText(ProvSDKMessages.TrustPreferencePage_CopyLinkMenuItem);
        item.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            URI uri = this.getSelectedAuthorities().get(0);
            Clipboard clipboard = new Clipboard(this.getShell().getDisplay());
            clipboard.setContents(new Object[]{uri.toString()}, new Transfer[]{TextTransfer.getInstance()});
            clipboard.dispose();
        }));
        this.authorityViewer.addSelectionChangedListener(e -> item.setEnabled(!this.getSelectedAuthorities().isEmpty()));
    }

    private TableViewerColumn createColumn(TableViewer tableViewer, String text, Function<PGPPublicKey, String> pgpMap, Function<X509Certificate, String> x509Map, TableColumnLayout tableColumnLayout, int columnWeight) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setText(text);
        column.setLabelProvider((CellLabelProvider)new PGPOrX509ColumnLabelProvider(pgpMap, x509Map));
        tableColumnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(columnWeight));
        return column;
    }

    private TableViewerColumn createColumn(TableViewer tableViewer, String text, ColumnLabelProvider labelProvider, TableColumnLayout tableColumnLayout, int columnWeight) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setText(text);
        column.setLabelProvider((CellLabelProvider)labelProvider);
        tableColumnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(columnWeight));
        return column;
    }

    private void updateInput() {
        this.updateCertificateInput();
        this.updateAuthorityInput();
    }

    private void updateCertificateInput() {
        Collection all = this.trustedKeys.all();
        TreeSet<PGPPublicKey> input = new TreeSet<PGPPublicKey>((k1, k2) -> {
            boolean contains2;
            boolean contains1 = all.contains(k1);
            if (contains1 != (contains2 = all.contains(k2))) {
                if (contains1) {
                    return -1;
                }
                return 1;
            }
            return PGPPublicKeyService.toHexFingerprint((PGPPublicKey)k1).compareTo(PGPPublicKeyService.toHexFingerprint((PGPPublicKey)k2));
        });
        input.addAll(all);
        input.addAll(this.contributedTrustedKeys.keySet());
        LinkedHashSet<Certificate> allInput = new LinkedHashSet<Certificate>();
        allInput.addAll(this.trustedCertificates);
        allInput.addAll(input);
        this.certificateViewer.setInput(allInput);
    }

    private void updateAuthorityInput() {
        this.authorityViewer.setInput(this.trustedAuthorities);
    }

    private void putCertificates(URI uri, List<Certificate> certificates) {
        this.authorityCertificates.put((URI)AuthorityChecker.getAuthorityChain((URI)uri).get(0), certificates);
    }

    private List<Certificate> getCertificates(URI uri) {
        return this.authorityCertificates.get(AuthorityChecker.getAuthorityChain((URI)uri).get(0));
    }

    private List<Object> getSelectedKeys() {
        return this.certificateViewer.getStructuredSelection().toList();
    }

    private List<URI> getSelectedAuthorities() {
        return this.authorityViewer.getStructuredSelection().toList();
    }

    private Composite createVerticalButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.initializeDialogUnits((Control)composite);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 5;
        layout.marginHeight = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        return composite;
    }

    private GridData setVerticalButtonLayoutData(Button button) {
        GridData data = new GridData(256);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Point minSize = button.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minSize.x);
        button.setLayoutData((Object)data);
        return data;
    }

    private String getFilterPath(String key) {
        IDialogSettings dialogSettings = DialogSettings.getOrCreateSection((IDialogSettings)ProvSDKUIActivator.getDefault().getDialogSettings(), (String)((Object)((Object)this)).getClass().getName());
        String filterPath = dialogSettings.get(key);
        if (filterPath == null) {
            filterPath = System.getProperty("user.home");
        }
        return filterPath;
    }

    private void setFilterPath(String key, String filterPath) {
        if (filterPath != null) {
            IDialogSettings dialogSettings = DialogSettings.getOrCreateSection((IDialogSettings)ProvSDKUIActivator.getDefault().getDialogSettings(), (String)((Object)((Object)this)).getClass().getName());
            dialogSettings.put(key, filterPath);
        }
    }

    private String getBundleName(Bundle bundle) {
        String value = (String)bundle.getHeaders().get("Bundle-Name");
        return value == null ? bundle.getSymbolicName() : Platform.getResourceString((Bundle)bundle, (String)value);
    }

    protected void performDefaults() {
        this.trustedCertificates = new LinkedHashSet<Certificate>(this.certificateChecker.getPreferenceTrustedCertificates());
        this.trustedKeys = this.certificateChecker.getPreferenceTrustedKeys();
        this.trustedAuthorities = this.authorityChecker.getPreferenceTrustedAuthorities();
        this.protocolRules = new LinkedHashMap<String, Transport.ProtocolRule>(this.transport.getProtocolRules());
        this.restoreProtocolRules.forEach(Runnable::run);
        this.updateInput();
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.dirtyCertificates) {
            this.certificateChecker.setTrustAlways(this.artifactsTrustAlways);
            this.certificateChecker.persistTrustedCertificates(this.trustedCertificates);
            this.certificateChecker.persistTrustedKeys(this.trustedKeys);
            this.dirtyCertificates = false;
        }
        if (this.dirtyAuthorities) {
            this.authorityChecker.setTrustAlways(this.authoritiesTrustAlways);
            this.authorityChecker.persistTrustedAuthorities(this.trustedAuthorities);
            this.dirtyAuthorities = false;
        }
        this.transport.setProtocolRules(this.protocolRules);
        return true;
    }

    private static String getProtocolRuleLabel(Transport.ProtocolRule rule) {
        if (rule == null) {
            return ProvSDKMessages.TrustPreferencePage_AllowProtocolRule;
        }
        switch (rule) {
            case ALLOW: {
                return ProvSDKMessages.TrustPreferencePage_AllowProtocolRule;
            }
            case REDIRECT: {
                return ProvSDKMessages.TrustPreferencePage_RedirectProtocolRule;
            }
        }
        return ProvSDKMessages.TrustPreferencePage_BlockProtocolRule;
    }

    private static class PGPOrX509ColumnLabelProvider
    extends ColumnLabelProvider {
        private Function<PGPPublicKey, String> pgpMap;
        private Function<X509Certificate, String> x509map;

        public PGPOrX509ColumnLabelProvider(Function<PGPPublicKey, String> pgpMap, Function<X509Certificate, String> x509map) {
            this.pgpMap = pgpMap;
            this.x509map = x509map;
        }

        /*
         * WARNING - void declaration
         */
        public String getText(Object element) {
            Object object = element;
            if (object instanceof PGPPublicKey) {
                void pgp;
                PGPPublicKey pGPPublicKey = (PGPPublicKey)object;
                PGPPublicKey cfr_ignored_0 = (PGPPublicKey)object;
                return this.pgpMap.apply((PGPPublicKey)pgp);
            }
            Object object2 = element;
            if (object2 instanceof X509Certificate) {
                void certificate;
                X509Certificate x509Certificate = (X509Certificate)object2;
                X509Certificate cfr_ignored_1 = (X509Certificate)object2;
                return this.x509map.apply((X509Certificate)certificate);
            }
            return super.getText(element);
        }
    }
}

