/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.ui;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.oomph.ui.PersistentButton;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ButtonBar {
    private static final String TOGGLE_COMMAND_PREFIX = "toggleCommand:";
    private final Composite parent;
    private final Control previousChild;
    private Composite composite;

    public ButtonBar(Composite parent) {
        this.parent = parent;
        Control[] children = parent.getChildren();
        this.previousChild = children.length == 0 ? null : children[children.length - 1];
    }

    public final Composite getComposite() {
        return this.composite;
    }

    public final Button addCheckButton(String text, String toolTip, boolean defaultSelection, String persistenceKey) {
        Button button;
        if (this.composite == null) {
            this.composite = new Composite(this.parent, 0);
            this.composite.setLayout((Layout)UIUtil.createGridLayout(1));
            this.composite.setLayoutData((Object)this.createLayoutData());
            if (this.previousChild != null && !this.previousChild.isDisposed()) {
                this.composite.moveBelow(this.previousChild);
            }
        } else {
            GridLayout checkLayout = (GridLayout)this.composite.getLayout();
            ++checkLayout.numColumns;
        }
        if (persistenceKey != null) {
            boolean toggleCommand = false;
            if (persistenceKey.startsWith(TOGGLE_COMMAND_PREFIX)) {
                persistenceKey = persistenceKey.substring(TOGGLE_COMMAND_PREFIX.length());
                toggleCommand = UIUtil.WORKBENCH != null;
            }
            PersistentButton.Persistence persistence = null;
            if (toggleCommand) {
                persistence = new PersistentButton.ToggleCommandPersistence(persistenceKey);
            } else {
                IDialogSettings dialogSettings = this.getDialogSettings();
                if (dialogSettings != null) {
                    persistence = new PersistentButton.DialogSettingsPersistence(dialogSettings, persistenceKey);
                }
            }
            button = PersistentButton.create(this.composite, 32, defaultSelection, persistence);
        } else {
            button = new Button(this.composite, 32);
            button.setSelection(defaultSelection);
        }
        button.setLayoutData((Object)this.createLayoutData());
        button.setText(text);
        if (!StringUtil.isEmpty((String)toolTip)) {
            button.setToolTipText(toolTip);
        }
        return button;
    }

    protected GridData createLayoutData() {
        return new GridData();
    }

    protected IDialogSettings getDialogSettings() {
        return null;
    }
}

