/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.jreinfo;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.oomph.extractor.lib.JREData;
import org.eclipse.oomph.internal.jreinfo.JREInfoPlugin;
import org.eclipse.oomph.jreinfo.InfoManager;
import org.eclipse.oomph.jreinfo.JRE;
import org.eclipse.oomph.jreinfo.JREFilter;
import org.eclipse.oomph.jreinfo.JREInfo;
import org.eclipse.oomph.jreinfo.OSType;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JREManager {
    public static final OSType OS_TYPE = JREManager.determineOSType();
    public static final int BITNESS = JREManager.determineBitness();
    public static final boolean BITNESS_CHANGEABLE = BITNESS == 64 && OS.INSTANCE.is32BitAvailable();
    public static final String JAVA_EXECUTABLE = OS_TYPE == OSType.Win ? "java.exe" : "java";
    public static final String JAVA_COMPILER = OS_TYPE == OSType.Win ? "javac.exe" : "javac";
    public static final JREManager INSTANCE = new JREManager();
    private final List<String> javaHomes = new ArrayList<String>();
    private String systemJavaHome;

    private JREManager() {
        try {
            this.loadJavaHomes();
        }
        catch (Throwable ex) {
            JREInfoPlugin.INSTANCE.log(ex);
        }
    }

    private void addExtraJavaHomes(List<String> extraJavaHomes, File folder, boolean root, Set<JRE> result, IProgressMonitor monitor) {
        JREInfoPlugin.checkCancelation((IProgressMonitor)monitor);
        String path = folder.getAbsolutePath();
        File[] childFolders = folder.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        try {
            try {
                File canonicalFolder;
                JRE info;
                File executable;
                int children = childFolders == null ? 0 : childFolders.length;
                monitor.beginTask(root ? "Searching for VMs in " + path + "..." : "", 1 + children);
                monitor.subTask(path);
                if (!this.javaHomes.contains(path) && !extraJavaHomes.contains(path) && (executable = new File(folder, "bin/" + JAVA_EXECUTABLE)).isFile() && (info = InfoManager.INSTANCE.getInfo(canonicalFolder = folder.getCanonicalFile())) != null && info.isValid()) {
                    extraJavaHomes.add(path);
                    result.add(new JRE(folder, info));
                }
                monitor.worked(1);
                int i = 0;
                while (i < children) {
                    this.addExtraJavaHomes(extraJavaHomes, childFolders[i], false, result, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    ++i;
                }
            }
            catch (OperationCanceledException ex) {
                throw ex;
            }
            catch (Exception exception) {
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    public synchronized Set<JRE> addExtraJavaHomes(String rootFolder, IProgressMonitor monitor) {
        HashSet<JRE> result = new HashSet<JRE>();
        File folder = new File(rootFolder);
        if (folder.isDirectory()) {
            List<String> extraJavaHomes = JREManager.loadExtraJavaHomes();
            this.addExtraJavaHomes(extraJavaHomes, folder, true, result, monitor);
            if (!result.isEmpty()) {
                JREManager.saveExtraJavaHomes(extraJavaHomes);
            }
        }
        return result;
    }

    public synchronized void removeExtraJavaHomes(String ... javaHomes) {
        List<String> extraJavaHomes = JREManager.loadExtraJavaHomes();
        if (extraJavaHomes.removeAll(Arrays.asList(javaHomes))) {
            JREManager.saveExtraJavaHomes(extraJavaHomes);
        }
    }

    public synchronized void refresh(boolean refreshInfos) {
        if (refreshInfos) {
            InfoManager.INSTANCE.refresh();
        }
        this.loadJavaHomes();
    }

    public String getDefaultJRE(int bitness, String javaVersion) {
        File defaultsFile = JREManager.getDefaultsFile();
        Map properties = PropertiesUtil.getProperties((File)defaultsFile);
        String javaHome = (String)properties.get(JREManager.getDefaultsKey(bitness, javaVersion));
        if (javaHome == null) {
            javaHome = (String)properties.get(JREManager.getDefaultsKey(bitness, null));
        }
        return javaHome;
    }

    public synchronized void setDefaultJRE(int bitness, String javaVersion, String javaHome) {
        File defaultsFile = JREManager.getDefaultsFile();
        Map properties = PropertiesUtil.getProperties((File)defaultsFile);
        properties.put(JREManager.getDefaultsKey(bitness, javaVersion), javaHome);
        properties.put(JREManager.getDefaultsKey(bitness, null), javaHome);
        PropertiesUtil.saveProperties((File)defaultsFile, (Map)properties, (boolean)true);
    }

    public Map<File, JRE> getJREs() {
        return this.getJREs(null);
    }

    public synchronized JRE getSystemJRE() {
        if (OS.INSTANCE.isWin()) {
            if (this.systemJavaHome == null) {
                ArrayList<String> folders = new ArrayList<String>();
                String path = System.getenv("PATH");
                String[] stringArray = path.split(File.pathSeparator);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String folder = stringArray[n2];
                    this.systemJavaHome = "";
                    if (!StringUtil.isEmpty((String)folder)) {
                        if (folder.indexOf(47) == -1) {
                            folders.add(folder);
                        } else {
                            boolean isDebug;
                            boolean bl = isDebug = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("jdwp") >= 0;
                            if (isDebug) {
                                folders.clear();
                            }
                        }
                    }
                    ++n2;
                }
                int size = folders.size();
                if (size > 0) {
                    folders.remove(size - 1);
                }
                for (String folder : folders) {
                    JREData jreData = InfoManager.testJRE(new File(folder, JAVA_EXECUTABLE).toString());
                    if (jreData == null) continue;
                    this.systemJavaHome = jreData.getJavaHome();
                    break;
                }
            }
            if (!StringUtil.isEmpty((String)this.systemJavaHome)) {
                return this.getJREs().get(new File(this.systemJavaHome));
            }
        }
        return null;
    }

    public Map<File, JRE> getJREs(JREFilter filter) {
        Set<File> folders = this.getJavaHomes();
        List<JRE> jres = JREManager.getJREs(filter, folders);
        LinkedHashMap<File, JRE> result = new LinkedHashMap<File, JRE>();
        for (JRE jre : jres) {
            result.put(jre.getJavaHome(), jre);
        }
        return result;
    }

    public JRE[] getJREs(JREFilter filter, boolean extra) {
        Set<File> folders = JREManager.toFile(extra ? JREManager.loadExtraJavaHomes() : this.javaHomes);
        List<JRE> jres = JREManager.getJREs(filter, folders);
        return jres.toArray(new JRE[jres.size()]);
    }

    private synchronized Set<File> getJavaHomes() {
        HashSet<File> all = new HashSet<File>();
        all.addAll(JREManager.toFile(this.javaHomes));
        all.addAll(JREManager.toFile(JREManager.loadExtraJavaHomes()));
        return all;
    }

    private void loadJavaHomes() {
        this.javaHomes.clear();
        JREInfo info = JREInfo.getAll();
        while (info != null) {
            this.javaHomes.add(info.javaHome);
            info = info.next;
        }
    }

    private static List<String> loadExtraJavaHomes() {
        if (JREManager.getCacheFile().isFile()) {
            try {
                return IOUtil.readLines((File)JREManager.getCacheFile(), (String)"UTF-8");
            }
            catch (Exception ex) {
                JREInfoPlugin.INSTANCE.log(ex);
            }
        }
        return new ArrayList<String>();
    }

    private static void saveExtraJavaHomes(List<String> paths) {
        try {
            IOUtil.writeLines((File)JREManager.getCacheFile(), (String)"UTF-8", paths);
        }
        catch (Exception ex) {
            JREInfoPlugin.INSTANCE.log(ex);
        }
    }

    private static File getCacheFile() {
        return new File(JREInfoPlugin.INSTANCE.getUserLocation().append("extra.txt").toOSString());
    }

    private static File getDefaultsFile() {
        return new File(JREInfoPlugin.INSTANCE.getUserLocation().append("defaults.properties").toOSString());
    }

    private static String getDefaultsKey(int bitness, String javaVersion) {
        return String.valueOf(Integer.toString(bitness)) + "/" + JREManager.sanitizeKey(javaVersion);
    }

    private static String sanitizeKey(String javaVersion) {
        if (javaVersion == null) {
            return "*";
        }
        return javaVersion.replace(' ', '_').replace('/', '_').replace('\\', '_').replace('=', '_');
    }

    private static List<JRE> getJREs(JREFilter filter, Collection<File> javaHomes) {
        ArrayList<JRE> list = new ArrayList<JRE>();
        for (File javaHome : javaHomes) {
            try {
                File canonicalJavaHome = javaHome.getCanonicalFile();
                JRE info = InfoManager.INSTANCE.getInfo(canonicalJavaHome);
                if (info == null || !info.isValid() || filter != null && !info.isMatch(filter)) continue;
                list.add(new JRE(javaHome, info));
            }
            catch (IOException ex) {
                JREInfoPlugin.INSTANCE.log(ex, 2);
            }
        }
        Collections.sort(list);
        return list;
    }

    private static Set<File> toFile(Collection<String> paths) {
        HashSet<File> result = new HashSet<File>();
        for (String javaHome : paths) {
            result.add(new File(javaHome));
        }
        return result;
    }

    private static OSType determineOSType() {
        try {
            String os = Platform.getOS();
            if ("win32".equals(os)) {
                System.loadLibrary("jreinfo.dll");
                return OSType.Win;
            }
            if ("macosx".equals(os)) {
                return OSType.Mac;
            }
            if ("linux".equals(os)) {
                return OSType.Linux;
            }
        }
        catch (Throwable ex) {
            JREInfoPlugin.INSTANCE.log(ex);
        }
        return OSType.Unsupported;
    }

    private static int determineBitness() {
        try {
            return JREData.determineBitness();
        }
        catch (Throwable ex) {
            JREInfoPlugin.INSTANCE.log(ex);
            return 32;
        }
    }
}

