/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.mappings;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.AbstractMethodMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.CallinMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.CalloutMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.FieldAccessSpec;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.MethodSpec;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;

public class MethodMappingResolver {
    private RoleModel _role;
    private ClassScope _roleScope;
    private Map<String, List<CalloutMappingDeclaration>> _foundRoleMethods = new HashMap<String, List<CalloutMappingDeclaration>>();
    boolean resolveBaseMethods;

    public MethodMappingResolver(RoleModel role, boolean resolveBaseMethods) {
        this._role = role;
        this._roleScope = role.getAst().scope;
        this.resolveBaseMethods = resolveBaseMethods;
    }

    public boolean resolve(boolean doCallout) {
        AbstractMethodMappingDeclaration[] methodMappings = this._role.getAst().callinCallouts;
        if (methodMappings == null || methodMappings.length == 0) {
            return true;
        }
        this._roleScope.buildCallinCallouts();
        boolean result = true;
        int idx = 0;
        while (idx < methodMappings.length) {
            AbstractMethodMappingDeclaration methodMapping = methodMappings[idx];
            if (methodMapping.isCallout() == doCallout) {
                if (!this._role.hasBaseclassProblem()) {
                    if (this._role.getBinding().baseclass() == null) {
                        this._roleScope.problemReporter().methodMappingNotInBoundRole(methodMapping, this._role.getAst());
                        methodMapping.tagAsHavingErrors();
                        this.resolveBaseMethods = false;
                    } else if (methodMapping.isCallin() && this._role.getBinding().baseclass().isInterface()) {
                        this._roleScope.problemReporter().callinBindingToInterface(methodMapping, this._role.getBinding().baseclass());
                        methodMapping.tagAsHavingErrors();
                        this.resolveBaseMethods = false;
                    }
                }
                methodMapping.resolveAnnotations();
                if (methodMapping.isCallout()) {
                    if (this._role._playedByEnclosing) {
                        this._roleScope.problemReporter().calloutToEnclosing((CalloutMappingDeclaration)methodMapping, this._role);
                        result = false;
                    } else {
                        result &= this.resolveCalloutMapping((CalloutMappingDeclaration)methodMapping);
                    }
                } else {
                    result &= this.resolveCallinMapping((CallinMappingDeclaration)methodMapping);
                }
            }
            ++idx;
        }
        if (doCallout) {
            for (String roleMethodKey : this._foundRoleMethods.keySet()) {
                result &= this.checkForDuplicateMethodMappings(roleMethodKey);
            }
        }
        return result;
    }

    private boolean resolveCallinMapping(CallinMappingDeclaration callinMappingDeclaration) {
        callinMappingDeclaration.resolveMethodSpecs(this._role, this._role.getBaseTypeBinding(), this.resolveBaseMethods);
        callinMappingDeclaration.binding._roleMethodBinding = callinMappingDeclaration.getRoleMethod();
        return callinMappingDeclaration.getRoleMethod() != null;
    }

    private boolean resolveCalloutMapping(CalloutMappingDeclaration calloutMappingDeclaration) {
        MethodSpec baseMethodSpec;
        MethodBinding roleMethodBinding;
        if (calloutMappingDeclaration.scope == null) {
            assert (calloutMappingDeclaration.hasErrors());
            return false;
        }
        calloutMappingDeclaration.resolveMethodSpecs(this._role, this._role.getBaseTypeBinding(), this.resolveBaseMethods || calloutMappingDeclaration.hasSignature);
        calloutMappingDeclaration.binding._roleMethodBinding = roleMethodBinding = calloutMappingDeclaration.roleMethodSpec.resolvedMethod;
        if (this.resolveBaseMethods && (baseMethodSpec = calloutMappingDeclaration.baseMethodSpec) != null) {
            if (baseMethodSpec.resolvedMethod != null) {
                calloutMappingDeclaration.binding._baseMethods = new MethodBinding[]{baseMethodSpec.resolvedMethod};
            } else if (baseMethodSpec instanceof FieldAccessSpec && ((FieldAccessSpec)baseMethodSpec).resolvedField != null) {
                calloutMappingDeclaration.binding._baseField = ((FieldAccessSpec)baseMethodSpec).resolvedField;
            } else {
                calloutMappingDeclaration.binding._baseMethods = Binding.NO_METHODS;
                calloutMappingDeclaration.tagAsHavingErrors();
            }
        }
        if (roleMethodBinding != null && (roleMethodBinding.isValidBinding() || roleMethodBinding.problemId() == 1 && calloutMappingDeclaration.hasSignature)) {
            String methodKey = String.valueOf(CharOperation.concat(roleMethodBinding.selector, roleMethodBinding.signature()));
            List<CalloutMappingDeclaration> mappings = this._foundRoleMethods.get(methodKey);
            if (mappings == null) {
                mappings = new LinkedList<CalloutMappingDeclaration>();
                this._foundRoleMethods.put(methodKey, mappings);
            }
            mappings.add(calloutMappingDeclaration);
        }
        return !calloutMappingDeclaration.hasErrors();
    }

    private boolean checkForDuplicateMethodMappings(String roleMethodKey) {
        List<CalloutMappingDeclaration> methodSpecs = this._foundRoleMethods.get(roleMethodKey);
        if (methodSpecs.size() > 1) {
            for (CalloutMappingDeclaration mapping : methodSpecs) {
                if (!TypeBinding.equalsEquals(mapping.binding._declaringRoleClass, this._role.getBinding())) continue;
                mapping.scope.problemReporter().duplicateCalloutBinding(this._role.getAst(), mapping.roleMethodSpec);
            }
            return false;
        }
        return true;
    }
}

