/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext18;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.AnchorMapping;

public class ProblemMethodBinding
extends MethodBinding {
    private int problemReason;
    public MethodBinding closestMatch;
    public InferenceContext18 inferenceContext;

    public ProblemMethodBinding(char[] selector, TypeBinding[] args, int problemReason) {
        this.selector = selector;
        this.parameters = args == null || args.length == 0 ? Binding.NO_PARAMETERS : args;
        this.problemReason = problemReason;
        this.thrownExceptions = Binding.NO_EXCEPTIONS;
    }

    public ProblemMethodBinding(char[] selector, TypeBinding[] args, ReferenceBinding declaringClass, int problemReason) {
        this.selector = selector;
        this.parameters = args == null || args.length == 0 ? Binding.NO_PARAMETERS : args;
        this.declaringClass = declaringClass;
        this.problemReason = problemReason;
        this.thrownExceptions = Binding.NO_EXCEPTIONS;
    }

    public ProblemMethodBinding(MethodBinding closestMatch, char[] selector, TypeBinding[] args, int problemReason) {
        this(selector, args, problemReason);
        MethodBinding clone;
        TypeBinding[] newParameters;
        this.closestMatch = closestMatch;
        if (closestMatch != null && (newParameters = AnchorMapping.instantiateParameters(null, closestMatch.parameters, closestMatch)) != closestMatch.parameters && (clone = this.getMethodClone(closestMatch)) != null) {
            clone.parameters = newParameters;
            this.closestMatch = clone;
        }
        if (closestMatch != null && problemReason != 3) {
            this.declaringClass = closestMatch.declaringClass;
            this.returnType = closestMatch.returnType;
        }
    }

    private MethodBinding getMethodClone(MethodBinding closestMatch) {
        if (closestMatch instanceof ParameterizedGenericMethodBinding) {
            ParameterizedGenericMethodBinding pgmb = (ParameterizedGenericMethodBinding)closestMatch;
            ParameterizedGenericMethodBinding clone = new ParameterizedGenericMethodBinding(closestMatch, pgmb.typeArguments, pgmb.environment());
            clone.declaringClass = closestMatch.declaringClass;
            return clone;
        }
        if (closestMatch instanceof ParameterizedMethodBinding) {
            if (closestMatch.declaringClass instanceof ParameterizedTypeBinding) {
                return new ParameterizedMethodBinding((ParameterizedTypeBinding)closestMatch.declaringClass, closestMatch);
            }
            return null;
        }
        return new MethodBinding(closestMatch, closestMatch.declaringClass);
    }

    @Override
    public MethodBinding shallowOriginal() {
        return this.closestMatch == null ? this : this.closestMatch.shallowOriginal();
    }

    @Override
    public final int problemId() {
        return this.problemReason;
    }
}

