/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.text.l10n;

import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.l10n.L10nEntry;
import org.eclipse.mtj.internal.core.text.l10n.L10nModel;
import org.eclipse.mtj.internal.core.text.l10n.L10nObject;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class L10nLocale
extends L10nObject {
    private static final long serialVersionUID = 1L;

    public L10nLocale(L10nModel l10nModel) {
        super(l10nModel, "locale");
    }

    @Override
    public boolean canBeParent() {
        return true;
    }

    public String getLanguageCode() {
        return this.getXMLAttributeValue("language");
    }

    public String getCountryCode() {
        return this.getXMLAttributeValue("country");
    }

    public void setLanguageCode(String string) {
        this.setXMLAttribute("language", string);
    }

    public void setCountryCode(String string) {
        this.setXMLAttribute("country", string);
    }

    public String getLocaleName() {
        this.migrateFromPrevVersion();
        return NLS.bind((String)"{0}-{1}", (Object[])new String[]{this.getLanguageCode(), this.getCountryCode()});
    }

    @Override
    public String getName() {
        return this.getLocaleName();
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public void validate() {
        String string;
        String[] stringArray = Locale.getISOCountries();
        String[] stringArray2 = Locale.getISOLanguages();
        String string2 = this.getLanguageCode();
        String string3 = this.getCountryCode();
        boolean bl = false;
        boolean bl2 = false;
        String[] stringArray3 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            string = stringArray3[n2];
            if (string.equalsIgnoreCase(string3)) {
                bl = true;
                break;
            }
            ++n2;
        }
        stringArray3 = stringArray2;
        n = stringArray2.length;
        n2 = 0;
        while (n2 < n) {
            string = stringArray3[n2];
            if (string.equalsIgnoreCase(string2)) {
                bl2 = true;
                break;
            }
            ++n2;
        }
        string = "";
        if (!bl || !bl2) {
            if (!bl2) {
                string = "Invalid language code. It must conform to ISO-639. ";
            }
            if (!bl) {
                string = String.valueOf(string) + "Invalid country code. It must conform to ISO-3166";
            }
            this.setStatus((IStatus)new Status(4, "org.eclipse.mtj.core", string));
        } else {
            this.setStatus((IStatus)new Status(0, "org.eclipse.mtj.core", "Valid Locale"));
        }
        this.syncronizeKeyStates();
    }

    private void syncronizeKeyStates() {
        IDocumentElementNode[] iDocumentElementNodeArray = this.getChildNodes();
        LinkedList<L10nEntry> linkedList = new LinkedList<L10nEntry>();
        IDocumentElementNode[] iDocumentElementNodeArray2 = iDocumentElementNodeArray;
        int n = iDocumentElementNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDocumentElementNode iDocumentElementNode = iDocumentElementNodeArray2[n2];
            L10nEntry l10nEntry = (L10nEntry)iDocumentElementNode;
            if (!linkedList.contains(l10nEntry)) {
                List<L10nEntry> list = this.findDuplicatedEntries(l10nEntry);
                if (list.size() > 0) {
                    for (L10nEntry l10nEntry2 : list) {
                        l10nEntry2.setStatus((IStatus)new Status(4, "org.eclipse.mtj.core", null));
                        linkedList.add(l10nEntry2);
                    }
                    l10nEntry.setStatus((IStatus)new Status(4, "org.eclipse.mtj.core", null));
                } else {
                    l10nEntry.setStatus((IStatus)new Status(0, "org.eclipse.mtj.core", null));
                }
            }
            ++n2;
        }
    }

    private List<L10nEntry> findDuplicatedEntries(L10nLocale l10nLocale, String string) {
        IDocumentElementNode[] iDocumentElementNodeArray;
        LinkedList<L10nEntry> linkedList = new LinkedList<L10nEntry>();
        IDocumentElementNode[] iDocumentElementNodeArray2 = iDocumentElementNodeArray = l10nLocale.getChildNodes();
        int n = iDocumentElementNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDocumentElementNode iDocumentElementNode = iDocumentElementNodeArray2[n2];
            L10nEntry l10nEntry = (L10nEntry)iDocumentElementNode;
            if (l10nEntry.getKey().toUpperCase().equals(string.toUpperCase())) {
                linkedList.add(l10nEntry);
            }
            ++n2;
        }
        return linkedList;
    }

    public List<L10nEntry> findDuplicatedEntries(L10nEntry l10nEntry) {
        List<L10nEntry> list = this.findDuplicatedEntries((L10nLocale)l10nEntry.getParent(), l10nEntry.getKey());
        list.remove(l10nEntry);
        return list;
    }

    private void migrateFromPrevVersion() {
        boolean bl;
        block7: {
            bl = false;
            String string = this.getXMLAttributeValue("name");
            if (string != null) {
                if (this.getLanguageCode() == null && this.getCountryCode() == null) {
                    try {
                        StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
                        if (stringTokenizer.countTokens() == 2) {
                            this.setLanguageCode(stringTokenizer.nextToken());
                            this.setCountryCode(stringTokenizer.nextToken());
                            break block7;
                        }
                        bl = true;
                    }
                    catch (Exception exception) {
                        bl = true;
                    }
                } else {
                    this.setXMLAttribute("name", null);
                }
            }
        }
        if (bl) {
            this.setStatus((IStatus)new Status(4, "org.eclipse.mtj.core", "Invalid locale"));
        }
    }
}

