/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sdk.device.midp;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.sdk.device.IAPI;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPAPI;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPLibrary;
import org.eclipse.mtj.core.sdk.device.midp.MIDPAPIType;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIDPLibrary
implements IMIDPLibrary {
    private static List<IAccessRule> NO_ACCESS_RULES = new ArrayList<IAccessRule>(0);
    private List<IMIDPAPI> apis;
    private URL javadocURL;
    private File libraryFile;
    private IPath sourceAttachmentPath;
    private IPath sourceAttachmentRootPath;
    private List<IAccessRule> accessRules;

    public MIDPLibrary() {
        this.accessRules = NO_ACCESS_RULES;
    }

    public MIDPLibrary(List<IMIDPAPI> list, URL uRL, File file, IPath iPath, IPath iPath2, List<IAccessRule> list2) {
        this.apis = list;
        this.javadocURL = uRL;
        this.libraryFile = file;
        this.sourceAttachmentPath = iPath;
        this.sourceAttachmentRootPath = iPath2;
        this.accessRules = list2;
    }

    public boolean equals(MIDPLibrary mIDPLibrary) {
        return this.libraryFile.equals(mIDPLibrary.libraryFile);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof MIDPLibrary) {
            bl = this.equals((MIDPLibrary)object);
        }
        return bl;
    }

    @Override
    public IMIDPAPI getAPI(MIDPAPIType mIDPAPIType) {
        IMIDPAPI iMIDPAPI = null;
        for (IAPI iAPI : this.apis) {
            IMIDPAPI iMIDPAPI2 = (IMIDPAPI)iAPI;
            if (iMIDPAPI2.getType() != mIDPAPIType) continue;
            iMIDPAPI = iMIDPAPI2;
            break;
        }
        return iMIDPAPI;
    }

    @Override
    public List<? extends IAPI> getAPIs() {
        return this.apis;
    }

    @Override
    public IMIDPAPI getConfiguration() {
        return this.getAPI(MIDPAPIType.CONFIGURATION);
    }

    public URL getJavadocURL() {
        return this.javadocURL;
    }

    public File getLibraryFile() {
        return this.libraryFile;
    }

    @Override
    public IMIDPAPI getProfile() {
        return this.getAPI(MIDPAPIType.PROFILE);
    }

    @Override
    public IPath getSourceAttachmentPath() {
        return this.sourceAttachmentPath;
    }

    @Override
    public IPath getSourceAttachmentRootPath() {
        return this.sourceAttachmentRootPath;
    }

    @Override
    public boolean hasConfiguration() {
        return this.getConfiguration() != null;
    }

    public int hashCode() {
        return this.libraryFile.hashCode();
    }

    @Override
    public boolean hasProfile() {
        return this.getProfile() != null;
    }

    @Override
    public void loadUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        String string;
        Object object;
        this.libraryFile = new File(iPersistenceProvider.loadString("file"));
        int n = iPersistenceProvider.loadInteger("apiCount");
        this.apis = new ArrayList<IMIDPAPI>();
        int n2 = 0;
        while (n2 < n) {
            object = (IMIDPAPI)iPersistenceProvider.loadPersistable("entry" + n2);
            this.apis.add((IMIDPAPI)object);
            ++n2;
        }
        String string2 = iPersistenceProvider.loadString("javadocURL");
        if (string2 != null) {
            try {
                this.javadocURL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                MTJLogger.log(2, "Error loading javadoc url " + string2, malformedURLException);
            }
        }
        if ((object = iPersistenceProvider.loadString("sourceAttachmentPath")) != null) {
            this.sourceAttachmentPath = new Path((String)object);
        }
        if ((string = iPersistenceProvider.loadString("sourceAttachmentRootPath")) != null) {
            this.sourceAttachmentRootPath = new Path(string);
        }
    }

    @Override
    public void setAccessRules(List<IAccessRule> list) {
        this.accessRules = list;
    }

    @Override
    public void setApis(List<? extends IAPI> list) {
        this.apis = list;
    }

    @Override
    public void setJavadocURL(URL uRL) {
        this.javadocURL = uRL;
    }

    @Override
    public void setLibraryFile(File file) {
        this.libraryFile = file;
    }

    @Override
    public void setSourceAttachmentPath(IPath iPath) {
        this.sourceAttachmentPath = iPath;
    }

    @Override
    public void setSourceAttachmentRootPath(IPath iPath) {
        this.sourceAttachmentRootPath = iPath;
    }

    @Override
    public void storeUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        iPersistenceProvider.storeString("file", this.libraryFile.toString());
        iPersistenceProvider.storeInteger("apiCount", this.apis.size());
        int n = 0;
        for (IAPI iAPI : this.apis) {
            iPersistenceProvider.storePersistable("entry" + n++, iAPI);
        }
        if (this.javadocURL != null) {
            iPersistenceProvider.storeString("javadocURL", this.javadocURL.toString());
        }
        if (this.sourceAttachmentPath != null) {
            iPersistenceProvider.storeString("sourceAttachmentPath", this.sourceAttachmentPath.toString());
        }
        if (this.sourceAttachmentRootPath != null) {
            iPersistenceProvider.storeString("sourceAttachmentRootPath", this.sourceAttachmentRootPath.toString());
        }
    }

    @Override
    public IClasspathEntry toClasspathEntry() {
        Path path = new Path(this.libraryFile.toString());
        IClasspathAttribute[] iClasspathAttributeArray = this.getClasspathAttributes();
        return JavaCore.newLibraryEntry((IPath)path, (IPath)this.sourceAttachmentPath, (IPath)this.sourceAttachmentRootPath, (IAccessRule[])(this.accessRules == null ? NO_ACCESS_RULES.toArray(new IAccessRule[0]) : this.accessRules.toArray(new IAccessRule[this.accessRules.size()])), (IClasspathAttribute[])iClasspathAttributeArray, (boolean)false);
    }

    @Override
    public File toFile() {
        return this.libraryFile;
    }

    public String toString() {
        return this.libraryFile.toString();
    }

    @Override
    public URL toURL() {
        URL uRL = null;
        try {
            uRL = this.libraryFile.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            MTJLogger.log(4, malformedURLException);
        }
        return uRL;
    }

    private IClasspathAttribute[] getClasspathAttributes() {
        ArrayList<IClasspathAttribute> arrayList = new ArrayList<IClasspathAttribute>();
        IClasspathAttribute iClasspathAttribute = this.getJavadocAttribute();
        if (iClasspathAttribute != null) {
            arrayList.add(iClasspathAttribute);
        }
        return arrayList.toArray(new IClasspathAttribute[arrayList.size()]);
    }

    private IClasspathAttribute getJavadocAttribute() {
        IClasspathAttribute iClasspathAttribute = null;
        if (this.javadocURL != null) {
            iClasspathAttribute = JavaCore.newClasspathAttribute((String)"javadoc_location", (String)this.javadocURL.toString());
        }
        return iClasspathAttribute;
    }

    @Override
    public List<IAccessRule> getAccessRules() {
        return this.accessRules;
    }
}

