/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.project.midp;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.sign.ISignatureProperties;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.project.midp.IMIDPMetaData;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.core.project.runtime.MTJRuntimeList;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.symbol.ISymbol;
import org.eclipse.mtj.core.symbol.ISymbolSet;
import org.eclipse.mtj.internal.core.MTJCoreErrors;
import org.eclipse.mtj.internal.core.build.sign.Base64EncDec;
import org.eclipse.mtj.internal.core.build.sign.SignatureProperties;
import org.eclipse.mtj.internal.core.project.midp.IMetaDataConstants;
import org.eclipse.mtj.internal.core.util.MTJStatusHandler;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.core.util.xml.XMLUtils;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaData
implements IMIDPMetaData,
IMetaDataConstants {
    private MTJRuntimeList configurations;
    private IDevice device;
    private String jadFileName;
    private IProject project;
    private Element rootXmlElement;
    private SignatureProperties signatureProps;
    private Version version;

    public MetaData(IMidletSuiteProject iMidletSuiteProject) {
        this(iMidletSuiteProject.getJavaProject().getProject());
    }

    public MetaData(IProject iProject) {
        this.project = iProject;
        try {
            this.loadMetaData();
        }
        catch (CoreException coreException) {
            MTJLogger.log(4, "loadMetaData() failed", coreException);
            this.initializeToDefaults();
        }
    }

    public IDevice getDevice() {
        return this.device;
    }

    @Override
    public String getJadFileName() {
        return this.jadFileName;
    }

    @Override
    public MTJRuntimeList getRuntimeList() {
        if (this.configurations == null) {
            this.configurations = new MTJRuntimeList();
        }
        return this.configurations;
    }

    @Override
    public ISignatureProperties getSignatureProperties() {
        return this.signatureProps;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public void saveMetaData() throws CoreException {
        IFile iFile = this.getStoreFile();
        if (iFile == null) {
            MTJLogger.log(2, "saveMetaData failed due to null store file");
        } else {
            if (iFile.exists() && iFile.isReadOnly()) {
                ResourceAttributes resourceAttributes = iFile.getResourceAttributes();
                resourceAttributes.setReadOnly(false);
                iFile.setResourceAttributes(resourceAttributes);
            }
            this.saveMetaDataToFile(iFile);
        }
    }

    @Override
    public void setJadFileName(String string) {
        this.jadFileName = string.replace(' ', '_');
    }

    @Override
    public void setMTJRuntimeList(MTJRuntimeList mTJRuntimeList) throws IllegalArgumentException {
        if (mTJRuntimeList == null) {
            throw new IllegalArgumentException("The runtime list must not be null.");
        }
        this.configurations = mTJRuntimeList;
    }

    @Override
    public void setSignatureProperties(ISignatureProperties iSignatureProperties) {
        if (this.signatureProps == null) {
            this.signatureProps = new SignatureProperties();
        }
        this.signatureProps.copy(iSignatureProperties);
    }

    private Cipher createCipher(int n) throws GeneralSecurityException {
        PBEKeySpec pBEKeySpec = new PBEKeySpec("MTJ".toCharArray());
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
        SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(CRYPTO_SALT, 10);
        Cipher cipher = Cipher.getInstance(secretKey.getAlgorithm());
        cipher.init(n, (Key)secretKey, pBEParameterSpec);
        return cipher;
    }

    private String decodePassword(Element element, String string) {
        Element element2 = XMLUtils.getFirstElementWithTagName(element, string);
        if (element2 == null) {
            return null;
        }
        String string2 = XMLUtils.getElementText(element2);
        byte[] byArray = Base64EncDec.decode(string2);
        if (byArray == null) {
            return null;
        }
        try {
            byte[] byArray2 = null;
            Cipher cipher = this.createCipher(2);
            byArray2 = cipher.doFinal(byArray);
            return new String(byArray2, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (GeneralSecurityException generalSecurityException) {}
        return null;
    }

    private String encodePassword(String string) {
        if (string == null) {
            return "";
        }
        try {
            byte[] byArray = string.getBytes("UTF8");
            byte[] byArray2 = null;
            Cipher cipher = this.createCipher(1);
            byArray2 = cipher.doFinal(byArray);
            return Base64EncDec.encode(byArray2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (GeneralSecurityException generalSecurityException) {}
        return "";
    }

    private IFile getStoreFile() {
        IFile iFile = null;
        if (this.project != null) {
            iFile = this.project.getFile(".mtj");
        }
        return iFile;
    }

    private IFile getStoreIFile() {
        return this.project.getFile(".mtj");
    }

    private void initializeToDefaults() {
        this.signatureProps = new SignatureProperties();
        this.configurations = new MTJRuntimeList();
    }

    private void loadConfigsCompatibly(Element element) throws PersistenceException {
        this.loadDevice(element);
        Element element2 = XMLUtils.getFirstElementWithTagName(element, "configurations");
        this.configurations = element2 != null ? new MTJRuntimeList(element2) : new MTJRuntimeList();
        if (this.configurations.isEmpty() && this.device != null) {
            this.setDeviceIntoActiveConfig(this.device);
        }
    }

    private void loadConfigurations(Element element) throws PersistenceException {
        this.loadConfigsCompatibly(element);
        MTJRuntime mTJRuntime = this.configurations.getActiveMTJRuntime();
        if (mTJRuntime != null) {
            this.device = this.configurations.getActiveMTJRuntime().getDevice();
        }
    }

    private void loadDevice(Element element) throws PersistenceException {
        Element element2 = XMLUtils.getFirstElementWithTagName(element, "device");
        if (element2 != null) {
            String string = element2.getAttribute("group");
            String string2 = element2.getAttribute("name");
            this.device = MTJCore.getDeviceRegistry().getDevice(string, string2);
        }
    }

    private void loadMetaData() throws CoreException {
        boolean bl = false;
        this.loadMetaDataFromFile();
        if (this.signatureProps == null) {
            this.signatureProps = new SignatureProperties();
            this.signatureProps.clear();
            bl = true;
        }
    }

    private void loadMetaDataFromFile() throws CoreException {
        IFile iFile = this.getStoreFile();
        if (iFile != null && iFile.exists()) {
            try {
                File file = iFile.getLocation().toFile();
                Document document = XMLUtils.readDocument(file);
                if (document == null) {
                    return;
                }
                this.rootXmlElement = document.getDocumentElement();
                if (!this.rootXmlElement.getNodeName().equals("mtjMetadata")) {
                    return;
                }
                this.version = XMLUtils.getVersion(document);
                this.jadFileName = this.rootXmlElement.getAttribute("jad");
                this.loadDevice(this.rootXmlElement);
                this.loadConfigurations(this.rootXmlElement);
                this.loadSignatureProperties(this.rootXmlElement);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                MTJStatusHandler.throwCoreException(2, 99999, parserConfigurationException);
            }
            catch (SAXException sAXException) {
                MTJStatusHandler.throwCoreException(2, 99999, sAXException);
            }
            catch (IOException iOException) {
                MTJStatusHandler.throwCoreException(2, 99999, iOException);
            }
            catch (PersistenceException persistenceException) {
                MTJStatusHandler.throwCoreException(2, 99999, persistenceException);
            }
        } else {
            this.initializeToDefaults();
        }
    }

    private void loadSignatureProperties(Element element) throws CoreException {
        SignatureProperties signatureProperties = new SignatureProperties();
        Element element2 = XMLUtils.getFirstElementWithTagName(element, "signing");
        if (element2 == null) {
            return;
        }
        String string = element2.getAttribute("projectSpecific");
        if (string == null) {
            return;
        }
        signatureProperties.setProjectSpecific(Boolean.valueOf(string));
        string = element2.getAttribute("signProject");
        if (string == null) {
            return;
        }
        signatureProperties.setSignProject(Boolean.valueOf(string));
        this.signatureProps = signatureProperties;
        Element element3 = XMLUtils.getFirstElementWithTagName(element2, "keystore");
        if (element3 != null) {
            signatureProperties.setKeyStoreDisplayPath(XMLUtils.getElementText(element3));
        }
        if ((element3 = XMLUtils.getFirstElementWithTagName(element2, "alias")) != null) {
            signatureProperties.setKeyAlias(XMLUtils.getElementText(element3));
        }
        if ((element3 = XMLUtils.getFirstElementWithTagName(element2, "provider")) != null) {
            signatureProperties.setKeyStoreProvider(XMLUtils.getElementText(element3));
        }
        if ((element3 = XMLUtils.getFirstElementWithTagName(element2, "keystoreType")) != null) {
            signatureProperties.setKeyStoreType(XMLUtils.getElementText(element3));
        }
        if ((element3 = XMLUtils.getFirstElementWithTagName(element2, "passwords")) != null) {
            string = element3.getAttribute("storePasswords");
            int n = 0;
            if (string != null) {
                try {
                    n = Integer.valueOf(string);
                }
                catch (Exception exception) {}
            }
            switch (n) {
                case 1: {
                    signatureProperties.setPasswordStorageMethod(n);
                    ISecurePreferences iSecurePreferences = SecurePreferencesFactory.getDefault();
                    String string2 = Utils.getKeyringURL(this.project);
                    if (!iSecurePreferences.nodeExists(string2)) break;
                    ISecurePreferences iSecurePreferences2 = iSecurePreferences.node(string2);
                    try {
                        signatureProperties.setKeyStorePassword(iSecurePreferences2.get("KeystorePass", ""));
                        signatureProperties.setKeyPassword(iSecurePreferences2.get("KeyPass", ""));
                    }
                    catch (StorageException storageException) {
                        this.signatureProps = signatureProperties;
                        MTJCoreErrors.throwCoreExceptionError(7676, "Could not re password into keyring,", storageException);
                    }
                    break;
                }
                case 2: {
                    signatureProperties.setPasswordStorageMethod(n);
                    signatureProperties.setKeyStorePassword(this.decodePassword(element3, "keystore"));
                    signatureProperties.setKeyPassword(this.decodePassword(element3, "key"));
                    break;
                }
                default: {
                    signatureProperties.setPasswordStorageMethod(0);
                    signatureProperties.setKeyStorePassword(null);
                    signatureProperties.setKeyPassword(null);
                }
            }
        }
    }

    private void removeChildXmlElement(Element element, String string) {
        Element element2 = XMLUtils.getFirstElementWithTagName(element, string);
        if (element2 != null) {
            element2.getParentNode().removeChild(element2);
        }
    }

    private void saveConfigurations(Element element) {
        if (this.configurations == null) {
            return;
        }
        this.removeChildXmlElement(element, "configurations");
        Element element2 = XMLUtils.createChild(element, "configurations");
        for (MTJRuntime mTJRuntime : this.configurations) {
            Element element3 = XMLUtils.createChild(element2, "configuration");
            element3.setAttribute("name", mTJRuntime.getName());
            element3.setAttribute("active", String.valueOf(mTJRuntime.isActive()));
            this.saveDevice(element3, mTJRuntime.getDevice());
            this.saveSymbolSet(element3, mTJRuntime.getSymbolSet());
            this.saveWorkspaceSymbolSets(element3, mTJRuntime.getWorkspaceScopeSymbolSets());
        }
    }

    private void saveDevice(Element element, IDevice iDevice) {
        if (iDevice == null) {
            return;
        }
        this.removeChildXmlElement(element, "device");
        Element element2 = XMLUtils.createChild(element, "device");
        element2.setAttribute("group", iDevice.getSDKName());
        element2.setAttribute("name", iDevice.getName());
    }

    private void saveMetaDataToFile(IFile iFile) throws CoreException {
        try {
            String string = MTJCore.getMTJCoreVersion();
            Version version = new Version(string);
            if (this.rootXmlElement == null) {
                this.rootXmlElement = XMLUtils.createRootElement("mtjMetadata", version);
            } else {
                this.rootXmlElement.setAttribute("version", version.toString());
            }
            if (this.jadFileName != null) {
                this.rootXmlElement.setAttribute("jad", this.jadFileName);
            }
            this.saveDevice(this.rootXmlElement, this.device);
            this.saveSignatureProps(this.rootXmlElement);
            this.saveConfigurations(this.rootXmlElement);
            File file = iFile.getLocation().toFile();
            XMLUtils.writeDocument(file, this.rootXmlElement.getOwnerDocument());
            this.version = version;
            this.getStoreIFile().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            MTJStatusHandler.throwCoreException(2, 99999, parserConfigurationException);
        }
        catch (TransformerException transformerException) {
            MTJStatusHandler.throwCoreException(2, 99999, transformerException);
        }
        catch (IOException iOException) {
            MTJStatusHandler.throwCoreException(2, 99999, iOException);
        }
    }

    private void saveSignatureProps(Element element) throws CoreException {
        ISecurePreferences iSecurePreferences;
        this.removeChildXmlElement(element, "signing");
        Element element2 = XMLUtils.createChild(element, "signing");
        boolean bl = this.signatureProps.isSignProject();
        element2.setAttribute("signProject", Boolean.toString(bl));
        boolean bl2 = this.signatureProps.isProjectSpecific();
        element2.setAttribute("projectSpecific", Boolean.toString(bl2));
        XMLUtils.createTextElement(element2, "alias", this.signatureProps.getKeyAlias());
        if (!bl2) {
            return;
        }
        XMLUtils.createTextElement(element2, "keystore", this.signatureProps.getKeyStoreDisplayPath());
        XMLUtils.createTextElement(element2, "provider", this.signatureProps.getKeyStoreProvider());
        XMLUtils.createTextElement(element2, "keystoreType", this.signatureProps.getKeyStoreType());
        Element element3 = XMLUtils.createChild(element2, "passwords");
        element3.setAttribute("storePasswords", Integer.toString(this.signatureProps.getPasswordStorageMethod()));
        ISecurePreferences iSecurePreferences2 = SecurePreferencesFactory.getDefault();
        String string = Utils.getKeyringURL(this.project);
        if (iSecurePreferences2.nodeExists(string)) {
            iSecurePreferences = iSecurePreferences2.node(string);
            iSecurePreferences.clear();
        }
        switch (this.signatureProps.getPasswordStorageMethod()) {
            case 2: {
                XMLUtils.createTextElement(element3, "keystore", this.encodePassword(this.signatureProps.getKeyStorePassword()));
                XMLUtils.createTextElement(element3, "key", this.encodePassword(this.signatureProps.getKeyPassword()));
                break;
            }
            case 1: {
                iSecurePreferences = iSecurePreferences2.node(string);
                try {
                    iSecurePreferences.put("KeystorePass", this.signatureProps.getKeyStorePassword(), false);
                    iSecurePreferences.put("KeyPass", this.signatureProps.getKeyPassword(), false);
                }
                catch (StorageException storageException) {
                    MTJCoreErrors.throwCoreExceptionError(7676, "Could not save password into keyring,", storageException);
                }
                break;
            }
        }
    }

    private void saveSymbol(Element element, ISymbol iSymbol) {
        Element element2 = XMLUtils.createChild(element, "symbol");
        element2.setAttribute("name", iSymbol.getName());
        element2.setAttribute("value", iSymbol.getValue());
    }

    private void saveSymbolSet(Element element, ISymbolSet iSymbolSet) {
        if (iSymbolSet == null) {
            return;
        }
        Element element2 = XMLUtils.createChild(element, "symbolSet");
        element2.setAttribute("name", iSymbolSet.getName());
        for (ISymbol iSymbol : iSymbolSet.getSymbols()) {
            this.saveSymbol(element2, iSymbol);
        }
    }

    private void saveWorkspaceSymbolSets(Element element, List<ISymbolSet> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (ISymbolSet iSymbolSet : list) {
            Element element2 = XMLUtils.createChild(element, "workspaceSymbolSet");
            element2.setAttribute("name", iSymbolSet.getName());
        }
    }

    private void setDeviceIntoActiveConfig(IDevice iDevice) {
        MTJRuntime mTJRuntime = this.configurations.getActiveMTJRuntime();
        if (mTJRuntime != null) {
            mTJRuntime.setDevice(iDevice);
            return;
        }
        if (mTJRuntime == null && !this.configurations.isEmpty()) {
            mTJRuntime = (MTJRuntime)this.configurations.get(0);
        }
        if (mTJRuntime == null) {
            mTJRuntime = new MTJRuntime(iDevice.getName());
            mTJRuntime.setSymbolSet(iDevice.getSymbolSet());
        }
        mTJRuntime.setActive(true);
        mTJRuntime.setDevice(iDevice);
        this.configurations.add(mTJRuntime);
    }
}

