/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.sign;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mtj.internal.core.MTJCoreErrors;
import org.eclipse.mtj.internal.core.Messages;

public class KeyChainSet {
    private X509Certificate[] m_certChain;
    private PrivateKey m_key;
    private String m_strProvider;

    public static KeyChainSet getInstance(InputStream inputStream, String string, String string2, String string3) throws CoreException {
        return KeyChainSet.getInstance(inputStream, null, null, string, string2, string3);
    }

    public static KeyChainSet getInstance(InputStream inputStream, String string, String string2, String string3, String string4, String string5) throws CoreException {
        Object object;
        KeyStore keyStore = null;
        PrivateKey privateKey = null;
        X509Certificate[] x509CertificateArray = null;
        if (string4 == null) {
            MTJCoreErrors.throwCoreExceptionError(999, Messages.KeyChainSet_noAliasSelected);
        }
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        if (string != null && string.length() == 0) {
            string = null;
        }
        try {
            if (string == null) {
                string = KeyStore.getDefaultType();
            }
            keyStore = string2 == null ? KeyStore.getInstance(string) : KeyStore.getInstance(string, string2);
            keyStore.load(inputStream, string3.toCharArray());
            object = keyStore.getKey(string4, string5.toCharArray());
            if (object == null) {
                MTJCoreErrors.throwCoreExceptionError(10006, Messages.MTJCoreError_10006);
            }
            if (!(object instanceof PrivateKey)) {
                MTJCoreErrors.throwCoreExceptionError(10008, Messages.MTJCoreError_10008);
            }
            privateKey = (PrivateKey)object;
            Certificate[] certificateArray = keyStore.getCertificateChain(string4);
            Certificate certificate = keyStore.getCertificate(string4);
            if (certificateArray != null && certificate != null) {
                if (!(certificate instanceof X509Certificate)) {
                    MTJCoreErrors.throwCoreExceptionError(10009, Messages.MTJCoreError_10009);
                }
                X509Certificate x509Certificate = (X509Certificate)certificate;
                X509Certificate[] x509CertificateArray2 = new X509Certificate[certificateArray.length];
                int n = 0;
                while (n < certificateArray.length) {
                    if (certificateArray[n] instanceof X509Certificate) {
                        x509CertificateArray2[n] = (X509Certificate)certificateArray[n];
                    } else {
                        MTJCoreErrors.throwCoreExceptionError(10009, Messages.MTJCoreError_10009);
                    }
                    ++n;
                }
                if (x509CertificateArray2[0].equals(x509Certificate)) {
                    x509CertificateArray = x509CertificateArray2;
                } else {
                    x509CertificateArray = new X509Certificate[certificateArray.length];
                    x509CertificateArray[0] = x509Certificate;
                    n = 1;
                    while (n < certificateArray.length) {
                        x509CertificateArray[n] = KeyChainSet.findParentCertificate(x509CertificateArray[n - 1], x509CertificateArray2);
                        if (x509CertificateArray[n] == null) {
                            MTJCoreErrors.throwCoreExceptionError(10009, Messages.MTJCoreError_10009);
                        }
                        ++n;
                    }
                }
            }
        }
        catch (IOException iOException) {
            MTJCoreErrors.throwCoreExceptionError(10001, Messages.MTJCoreError_10001);
        }
        catch (KeyStoreException keyStoreException) {
            MTJCoreErrors.throwCoreExceptionError(10002, Messages.MTJCoreError_10002, keyStoreException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            MTJCoreErrors.throwCoreExceptionError(10003, Messages.MTJCoreError_10003, noSuchProviderException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            MTJCoreErrors.throwCoreExceptionError(10004, Messages.MTJCoreError_10004, noSuchAlgorithmException);
        }
        catch (CertificateException certificateException) {
            MTJCoreErrors.throwCoreExceptionError(10005, Messages.MTJCoreError_10005, certificateException);
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            MTJCoreErrors.throwCoreExceptionError(10007, Messages.MTJCoreError_10007, unrecoverableKeyException);
        }
        object = new KeyChainSet(privateKey, x509CertificateArray, string2);
        return object;
    }

    private static X509Certificate findParentCertificate(X509Certificate x509Certificate, X509Certificate[] x509CertificateArray) {
        Principal principal = x509Certificate.getIssuerDN();
        X509Certificate x509Certificate2 = null;
        int n = 0;
        while (n < x509CertificateArray.length) {
            Principal principal2;
            if (x509CertificateArray[n] != null && (principal2 = x509CertificateArray[n].getSubjectDN()).equals(principal)) {
                x509Certificate2 = x509CertificateArray[n];
                x509CertificateArray[n] = null;
                break;
            }
            ++n;
        }
        return x509Certificate2;
    }

    private KeyChainSet(PrivateKey privateKey, X509Certificate[] x509CertificateArray, String string) {
        this.m_key = privateKey;
        this.m_certChain = x509CertificateArray;
        this.m_strProvider = string;
    }

    public X509Certificate[] getCertificateChain() {
        return this.m_certChain;
    }

    public PrivateKey getKey() {
        return this.m_key;
    }

    public String getProvider() {
        return this.m_strProvider;
    }

    void setCertificateChain(X509Certificate[] x509CertificateArray) {
        this.m_certChain = x509CertificateArray;
    }

    void setKey(PrivateKey privateKey) {
        this.m_key = privateKey;
    }

    void setProvider(String string) {
        this.m_strProvider = string;
    }
}

