/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.preverifier.builder;

import de.schlichtherle.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.internal.core.build.packaging.PackageBuilder;
import org.eclipse.mtj.internal.core.build.preverifier.builder.SourceResourcesFilter;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.text.IResourceFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BuildInfo {
    private int buildKind;
    private Map<?, ?> buildArgs;
    private IMidletSuiteProject midletSuite;
    private IMidletSuiteProject targetMidletSuite;
    private IJavaProject baseJavaProject;
    private IJavaProject currentJavaProject;
    private IPath[] outputFolders;
    private IResourceDelta currentResourceDelta;
    private IResourceFilter resourceFilter;
    private boolean packageDirty;
    private boolean classpathChanged;
    private Set<File> preverifiedLibraries;

    BuildInfo(int n, Map<?, ?> map, IJavaProject iJavaProject) throws JavaModelException {
        this.buildKind = n;
        this.buildArgs = map;
        this.baseJavaProject = iJavaProject;
        this.midletSuite = MidletSuiteFactory.getMidletSuiteProject(iJavaProject);
        this.classpathChanged = false;
        this.preverifiedLibraries = new HashSet<File>();
        this.setCurrentJavaProject(iJavaProject);
    }

    public void addPreverifiedLibrary(File file) {
        this.preverifiedLibraries.add(file);
    }

    public boolean areClassesPreverified() {
        boolean bl = true;
        String string = (String)this.buildArgs.get("preverifyClasses");
        if (string != null && string.equals("false")) {
            bl = false;
        }
        return bl;
    }

    public boolean areLibrariesPreverified() {
        boolean bl = true;
        String string = (String)this.buildArgs.get("preverifyLibraries");
        if (string != null && string.equals("false")) {
            bl = false;
        }
        return bl;
    }

    public IJavaProject getBaseJavaProject() {
        return this.baseJavaProject;
    }

    public Map<?, ?> getBuildArgs() {
        return this.buildArgs;
    }

    public int getBuildKind() {
        return this.buildKind;
    }

    public IJavaProject getCurrentJavaProject() {
        return this.currentJavaProject;
    }

    public IResourceDelta getCurrentResourceDelta() {
        return this.currentResourceDelta;
    }

    public IMidletSuiteProject getMidletSuite() {
        return this.midletSuite;
    }

    public IResourceFilter getResourceFilter() {
        return this.resourceFilter;
    }

    public IMidletSuiteProject getTargetMidletSuite() {
        if (this.targetMidletSuite == null) {
            String string = (String)this.buildArgs.get("preverifyTargetProject");
            if (string == null) {
                this.targetMidletSuite = this.midletSuite;
            } else {
                IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string);
                IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
                this.targetMidletSuite = MidletSuiteFactory.getMidletSuiteProject(iJavaProject);
            }
        }
        return this.targetMidletSuite;
    }

    public boolean isCurrentProjectMidletSuite() {
        return this.currentJavaProject.equals(this.baseJavaProject);
    }

    IFolder getVerifiedClassesFolder(IProgressMonitor iProgressMonitor) throws CoreException {
        IFolder iFolder = null;
        IMidletSuiteProject iMidletSuiteProject = null;
        IMidletSuiteProject iMidletSuiteProject2 = null;
        iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject(this.currentJavaProject);
        iMidletSuiteProject2 = MidletSuiteFactory.getMidletSuiteProject(this.baseJavaProject);
        if (iMidletSuiteProject.getProject() == iMidletSuiteProject2.getProject()) {
            iFolder = iMidletSuiteProject2.getVerifiedClassesOutputFolder(iProgressMonitor);
        } else {
            IFolder iFolder2 = iMidletSuiteProject2.getVerifiedOutputFolder(iProgressMonitor);
            iFolder = iFolder2.getFolder("required-classes");
        }
        PackageBuilder.createFolders(iFolder, iProgressMonitor);
        return iFolder;
    }

    IFolder getVerifiedLibsFolder(IProgressMonitor iProgressMonitor) throws CoreException {
        IFolder iFolder = null;
        IMidletSuiteProject iMidletSuiteProject = null;
        IMidletSuiteProject iMidletSuiteProject2 = null;
        iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject(this.currentJavaProject);
        iMidletSuiteProject2 = MidletSuiteFactory.getMidletSuiteProject(this.baseJavaProject);
        if (iMidletSuiteProject.getProject() == iMidletSuiteProject2.getProject()) {
            iFolder = iMidletSuiteProject2.getVerifiedLibrariesOutputFolder(iProgressMonitor);
        } else {
            IFolder iFolder2 = iMidletSuiteProject2.getVerifiedOutputFolder(iProgressMonitor);
            iFolder = iFolder2.getFolder("required-libs");
        }
        PackageBuilder.createFolders(iFolder, iProgressMonitor);
        return iFolder;
    }

    boolean isCurrentProjectTheBaseProject() {
        return this.currentJavaProject.equals(this.baseJavaProject);
    }

    boolean isOutputResource(IResource iResource) {
        boolean bl = false;
        IPath iPath = iResource.getFullPath();
        int n = 0;
        while (n < this.outputFolders.length) {
            IPath iPath2 = this.outputFolders[n];
            if (iPath2.isPrefixOf(iPath)) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    public void setCurrentJavaProject(IJavaProject iJavaProject) throws JavaModelException {
        this.currentJavaProject = iJavaProject;
        this.resourceFilter = new SourceResourcesFilter(iJavaProject);
        this.initializeOutputFolders(iJavaProject);
    }

    public void setCurrentResourceDelta(IResourceDelta iResourceDelta) {
        this.currentResourceDelta = iResourceDelta;
    }

    public boolean hasLibraryBeenPreverified(File file) {
        return this.preverifiedLibraries.contains(file);
    }

    public boolean isBuildArgumentTrue(String string) {
        Boolean bl = (Boolean)this.getBuildArgs().get(string);
        return bl != null && bl != false;
    }

    public boolean isClasspathChanged() {
        return this.classpathChanged;
    }

    protected boolean isPackageDirty() {
        return this.packageDirty;
    }

    public void setClasspathChanged(boolean bl) {
        this.classpathChanged = bl;
    }

    protected void setPackageDirty(boolean bl) {
        this.packageDirty = bl;
    }

    private void initializeOutputFolders(IJavaProject iJavaProject) throws JavaModelException {
        HashSet<IPath> hashSet = new HashSet<IPath>();
        hashSet.add(iJavaProject.getOutputLocation());
        IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
        int n = 0;
        while (n < iClasspathEntryArray.length) {
            IPath iPath;
            IClasspathEntry iClasspathEntry = iClasspathEntryArray[n];
            if (iClasspathEntry.getEntryKind() == 3 && (iPath = iClasspathEntry.getOutputLocation()) != null) {
                hashSet.add(iPath);
            }
            ++n;
        }
        this.outputFolders = hashSet.toArray(new IPath[hashSet.size()]);
    }
}

