/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.packaging;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.core.project.runtime.MTJRuntimeList;
import org.eclipse.mtj.internal.core.build.MTJBuildProperties;
import org.eclipse.mtj.internal.core.build.packaging.PackageBuilder;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageBuilderVisitor
implements IResourceVisitor,
IResourceDeltaVisitor {
    private IMidletSuiteProject suiteProject;
    private MTJBuildProperties properties;
    private List<IFile> resources = new ArrayList<IFile>();
    private List<IFile> classes = new ArrayList<IFile>();
    private de.schlichtherle.io.File jar;

    public PackageBuilderVisitor(IMidletSuiteProject iMidletSuiteProject, de.schlichtherle.io.File file) {
        this.properties = MTJBuildProperties.getBuildProperties(iMidletSuiteProject);
        this.suiteProject = iMidletSuiteProject;
        this.jar = file;
    }

    public boolean visit(IResource iResource) throws CoreException {
        IFile iFile;
        if (iResource instanceof IFile && this.isOnBuildFolder(iFile = (IFile)iResource)) {
            if (iFile.getName().endsWith(".class")) {
                IFile iFile2 = this.getPreVerifiedClassFile(iFile);
                if (iFile2 != null) {
                    if (this.isOnBuildProperties((IResource)iFile, true)) {
                        this.classes.add(iFile2);
                    } else {
                        this.removeFromJAR(iFile2);
                    }
                }
            } else if (this.isOnBuildProperties(iResource, false)) {
                this.resources.add(iFile);
            } else {
                this.removeFromJAR(iFile);
            }
        }
        return true;
    }

    private boolean isOnBuildFolder(IFile iFile) throws JavaModelException {
        IFolder iFolder = PackageBuilder.getOutputFolder(this.suiteProject.getJavaProject());
        return iFolder.getLocation().isPrefixOf(iFile.getLocation());
    }

    private boolean isOnBuildProperties(IResource iResource, boolean bl) throws CoreException {
        MTJRuntimeList mTJRuntimeList = this.suiteProject.getRuntimeList();
        MTJRuntime mTJRuntime = mTJRuntimeList.getActiveMTJRuntime();
        boolean bl2 = false;
        if (mTJRuntime != null) {
            IPath iPath = this.getOutputFolderRelativePath(iResource);
            if (!iPath.isEmpty()) {
                IResource[] iResourceArray;
                IPath iPath2 = iPath.removeLastSegments(1);
                String string = iPath.lastSegment().replace(".class", "");
                IResource[] iResourceArray2 = iResourceArray = this.properties.getBuildProperty(mTJRuntime);
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string2;
                    IResource iResource2 = iResourceArray2[n2];
                    IPath iPath3 = Utils.extractsSourceFolderRelativePath(this.suiteProject.getJavaProject(), iResource2, true);
                    IPath iPath4 = iPath3.removeLastSegments(1);
                    bl2 = Pattern.matches(NLS.bind((String)"{0}([$].+)?", (Object)iPath4.append(string2 = iPath3.lastSegment().replace(".java", ""))), iPath2.append(string).toString());
                    if (!bl2) {
                        ++n2;
                        continue;
                    }
                    break;
                }
            }
        } else {
            bl2 = true;
        }
        return bl2;
    }

    private IPath getOutputFolderRelativePath(IResource iResource) throws CoreException {
        IFolder iFolder = PackageBuilder.getOutputFolder(this.suiteProject.getJavaProject());
        if (iFolder.getFullPath().isPrefixOf(iResource.getFullPath())) {
            IPath iPath = iResource.getFullPath().removeFirstSegments(iFolder.getFullPath().segmentCount());
            return new Path(iPath.toString());
        }
        return new Path("");
    }

    private IFile getPreVerifiedClassFile(IFile iFile) throws CoreException {
        IFolder iFolder = this.suiteProject.getVerifiedClassesOutputFolder((IProgressMonitor)new NullProgressMonitor());
        IFile iFile2 = iFolder.getFile(this.getOutputFolderRelativePath((IResource)iFile));
        if (iFile2.exists()) {
            return iFile2;
        }
        return null;
    }

    public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
        IResource iResource = iResourceDelta.getResource();
        if (iResource instanceof IFile) {
            IFile iFile = (IFile)iResource;
            switch (iResourceDelta.getKind()) {
                case 1: 
                case 4: {
                    this.visit((IResource)iFile);
                    break;
                }
                case 2: {
                    this.removeFromJAR(iFile);
                }
            }
        }
        return true;
    }

    private void removeFromJAR(IFile iFile) throws CoreException {
        de.schlichtherle.io.File file;
        IPath iPath = null;
        iPath = iFile.getName().endsWith(".class") ? PackageBuilder.getClassZipPath(this.suiteProject, iFile) : PackageBuilder.getResourceZipPath(this.suiteProject, iFile);
        if (iPath != null && (file = new de.schlichtherle.io.File((File)this.jar, iPath.toString())).exists()) {
            file.delete();
        }
    }

    public List<IFile> getResourcesToPackage() {
        ArrayList<IFile> arrayList = new ArrayList<IFile>();
        arrayList.addAll(this.resources);
        return arrayList;
    }

    public List<IFile> getClassesToPackage() {
        ArrayList<IFile> arrayList = new ArrayList<IFile>();
        arrayList.addAll(this.classes);
        return arrayList;
    }
}

