/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.project.runtime;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.project.runtime.event.IMTJRuntimeChangeListener;
import org.eclipse.mtj.core.project.runtime.event.MTJRuntimeDeviceChangeEvent;
import org.eclipse.mtj.core.project.runtime.event.MTJRuntimeNameChangeEvent;
import org.eclipse.mtj.core.project.runtime.event.MTJRuntimeWorkspaceSymbolSetsChangeEvent;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.symbol.ISymbolSet;
import org.eclipse.mtj.internal.core.project.runtime.MTJRuntimeListUtils;
import org.eclipse.mtj.internal.core.symbol.SymbolSet;
import org.eclipse.mtj.internal.core.symbol.SymbolUtils;
import org.eclipse.mtj.internal.core.util.xml.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTJRuntime {
    public static final String ATTR_DEVICEGROUP = "group";
    public static final String ATTR_DEVICENAME = "name";
    public static final String ATTR_RUNTIMEACTIVE = "active";
    public static final String ATTR_RUNTIMENAME = "name";
    public static final String ATTR_SYMBOL_SET_NAME = "name";
    public static final String ATTR_SYMBOLNAME = "name";
    public static final String ATTR_SYMBOLVALUE = "value";
    public static final String ATTR_WORKSPACESYMBOLSETNAME = "name";
    public static final String ELEM_CONFIGURATION = "configuration";
    public static final String ELEM_DEVICE = "device";
    public static final String ELEM_SYMBOL = "symbol";
    public static final String ELEM_SYMBOL_SET = "symbolSet";
    public static final String ELEM_WORKSPACE_SYMBOLSET = "workspaceSymbolSet";
    private boolean active;
    private IDevice device;
    private List<IMTJRuntimeChangeListener> listeners = new ArrayList<IMTJRuntimeChangeListener>();
    private String name;
    private ISymbolSet symbolSet;
    private List<ISymbolSet> workspaceScopeSymbolSets;

    public MTJRuntime(Element element) throws PersistenceException {
        this.name = element.getAttribute("name");
        this.active = Boolean.valueOf(element.getAttribute(ATTR_RUNTIMEACTIVE));
        this.loadDevice(element);
        this.loadSymbolSet(element);
        this.loadWorkspaceSymbolSets(element);
    }

    public MTJRuntime(String string) {
        this.name = string;
    }

    public void addMTJRuntimeChangeListener(IMTJRuntimeChangeListener iMTJRuntimeChangeListener) {
        this.listeners.add(iMTJRuntimeChangeListener);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MTJRuntime mTJRuntime = (MTJRuntime)object;
        return !(this.name == null ? mTJRuntime.name != null : !this.name.equals(mTJRuntime.name));
    }

    public void fireSymbolSetChanged() {
        for (IMTJRuntimeChangeListener iMTJRuntimeChangeListener : this.listeners) {
            iMTJRuntimeChangeListener.symbolSetChanged();
        }
    }

    public IDevice getDevice() {
        return this.device;
    }

    public String getName() {
        return this.name;
    }

    public ISymbolSet getSymbolSet() {
        if (this.symbolSet == null) {
            SymbolSet symbolSet = (SymbolSet)this.device.getSymbolSet();
            try {
                this.symbolSet = (ISymbolSet)symbolSet.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                this.symbolSet = new SymbolSet();
                this.symbolSet.setName(this.getName());
            }
        }
        return this.symbolSet;
    }

    public ISymbolSet getSymbolSetForPreprocessing() {
        ISymbolSet iSymbolSet = MTJCore.getSymbolSetFactory().createSymbolSet(String.valueOf(this.getSymbolSet().getName()) + " For Preprocessing");
        iSymbolSet.add(this.symbolSet.getSymbols());
        String string = this.getName().replace(' ', '_');
        string = SymbolUtils.replaceFirstNonLetterChar(string);
        iSymbolSet.add(string, Boolean.TRUE.toString(), 1);
        return iSymbolSet;
    }

    public List<ISymbolSet> getWorkspaceScopeSymbolSets() {
        if (this.workspaceScopeSymbolSets == null) {
            this.workspaceScopeSymbolSets = new ArrayList<ISymbolSet>();
        }
        return this.workspaceScopeSymbolSets;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        return n;
    }

    public boolean isActive() {
        return this.active;
    }

    public void removeMTJRuntimeChangeListener(IMTJRuntimeChangeListener iMTJRuntimeChangeListener) {
        this.listeners.remove(iMTJRuntimeChangeListener);
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public void setDevice(IDevice iDevice) {
        if (this.device == iDevice) {
            return;
        }
        IDevice iDevice2 = this.device;
        this.device = iDevice;
        this.symbolSet = iDevice.getSymbolSet();
        MTJRuntimeDeviceChangeEvent mTJRuntimeDeviceChangeEvent = new MTJRuntimeDeviceChangeEvent(this, iDevice2, iDevice);
        for (IMTJRuntimeChangeListener iMTJRuntimeChangeListener : this.listeners) {
            iMTJRuntimeChangeListener.deviceChanged(mTJRuntimeDeviceChangeEvent);
        }
    }

    public void setName(String string) {
        if (this.name.equals(string)) {
            return;
        }
        String string2 = this.name;
        this.name = string;
        MTJRuntimeNameChangeEvent mTJRuntimeNameChangeEvent = new MTJRuntimeNameChangeEvent(this, string2, string);
        for (IMTJRuntimeChangeListener iMTJRuntimeChangeListener : this.listeners) {
            iMTJRuntimeChangeListener.nameChanged(mTJRuntimeNameChangeEvent);
        }
    }

    public void setSymbolSet(ISymbolSet iSymbolSet) {
        this.symbolSet = iSymbolSet;
    }

    public void setWorkspaceScopeSymbolSets(List<ISymbolSet> list) {
        if (MTJRuntimeListUtils.workspaceSymbolsetsEquals(this.workspaceScopeSymbolSets, list)) {
            return;
        }
        List<ISymbolSet> list2 = this.workspaceScopeSymbolSets;
        this.workspaceScopeSymbolSets = list;
        MTJRuntimeWorkspaceSymbolSetsChangeEvent mTJRuntimeWorkspaceSymbolSetsChangeEvent = new MTJRuntimeWorkspaceSymbolSetsChangeEvent(this, list2, list);
        for (IMTJRuntimeChangeListener iMTJRuntimeChangeListener : this.listeners) {
            iMTJRuntimeChangeListener.workspaceScopeSymbolSetsChanged(mTJRuntimeWorkspaceSymbolSetsChangeEvent);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append("name=").append(this.name).append("|active=").append(this.active).append("|device=").append(this.device.getName()).append("|symbolSet=").append(this.symbolSet);
        return stringBuffer.toString();
    }

    private void loadDevice(Element element) throws PersistenceException {
        Element element2 = XMLUtils.getFirstElementWithTagName(element, ELEM_DEVICE);
        if (element2 != null) {
            String string = element2.getAttribute(ATTR_DEVICEGROUP);
            String string2 = element2.getAttribute("name");
            this.device = MTJCore.getDeviceRegistry().getDevice(string, string2);
        }
    }

    private void loadSymbolSet(Element element) {
        this.symbolSet = new SymbolSet();
        Element element2 = XMLUtils.getFirstElementWithTagName(element, ELEM_SYMBOL_SET);
        if (!element2.getAttribute("name").equals("")) {
            this.symbolSet.setName(element2.getAttribute("name"));
        } else if (this.device != null) {
            this.symbolSet.setName(this.device.getName());
        }
        NodeList nodeList = element2.getElementsByTagName(ELEM_SYMBOL);
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element3 = (Element)nodeList.item(n);
            String string = element3.getAttribute("name");
            String string2 = element3.getAttribute(ATTR_SYMBOLVALUE);
            this.symbolSet.add(string, string2);
            ++n;
        }
    }

    private void loadWorkspaceSymbolSets(Element element) throws PersistenceException {
        NodeList nodeList = element.getElementsByTagName(ELEM_WORKSPACE_SYMBOLSET);
        if (nodeList == null || nodeList.getLength() == 0) {
            return;
        }
        this.workspaceScopeSymbolSets = new ArrayList<ISymbolSet>();
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element2 = (Element)nodeList.item(n);
            String string = element2.getAttribute("name");
            ISymbolSet iSymbolSet = MTJCore.getSymbolSetRegistry().getSymbolSet(string);
            if (iSymbolSet != null) {
                this.workspaceScopeSymbolSets.add(iSymbolSet);
            }
            ++n;
        }
    }
}

