/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.preprocess.contentAssistant;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.PreprocessCompletionEngine;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.PreprocessContext;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.ProposalType;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.template.PreprocessTemplateAccess;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.template.PreprocessTemplateContextType;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.template.PreprocessTemplateEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreprocessProposalComputer
implements IJavaCompletionProposalComputer {
    private PreprocessTemplateEngine tmplateEngine;
    private PreprocessCompletionEngine pPEngine = new PreprocessCompletionEngine();

    public PreprocessProposalComputer() {
        PreprocessTemplateContextType preprocessTemplateContextType = (PreprocessTemplateContextType)PreprocessTemplateAccess.getDefault().getTemplateContextRegistry().getContextType("org.eclipse.mtj.preprocess");
        this.tmplateEngine = new PreprocessTemplateEngine(preprocessTemplateContextType);
    }

    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext contentAssistInvocationContext, IProgressMonitor iProgressMonitor) {
        JavaContentAssistInvocationContext javaContentAssistInvocationContext = (JavaContentAssistInvocationContext)contentAssistInvocationContext;
        IProject iProject = javaContentAssistInvocationContext.getCompilationUnit().getJavaProject().getProject();
        int n = contentAssistInvocationContext.getInvocationOffset();
        IDocument iDocument = contentAssistInvocationContext.getDocument();
        PreprocessContext preprocessContext = new PreprocessContext(iDocument, n, iProject);
        ArrayList<ICompletionProposal> arrayList = new ArrayList<ICompletionProposal>();
        for (ProposalType proposalType : preprocessContext.getPossibleProposalTypes()) {
            switch (proposalType) {
                case DIRECTIVE: {
                    arrayList.addAll(this.pPEngine.completeDirective(preprocessContext));
                    break;
                }
                case SYMBOL: {
                    arrayList.addAll(this.pPEngine.completeSymbol(preprocessContext));
                    break;
                }
                case DEBUG_LEVER: {
                    arrayList.addAll(this.pPEngine.completeDebugLevel(preprocessContext));
                    break;
                }
                case TEMPLATE: {
                    arrayList.addAll(this.tmplateEngine.complete(preprocessContext));
                }
            }
        }
        return arrayList;
    }

    public List<?> computeContextInformation(ContentAssistInvocationContext contentAssistInvocationContext, IProgressMonitor iProgressMonitor) {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionEnded() {
    }

    public void sessionStarted() {
    }
}

