/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.pulsar.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.equinox.internal.p2.console.ProvisioningHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.mtj.internal.provisional.pulsar.core.ISDK;
import org.eclipse.mtj.internal.pulsar.core.SDK;
import org.eclipse.mtj.pulsar.core.Activator;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2Utils {
    public static final String PROP_PULSAR_PROFILE = "org.eclipse.pulsar.profile";

    public static boolean isInstalled(IInstallableUnit iInstallableUnit) {
        IProfile[] iProfileArray = ProvisioningHelper.getProfiles();
        int n = iProfileArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProfile iProfile = iProfileArray[n2];
            Collector collector = new Collector();
            iProfile.available((Query)new InstallableUnitQuery(iInstallableUnit.getId(), iInstallableUnit.getVersion()), collector, null);
            if (!collector.isEmpty()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static IProfile createProfile(String string, IPath iPath) throws ProvisionException {
        IProfileRegistry iProfileRegistry = (IProfileRegistry)ServiceHelper.getService((BundleContext)Activator.getContext(), (String)IProfileRegistry.class.getName());
        Properties properties = new Properties();
        if (iPath != null) {
            properties.setProperty("org.eclipse.equinox.p2.installFolder", iPath.toOSString());
        }
        properties.setProperty(PROP_PULSAR_PROFILE, Boolean.TRUE.toString());
        return iProfileRegistry.addProfile(string, (Map)properties, null);
    }

    public static void deleteProfile(String string) {
        IProfileRegistry iProfileRegistry = (IProfileRegistry)ServiceHelper.getService((BundleContext)Activator.getContext(), (String)IProfileRegistry.class.getName());
        iProfileRegistry.removeProfile(string);
    }

    public static IProfile createProfileForSDK(ISDK iSDK, IPath iPath) throws ProvisionException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("org.eclipse.pulsar.profile.");
        stringBuilder.append(((SDK)iSDK).getInstallableUnit().getId());
        stringBuilder.append(".");
        stringBuilder.append(System.currentTimeMillis());
        return P2Utils.createProfile(stringBuilder.toString(), iPath);
    }

    public static boolean isSupportedProfile(IProfile iProfile) {
        return iProfile.getProperty(PROP_PULSAR_PROFILE) != null;
    }

    public static Collection<IProfile> getProfiles() {
        ArrayList<IProfile> arrayList = new ArrayList<IProfile>();
        IProfile[] iProfileArray = ProvisioningHelper.getProfiles();
        int n = iProfileArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProfile iProfile = iProfileArray[n2];
            if (P2Utils.isSupportedProfile(iProfile)) {
                arrayList.add(iProfile);
            }
            ++n2;
        }
        return arrayList;
    }
}

