/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.examples.templates;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.mtj.ui.templates.AbstractTemplateWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExampleTemplatePage
extends AbstractTemplateWizardPage {
    private static final String COLOR_REG_EXP = "(0x)([a-fA-F0-9]){6}";
    private Text bgColorText;
    private Text fgColorText;
    private Button faceSystemBtn;
    private Button faceMonospaceBtn;
    private Button faceProportionalBtn;
    private Button styleBoldBtn;
    private Button styleItalicBtn;
    private Button styleUnderlineBtn;
    private Button sizeSmallBtn;
    private Button sizeMediumBtn;
    private Button sizeLargeBtn;
    private Text msgText;

    public Map<String, String> getDictionary() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("$message$", this.msgText.getText());
        hashMap.put("$bg$", this.bgColorText.getText());
        hashMap.put("$fg$", this.fgColorText.getText());
        hashMap.put("$font-face$", this.getFontFace());
        hashMap.put("$font-style$", this.getFontStyle());
        hashMap.put("$font-size$", this.getFontSize());
        return hashMap;
    }

    public boolean isPageComplete() {
        boolean bl = true;
        bl &= Pattern.matches(COLOR_REG_EXP, this.bgColorText.getText());
        bl &= Pattern.matches(COLOR_REG_EXP, this.fgColorText.getText());
        return bl &= this.msgText.getText().length() > 0;
    }

    public void createControl(Composite composite) {
        GridData gridData = null;
        composite.setLayout((Layout)new GridLayout(1, false));
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        composite2.setLayout((Layout)new GridLayout(1, false));
        Group group = new Group(composite2, 0);
        group.setText("Text Design:");
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label((Composite)group, 0);
        label.setText("Text Message:");
        gridData = new GridData(4);
        label.setLayoutData((Object)gridData);
        this.msgText = new Text((Composite)group, 2048);
        this.msgText.setText("MTJ Rocks...");
        gridData = new GridData(768);
        this.msgText.setLayoutData((Object)gridData);
        this.msgText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ExampleTemplatePage.this.getWizard().getContainer().updateButtons();
            }
        });
        group = new Group(composite2, 0);
        group.setText("Color Design:");
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setLayout((Layout)new GridLayout(2, false));
        Label label2 = new Label((Composite)group, 0);
        label2.setText("Background Color (0xXXXXXX):");
        gridData = new GridData(4);
        label2.setLayoutData((Object)gridData);
        this.bgColorText = new Text((Composite)group, 2048);
        this.bgColorText.setText("0xFFFFFF");
        gridData = new GridData(768);
        this.bgColorText.setLayoutData((Object)gridData);
        this.bgColorText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ExampleTemplatePage.this.getWizard().getContainer().updateButtons();
            }
        });
        Label label3 = new Label((Composite)group, 0);
        label3.setText("Text Color (0xXXXXXX):");
        gridData = new GridData(4);
        label3.setLayoutData((Object)gridData);
        this.fgColorText = new Text((Composite)group, 2048);
        this.fgColorText.setText("0x000000");
        gridData = new GridData(768);
        this.fgColorText.setLayoutData((Object)gridData);
        this.fgColorText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ExampleTemplatePage.this.getWizard().getContainer().updateButtons();
            }
        });
        Group group2 = new Group(composite2, 0);
        group2.setText("Font Design:");
        group2.setLayoutData((Object)new GridData(4, 4, true, false));
        group2.setLayout((Layout)new GridLayout(1, false));
        group = new Group((Composite)group2, 0);
        group.setText("Font Face:");
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setLayout((Layout)new GridLayout(3, false));
        this.faceSystemBtn = new Button((Composite)group, 16);
        this.faceSystemBtn.setText("System");
        gridData = new GridData(768);
        this.faceSystemBtn.setLayoutData((Object)gridData);
        this.faceSystemBtn.setSelection(true);
        this.faceMonospaceBtn = new Button((Composite)group, 16);
        this.faceMonospaceBtn.setText("Monospace");
        gridData = new GridData(768);
        this.faceMonospaceBtn.setLayoutData((Object)gridData);
        this.faceProportionalBtn = new Button((Composite)group, 16);
        this.faceProportionalBtn.setText("Proportional");
        gridData = new GridData(768);
        this.faceProportionalBtn.setLayoutData((Object)gridData);
        group = new Group((Composite)group2, 0);
        group.setText("Font Style:");
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setLayout((Layout)new GridLayout(3, false));
        this.styleBoldBtn = new Button((Composite)group, 32);
        this.styleBoldBtn.setText("Bold");
        gridData = new GridData(768);
        this.styleBoldBtn.setLayoutData((Object)gridData);
        this.styleBoldBtn.setSelection(true);
        this.styleItalicBtn = new Button((Composite)group, 32);
        this.styleItalicBtn.setText("Italic");
        gridData = new GridData(768);
        this.styleItalicBtn.setLayoutData((Object)gridData);
        this.styleItalicBtn.setSelection(true);
        this.styleUnderlineBtn = new Button((Composite)group, 32);
        this.styleUnderlineBtn.setText("Underline");
        gridData = new GridData(768);
        this.styleUnderlineBtn.setLayoutData((Object)gridData);
        this.styleUnderlineBtn.setSelection(true);
        group = new Group((Composite)group2, 0);
        group.setText("Font Size:");
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setLayout((Layout)new GridLayout(3, false));
        this.sizeSmallBtn = new Button((Composite)group, 16);
        this.sizeSmallBtn.setText("Small");
        gridData = new GridData(768);
        this.sizeSmallBtn.setLayoutData((Object)gridData);
        this.sizeMediumBtn = new Button((Composite)group, 16);
        this.sizeMediumBtn.setText("Medium");
        gridData = new GridData(768);
        this.sizeMediumBtn.setLayoutData((Object)gridData);
        this.sizeLargeBtn = new Button((Composite)group, 16);
        this.sizeLargeBtn.setText("Large");
        gridData = new GridData(768);
        this.sizeLargeBtn.setLayoutData((Object)gridData);
        this.sizeLargeBtn.setSelection(true);
        this.setControl((Control)composite2);
    }

    private String getFontSize() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.sizeSmallBtn.getSelection()) {
            stringBuffer.append("Font.SIZE_SMALL");
        } else if (this.sizeMediumBtn.getSelection()) {
            stringBuffer.append("Font.SIZE_MEDIUM");
        } else if (this.sizeLargeBtn.getSelection()) {
            stringBuffer.append("Font.SIZE_LARGE");
        }
        return stringBuffer.toString();
    }

    private String getFontStyle() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.styleBoldBtn.getSelection()) {
            stringBuffer.append("Font.STYLE_BOLD");
        }
        if (this.styleItalicBtn.getSelection()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("Font.STYLE_ITALIC");
        }
        if (this.styleUnderlineBtn.getSelection()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("Font.STYLE_UNDERLINED");
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("Font.STYLE_PLAIN");
        }
        return stringBuffer.toString();
    }

    private String getFontFace() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.faceSystemBtn.getSelection()) {
            stringBuffer.append("Font.FACE_SYSTEM");
        } else if (this.faceMonospaceBtn.getSelection()) {
            stringBuffer.append("Font.FACE_MONOSPACE");
        } else if (this.faceProportionalBtn.getSelection()) {
            stringBuffer.append("Font.FACE_PROPORTIONAL");
        }
        return stringBuffer.toString();
    }
}

