/**
 * Copyright (c) 2003,2008 Craig Setera and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Craig Setera (EclipseME) - Initial implementation
 *     Diego Sandin (Motorola)  - Refactoring package name to follow eclipse 
 *                                standards
 */
package org.eclipse.mtj.core.model.device;

/**
 * This interface provides a means to communicate a set of devices that are
 * found while searching using the DeviceFactory. Implementors can choose to use
 * these method for update of user interface or other functions as necessary.
 * 
 * @author Craig Setera
 */
public interface IFoundDevicesList {
    
    /**
     * Add the specified devices to the list of found devices.
     * 
     * @param devices
     */
    public void addDevices(IDevice[] devices);

    /**
     * Return all devices added to the list.
     * 
     * @return
     */
    public IDevice[] getDevices();
}
