/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.catalog;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;

class ResourceProvider {
    private final File dir;
    private final Map<String, File> resources = new ConcurrentHashMap<String, File>();

    public ResourceProvider() throws IOException {
        this.dir = File.createTempFile(ResourceProvider.class.getSimpleName(), ".tmp");
        this.dir.delete();
        if (!this.dir.mkdirs()) {
            throw new IOException(this.dir.getAbsolutePath());
        }
    }

    public URL getResource(String resourceName) {
        File resource = this.resources.get(resourceName);
        try {
            return resource == null ? null : resource.toURI().toURL();
        }
        catch (MalformedURLException e) {
            MarketplaceClientUi.error(e);
            return null;
        }
    }

    public boolean containsResource(String resourceName) {
        return this.resources.containsKey(resourceName);
    }

    public void putResource(String resourceName, InputStream input) throws IOException {
        String filenameHint = resourceName;
        if (filenameHint.lastIndexOf(47) != -1) {
            filenameHint = filenameHint.substring(filenameHint.lastIndexOf(47) + 1);
        }
        if ((filenameHint = filenameHint.replaceAll("[^a-zA-Z0-9\\.]", "_")).length() > 32) {
            filenameHint = filenameHint.substring(filenameHint.length() - 32);
        }
        File outputFile = File.createTempFile("res_", filenameHint, this.dir);
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(outputFile));
        try {
            int i;
            input = new BufferedInputStream(input);
            while ((i = input.read()) != -1) {
                output.write(i);
            }
        }
        finally {
            output.close();
        }
        this.resources.put(resourceName, outputFile);
    }

    public void dispose() {
        if (this.dir != null && this.dir.exists()) {
            File[] files = this.dir.listFiles();
            if (files != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    file.delete();
                    ++n2;
                }
            }
            this.dir.delete();
        }
    }
}

