/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: EODMImplPackageImpl.java,v 1.1 2007/03/18 08:10:11 lzhang Exp $
 */
package org.eclipse.eodm.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EPackageImpl;


import org.eclipse.eodm.owl.owlbase.impl.OWLBasePackageImpl;
import org.eclipse.eodm.owl.owlbase.util.OWLBasePackage;
import org.eclipse.eodm.rdf.rdfbase.impl.RDFBasePackageImpl;
import org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage;
import org.eclipse.eodm.rdf.rdfs.impl.RDFSPackageImpl;
import org.eclipse.eodm.rdf.rdfs.util.RDFSPackage;
import org.eclipse.eodm.rdf.rdfweb.impl.RDFWebPackageImpl;
import org.eclipse.eodm.rdf.rdfweb.util.RDFWebPackage;








/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class EODMImplPackageImpl extends EPackageImpl implements EODMImplPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass internalCoreEClass = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.eclipse.eodm.impl.EODMImplPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private EODMImplPackageImpl() {
		super(eNS_URI, EODMImplFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this
	 * model, and for any others upon which it depends.  Simple
	 * dependencies are satisfied by calling this method on all
	 * dependent packages before doing anything else.  This method drives
	 * initialization for interdependent packages directly, in parallel
	 * with this package, itself.
	 * <p>Of this package and its interdependencies, all packages which
	 * have not yet been registered by their URI values are first created
	 * and registered.  The packages are then initialized in two steps:
	 * meta-model objects for all of the packages are created before any
	 * are initialized, since one package's meta-model objects may refer to
	 * those of another.
	 * <p>Invocation of this method will not affect any packages that have
	 * already been initialized.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static EODMImplPackage init() {
		if (isInited) return (EODMImplPackage)EPackage.Registry.INSTANCE.getEPackage(EODMImplPackage.eNS_URI);

		// Obtain or create and register package
		EODMImplPackageImpl theeodm2Package = (EODMImplPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(eNS_URI) instanceof EODMImplPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(eNS_URI) : new EODMImplPackageImpl());

		isInited = true;

		// Obtain or create and register interdependencies
		RDFWebPackageImpl therdfwebPackage = (RDFWebPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(RDFWebPackage.eNS_URI) instanceof RDFWebPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(RDFWebPackage.eNS_URI) : RDFWebPackage.eINSTANCE);
		RDFBasePackageImpl therdfbasePackage = (RDFBasePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(RDFBasePackage.eNS_URI) instanceof RDFBasePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(RDFBasePackage.eNS_URI) : RDFBasePackage.eINSTANCE);
		RDFSPackageImpl therdfsPackage = (RDFSPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(RDFSPackage.eNS_URI) instanceof RDFSPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(RDFSPackage.eNS_URI) : RDFSPackage.eINSTANCE);
		OWLBasePackageImpl theowlbasePackage = (OWLBasePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(OWLBasePackage.eNS_URI) instanceof OWLBasePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(OWLBasePackage.eNS_URI) : OWLBasePackage.eINSTANCE);

		// Create package meta-data objects
		theeodm2Package.createPackageContents();
		therdfwebPackage.createPackageContents();
		therdfbasePackage.createPackageContents();
		therdfsPackage.createPackageContents();
		theowlbasePackage.createPackageContents();

		// Initialize created meta-data
		theeodm2Package.initializePackageContents();
		therdfwebPackage.initializePackageContents();
		therdfbasePackage.initializePackageContents();
		therdfsPackage.initializePackageContents();
		theowlbasePackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theeodm2Package.freeze();

		return theeodm2Package;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getInternalCore() {
		return internalCoreEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EODMImplFactory geteodm2Factory() {
		return (EODMImplFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		internalCoreEClass = createEClass(INTERNAL_CORE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		RDFWebPackageImpl therdfwebPackage = (RDFWebPackageImpl)EPackage.Registry.INSTANCE.getEPackage(RDFWebPackage.eNS_URI);
		RDFBasePackageImpl therdfbasePackage = (RDFBasePackageImpl)EPackage.Registry.INSTANCE.getEPackage(RDFBasePackage.eNS_URI);
		RDFSPackageImpl therdfsPackage = (RDFSPackageImpl)EPackage.Registry.INSTANCE.getEPackage(RDFSPackage.eNS_URI);
		OWLBasePackageImpl theowlbasePackage = (OWLBasePackageImpl)EPackage.Registry.INSTANCE.getEPackage(OWLBasePackage.eNS_URI);

		// Add subpackages
		getESubpackages().add(therdfwebPackage);
		getESubpackages().add(therdfbasePackage);
		getESubpackages().add(therdfsPackage);
		getESubpackages().add(theowlbasePackage);

		// Add supertypes to classes
		internalCoreEClass.getESuperTypes().add(therdfbasePackage.getBlankNode());
//		internalCoreEClass.getESuperTypes().add(therdfbasePackage.getPlainLiteral());
		internalCoreEClass.getESuperTypes().add(theowlbasePackage.getComplementClass());
//		internalCoreEClass.getESuperTypes().add(therdfbasePackage.getRDFXMLLiteral());
		internalCoreEClass.getESuperTypes().add(theowlbasePackage.getOWLAllDifferent());
		internalCoreEClass.getESuperTypes().add(theowlbasePackage.getCardinalityRestriction());
		internalCoreEClass.getESuperTypes().add(theowlbasePackage.getMinCardinalityRestriction());
		internalCoreEClass.getESuperTypes().add(theowlbasePackage.getSomeValuesFromRestriction());
		internalCoreEClass.getESuperTypes().add(theowlbasePackage.getIndividual());
		internalCoreEClass.getESuperTypes().add(therdfsPackage.getRDFAlt());
		internalCoreEClass.getESuperTypes().add(therdfsPackage.getRDFSeq());
		internalCoreEClass.getESuperTypes().add(therdfsPackage.getRDFList());
		internalCoreEClass.getESuperTypes().add(theowlbasePackage.getOWLAnnotationProperty());
		internalCoreEClass.getESuperTypes().add(theowlbasePackage.getOWLDatatypeProperty());
		internalCoreEClass.getESuperTypes().add(theowlbasePackage.getOWLOntology());
		internalCoreEClass.getESuperTypes().add(theowlbasePackage.getOWLGraph());
		internalCoreEClass.getESuperTypes().add(theowlbasePackage.getHasValueRestriction());
		internalCoreEClass.getESuperTypes().add(theowlbasePackage.getAllValuesFromRestriction());
		internalCoreEClass.getESuperTypes().add(theowlbasePackage.getMaxCardinalityRestriction());
		internalCoreEClass.getESuperTypes().add(theowlbasePackage.getIntersectionClass());
		internalCoreEClass.getESuperTypes().add(theowlbasePackage.getEnumeratedClass());
		internalCoreEClass.getESuperTypes().add(theowlbasePackage.getUnionClass());
		internalCoreEClass.getESuperTypes().add(therdfsPackage.getRDFSDatatype());
		internalCoreEClass.getESuperTypes().add(theowlbasePackage.getOWLDataRange());
		internalCoreEClass.getESuperTypes().add(theowlbasePackage.getStatement());
		internalCoreEClass.getESuperTypes().add(therdfsPackage.getRDFBag());
		internalCoreEClass.getESuperTypes().add(therdfbasePackage.getURIReferenceNode());
		internalCoreEClass.getESuperTypes().add(theowlbasePackage.getOWLOntologyProperty());
		internalCoreEClass.getESuperTypes().add(therdfsPackage.getRDFSContainerMembershipProperty());
		internalCoreEClass.getESuperTypes().add(theowlbasePackage.getOWLObjectProperty());
		internalCoreEClass.getESuperTypes().add(therdfwebPackage.getDocument());

		// Initialize classes and features; add operations and parameters
		initEClass(internalCoreEClass, InternalCore.class, "InternalCore", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		// Create resource
		createResource(eNS_URI);
	}

} //EODMImplPackageImpl
