/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.util.bundle;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.net4j.internal.util.bundle.AbstractPlatform;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.internal.util.om.pref.Preferences;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.OMBundle;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.log.Logger;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.net4j.util.om.trace.OMTracer;
import org.eclipse.net4j.util.om.trace.Tracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBundle
implements OMBundle,
OMBundle.DebugSupport,
OMBundle.TranslationSupport {
    private AbstractPlatform platform;
    private String bundleID;
    private Class<?> accessor;
    private Object bundleContext;
    private boolean debugging;
    private boolean debuggingInitialized;
    private Map<String, Tracer> tracers = new ConcurrentHashMap<String, Tracer>(0);
    private OMLogger logger;
    private Preferences preferences;
    private ResourceBundle resourceBundle;
    private ResourceBundle untranslatedResourceBundle;
    private Map<String, String> strings = new HashMap<String, String>(0);
    private Map<String, String> untranslatedStrings = new HashMap<String, String>(0);
    private boolean shouldTranslate = true;

    public AbstractBundle(AbstractPlatform platform, String bundleID, Class<?> accessor) {
        this.platform = platform;
        this.bundleID = bundleID;
        this.accessor = accessor;
    }

    @Override
    public OMPlatform getPlatform() {
        return this.platform;
    }

    @Override
    public String getBundleID() {
        return this.bundleID;
    }

    public Class<?> getAccessor() {
        return this.accessor;
    }

    public Object getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void setBundleContext(Object bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public OMBundle.DebugSupport getDebugSupport() {
        return this;
    }

    @Override
    public OMBundle.TranslationSupport getTranslationSupport() {
        return this;
    }

    @Override
    public boolean isDebugging() {
        if (!this.platform.isDebugging()) {
            return false;
        }
        if (!this.debuggingInitialized) {
            this.debugging = this.getDebugOption("debug", false);
            this.debuggingInitialized = true;
        }
        return this.debugging;
    }

    @Override
    public void setDebugging(boolean debugging) {
        this.debugging = debugging;
    }

    @Override
    public String getDebugOption(String option, String defaultValue) {
        String value = this.getDebugOption(option);
        return value == null ? defaultValue : value;
    }

    @Override
    public boolean getDebugOption(String option, boolean defaultValue) {
        String value = this.getDebugOption(option);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    @Override
    public void setDebugOption(String option, boolean value) {
        this.setDebugOption(option, Boolean.toString(value));
    }

    @Override
    public int getDebugOption(String option, int defaultValue) {
        try {
            String value = this.getDebugOption(option);
            return value == null ? defaultValue : Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    @Override
    public void setDebugOption(String option, int value) {
        this.setDebugOption(option, Integer.toString(value));
    }

    @Override
    public String getDebugOption(String option) {
        return this.platform.getDebugOption(this.bundleID, option);
    }

    @Override
    public void setDebugOption(String option, String value) {
        this.platform.setDebugOption(this.bundleID, option, value);
    }

    @Override
    public synchronized OMTracer tracer(String name) {
        OMTracer tracer = this.tracers.get(name);
        if (tracer == null) {
            tracer = this.createTracer(name);
        }
        return tracer;
    }

    @Override
    public synchronized OMLogger logger() {
        if (this.logger == null) {
            this.logger = this.createLogger();
        }
        return this.logger;
    }

    @Override
    public File getConfigFile() {
        return this.platform.getConfigFile(this.getConfigFileName());
    }

    @Override
    public Properties getConfigProperties() {
        return this.platform.getConfigProperties(this.getConfigFileName());
    }

    @Override
    public synchronized Preferences preferences() {
        if (this.preferences == null) {
            this.preferences = new Preferences(this);
        }
        return this.preferences;
    }

    @Override
    public InputStream getInputStream(String path) throws IOException {
        String base = this.getBaseURL().toString();
        if (!base.endsWith("/")) {
            base = String.valueOf(base) + "/";
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        URL url = new URL(String.valueOf(base) + path);
        return url.openStream();
    }

    @Override
    public boolean shouldTranslate() {
        return this.shouldTranslate;
    }

    @Override
    public void setShouldTranslate(boolean shouldTranslate) {
        this.shouldTranslate = shouldTranslate;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public String getString(String key, boolean translate) {
        stringMap = translate != false ? this.strings : this.untranslatedStrings;
        result = stringMap.get(key);
        if (result == null) {
            v0 = bundle = translate != false ? this.resourceBundle : this.untranslatedResourceBundle;
            if (bundle == null) {
                packageName = ReflectUtil.getPackageName(this.accessor);
                if (translate) {
                    try {
                        bundle = this.resourceBundle = ResourceBundle.getBundle(String.valueOf(packageName) + ".plugin");
                    }
                    catch (MissingResourceException exception) {
                        block15: {
                            inputStream = null;
                            try {
                                try {
                                    inputStream = this.getInputStream("plugin.properties");
                                    this.untranslatedResourceBundle = this.resourceBundle = (bundle = new PropertyResourceBundle(inputStream));
                                    inputStream.close();
                                }
                                catch (IOException v1) {
                                    IOUtil.closeSilent(inputStream);
                                    break block15;
                                }
                            }
                            catch (Throwable var9_11) {
                                IOUtil.closeSilent(inputStream);
                                throw var9_11;
                            }
                            IOUtil.closeSilent(inputStream);
                        }
                        if (this.resourceBundle != null) ** GOTO lbl49
                        throw exception;
                    }
                } else {
                    inputStream = null;
                    try {
                        try {
                            inputStream = this.getInputStream("plugin.properties");
                            bundle = this.untranslatedResourceBundle = new PropertyResourceBundle(inputStream);
                            inputStream.close();
                        }
                        catch (IOException v2) {
                            throw new MissingResourceException("Missing resource: plugin.properties", this.accessor.getName(), key);
                        }
                    }
                    catch (Throwable var8_10) {
                        IOUtil.closeSilent(inputStream);
                        throw var8_10;
                    }
                    IOUtil.closeSilent(inputStream);
                }
            }
lbl49:
            // 5 sources

            result = bundle.getString(key);
            stringMap.put(key, result);
        }
        return result;
    }

    @Override
    public String getString(String key) {
        return this.getString(key, this.shouldTranslate());
    }

    @Override
    public String getString(String key, Object ... args) {
        return this.getString(key, this.shouldTranslate(), args);
    }

    @Override
    public String getString(String key, boolean translate, Object ... args) {
        return MessageFormat.format(this.getString(key, translate), args);
    }

    public String toString() {
        return this.bundleID;
    }

    public void start() throws Exception {
        this.invokeMethod("start");
    }

    public void stop() throws Exception {
        try {
            if (this.preferences != null) {
                this.preferences.save();
            }
        }
        catch (RuntimeException ex) {
            OM.LOG.error(ex);
        }
        this.invokeMethod("stop");
    }

    protected OMTracer createTracer(String name) {
        return new Tracer(this, name);
    }

    protected OMLogger createLogger() {
        return new Logger(this);
    }

    protected String getConfigFileName() {
        return String.valueOf(this.bundleID) + ".properties";
    }

    private void invokeMethod(String name) throws Exception {
        try {
            Method method = this.accessor.getDeclaredMethod(name, ReflectUtil.NO_PARAMETERS);
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            method.invoke(null, ReflectUtil.NO_ARGUMENTS);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException ex) {
            Throwable targetException = ex.getTargetException();
            if (targetException instanceof Exception) {
                throw (Exception)targetException;
            }
            if (targetException instanceof Error) {
                throw (Error)targetException;
            }
            OM.LOG.error(targetException);
        }
    }
}

