/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.server.IStoreChunkReader;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IDBStoreChunkReader;
import org.eclipse.emf.cdo.server.db.IPreparedStatementCache;
import org.eclipse.emf.cdo.server.db.mapping.IListMapping;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDOList;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractListTableMapping
implements IListMapping {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, AbstractListTableMapping.class);
    private EStructuralFeature feature;
    private IDBTable table;
    private ITypeMapping typeMapping;
    private IMappingStrategy mappingStrategy;
    private String sqlSelectChunksPrefix;
    private String sqlOrderByIndex;
    private String sqlInsertEntry;
    private EClass containingClass;
    private String sqlGetListLastIndex;

    public AbstractListTableMapping(IMappingStrategy mappingStrategy, EClass eClass, EStructuralFeature feature) {
        this.mappingStrategy = mappingStrategy;
        this.feature = feature;
        this.containingClass = eClass;
        this.initTable();
        this.initSqlStrings();
    }

    private void initTable() {
        String tableName = this.mappingStrategy.getTableName(this.containingClass, this.feature);
        this.table = this.mappingStrategy.getStore().getDBSchema().addTable(tableName);
        FieldInfo[] fields = this.getKeyFields();
        IDBField[] dbFields = new IDBField[fields.length];
        int i = 0;
        while (i < fields.length) {
            dbFields[i] = this.table.addField(fields[i].getName(), fields[i].getDbType());
            ++i;
        }
        IDBField idxField = this.table.addField("cdo_idx", DBType.INTEGER);
        this.typeMapping = this.mappingStrategy.createValueMapping(this.feature);
        this.typeMapping.createDBField(this.table, "cdo_value");
        this.table.addIndex(IDBIndex.Type.NON_UNIQUE, dbFields);
        this.table.addIndex(IDBIndex.Type.NON_UNIQUE, new IDBField[]{idxField});
    }

    protected abstract FieldInfo[] getKeyFields();

    protected abstract void setKeyFields(PreparedStatement var1, CDORevision var2) throws SQLException;

    @Override
    public Collection<IDBTable> getDBTables() {
        return Arrays.asList(this.table);
    }

    private void initSqlStrings() {
        String tableName = this.getTable().getName();
        FieldInfo[] fields = this.getKeyFields();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append("cdo_value");
        builder.append(" FROM ");
        builder.append(tableName);
        builder.append(" WHERE ");
        int i = 0;
        while (i < fields.length) {
            builder.append(fields[i].getName());
            if (i + 1 < fields.length) {
                builder.append("= ? AND ");
            } else {
                builder.append("= ? ");
            }
            ++i;
        }
        this.sqlSelectChunksPrefix = builder.toString();
        this.sqlOrderByIndex = " ORDER BY cdo_idx";
        builder = new StringBuilder("SELECT max(");
        builder.append("cdo_idx");
        builder.append(") FROM ");
        builder.append(tableName);
        builder.append(" WHERE ");
        i = 0;
        while (i < fields.length) {
            builder.append(fields[i].getName());
            if (i + 1 < fields.length) {
                builder.append("= ? AND ");
            } else {
                builder.append("= ? ");
            }
            ++i;
        }
        this.sqlGetListLastIndex = builder.toString();
        builder = new StringBuilder("INSERT INTO ");
        builder.append(tableName);
        builder.append(" VALUES (");
        i = 0;
        while (i < fields.length) {
            builder.append("?, ");
            ++i;
        }
        builder.append(" ?, ?)");
        this.sqlInsertEntry = builder.toString();
    }

    @Override
    public final EStructuralFeature getFeature() {
        return this.feature;
    }

    public final EClass getContainingClass() {
        return this.containingClass;
    }

    protected final IDBTable getTable() {
        return this.table;
    }

    protected final ITypeMapping getTypeMapping() {
        return this.typeMapping;
    }

    @Override
    public void readValues(IDBStoreAccessor accessor, InternalCDORevision revision, int listChunk) {
        CDOList list = revision.getList(this.getFeature());
        int listSize = -1;
        if (listChunk != -1) {
            listSize = this.getListLastIndex(accessor, revision);
            if (listSize == -1) {
                return;
            }
            listSize -= listChunk;
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Reading list values for feature {0}.{1} of {2}v{3}", new Object[]{this.containingClass.getName(), this.feature.getName(), revision.getID(), revision.getVersion()});
        }
        PreparedStatement pstmt = null;
        ResultSet resultSet = null;
        try {
            try {
                String sql = String.valueOf(this.sqlSelectChunksPrefix) + this.sqlOrderByIndex;
                pstmt = accessor.getStatementCache().getPreparedStatement(sql, IPreparedStatementCache.ReuseProbability.HIGH);
                this.setKeyFields(pstmt, (CDORevision)revision);
                if (listChunk != -1) {
                    pstmt.setMaxRows(listChunk);
                }
                resultSet = pstmt.executeQuery();
                while ((listChunk == -1 || --listChunk >= 0) && resultSet.next()) {
                    Object value = this.typeMapping.readValue(resultSet, 1);
                    if (TRACER.isEnabled()) {
                        TRACER.format("Read value for index {0} from result set: {1}", new Object[]{list.size(), value});
                    }
                    list.add(value);
                }
                while (listSize-- >= 0) {
                    if (TRACER.isEnabled()) {
                        TRACER.format("Adding UNINITIALIZED for index {0} ", new Object[]{list.size()});
                    }
                    list.add(InternalCDOList.UNINITIALIZED);
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            accessor.getStatementCache().releasePreparedStatement(pstmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
        accessor.getStatementCache().releasePreparedStatement(pstmt);
        if (TRACER.isEnabled()) {
            TRACER.format("Reading list values done for feature {0}.{1} of {2}v{3}", new Object[]{this.containingClass.getName(), this.feature.getName(), revision.getID(), revision.getVersion()});
        }
    }

    private int getListLastIndex(IDBStoreAccessor accessor, InternalCDORevision revision) {
        int n;
        ResultSet resultSet;
        PreparedStatement pstmt;
        block6: {
            block7: {
                pstmt = null;
                resultSet = null;
                pstmt = accessor.getStatementCache().getPreparedStatement(this.sqlGetListLastIndex, IPreparedStatementCache.ReuseProbability.HIGH);
                this.setKeyFields(pstmt, (CDORevision)revision);
                resultSet = pstmt.executeQuery();
                if (resultSet.next()) break block6;
                if (!TRACER.isEnabled()) break block7;
                TRACER.trace("No last index found -> list is empty. ");
            }
            DBUtil.close((ResultSet)resultSet);
            accessor.getStatementCache().releasePreparedStatement(pstmt);
            return -1;
        }
        try {
            int result = resultSet.getInt(1);
            if (TRACER.isEnabled()) {
                TRACER.trace("Read list last index = " + result);
            }
            n = result;
        }
        catch (SQLException ex) {
            try {
                throw new DBException((Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                accessor.getStatementCache().releasePreparedStatement(pstmt);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)resultSet);
        accessor.getStatementCache().releasePreparedStatement(pstmt);
        return n;
    }

    @Override
    public final void readChunks(IDBStoreChunkReader chunkReader, List<IStoreChunkReader.Chunk> chunks, String where) {
        if (TRACER.isEnabled()) {
            TRACER.format("Reading list chunk values for feature {0}.{1} of {2}v{3}", new Object[]{this.containingClass.getName(), this.feature.getName(), chunkReader.getRevision().getID(), chunkReader.getRevision().getVersion()});
        }
        PreparedStatement pstmt = null;
        ResultSet resultSet = null;
        try {
            try {
                StringBuilder builder = new StringBuilder(this.sqlSelectChunksPrefix);
                if (where != null) {
                    builder.append(where);
                }
                builder.append(this.sqlOrderByIndex);
                String sql = builder.toString();
                pstmt = chunkReader.getAccessor().getStatementCache().getPreparedStatement(sql, IPreparedStatementCache.ReuseProbability.LOW);
                this.setKeyFields(pstmt, chunkReader.getRevision());
                resultSet = pstmt.executeQuery();
                IStoreChunkReader.Chunk chunk = null;
                int chunkSize = 0;
                int chunkIndex = 0;
                int indexInChunk = 0;
                while (resultSet.next()) {
                    Object value = this.typeMapping.readValue(resultSet, 1);
                    if (chunk == null) {
                        chunk = chunks.get(chunkIndex++);
                        chunkSize = chunk.size();
                        if (TRACER.isEnabled()) {
                            TRACER.format("Current chunk no. {0} is [start = {1}, size = {2}]", new Object[]{chunkIndex - 1, chunk.getStartIndex(), chunkSize});
                        }
                    }
                    if (TRACER.isEnabled()) {
                        TRACER.format("Read value for chunk index {0} from result set: {1}", new Object[]{indexInChunk, value});
                    }
                    chunk.add(indexInChunk++, value);
                    if (indexInChunk != chunkSize) continue;
                    if (TRACER.isEnabled()) {
                        TRACER.format("Chunk finished.", new Object[0]);
                    }
                    chunk = null;
                    indexInChunk = 0;
                }
                if (TRACER.isEnabled()) {
                    TRACER.format("Reading list chunk values done for feature {0}.{1} of {2}v{3}", new Object[]{this.containingClass.getName(), this.feature.getName(), chunkReader.getRevision().getID(), chunkReader.getRevision().getVersion()});
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            chunkReader.getAccessor().getStatementCache().releasePreparedStatement(pstmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
        chunkReader.getAccessor().getStatementCache().releasePreparedStatement(pstmt);
    }

    @Override
    public void writeValues(IDBStoreAccessor accessor, InternalCDORevision revision) {
        CDOList values = revision.getList(this.getFeature());
        int idx = 0;
        for (Object element : values) {
            this.writeValue(accessor, (CDORevision)revision, idx++, element);
        }
    }

    protected final void writeValue(IDBStoreAccessor accessor, CDORevision revision, int idx, Object value) {
        PreparedStatement stmt = null;
        if (TRACER.isEnabled()) {
            TRACER.format("Writing value for feature {0}.{1} index {2} of {3}v{4} : {5}", new Object[]{this.containingClass.getName(), this.feature.getName(), idx, revision.getID(), revision.getVersion(), value});
        }
        try {
            try {
                stmt = accessor.getStatementCache().getPreparedStatement(this.sqlInsertEntry, IPreparedStatementCache.ReuseProbability.HIGH);
                this.setKeyFields(stmt, revision);
                int stmtIndex = this.getKeyFields().length + 1;
                stmt.setInt(stmtIndex++, idx);
                this.typeMapping.setValue(stmt, stmtIndex++, value);
                CDODBUtil.sqlUpdate(stmt, true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            accessor.getStatementCache().releasePreparedStatement(stmt);
            throw throwable;
        }
        accessor.getStatementCache().releasePreparedStatement(stmt);
    }

    protected static class FieldInfo {
        private String name;
        private DBType dbType;

        public FieldInfo(String name, DBType dbType) {
            this.name = name;
            this.dbType = dbType;
        }

        public String getName() {
            return this.name;
        }

        public DBType getDbType() {
            return this.dbType;
        }
    }
}

