/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision.cache.lru;

import java.text.MessageFormat;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.internal.common.messages.Messages;
import org.eclipse.emf.cdo.internal.common.revision.cache.lru.DLRevisionHolder;
import org.eclipse.emf.cdo.internal.common.revision.cache.lru.RevisionHolder;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;

public class DLRevisionList
extends DLRevisionHolder {
    private int size;

    public DLRevisionList() {
        super(null, null);
        this.setDLHead(this);
        this.setDLTail(this);
    }

    public int size() {
        return this.size;
    }

    public DLRevisionHolder getDLHead() {
        return this.getDLNext();
    }

    public void setDLHead(DLRevisionHolder head) {
        this.setDLNext(head);
    }

    public DLRevisionHolder getDLTail() {
        return this.getDLPrev();
    }

    protected void setDLList(DLRevisionList list) {
        if (this.getPrev() != null || this.getDLNext() != null || this.getDLList() != null) {
            throw new IllegalStateException(Messages.getString("DLRevisionList.0"));
        }
        super.setDLList(list);
    }

    public void setDLTail(DLRevisionHolder tail) {
        this.setDLPrev(tail);
    }

    public DLRevisionHolder get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        DLRevisionHolder holder = this;
        if (index < this.size >> 1) {
            int i = 0;
            while (i <= index) {
                holder = holder.getDLNext();
                ++i;
            }
        } else {
            int i = this.size;
            while (i > index) {
                holder = holder.getDLPrev();
                --i;
            }
        }
        return holder;
    }

    public void add(DLRevisionHolder holder) {
        this.addTail(holder);
    }

    protected void validateUnlink(DLRevisionHolder holder) {
        if (holder.getDLList() != null) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("DLRevisionList.3"), holder));
        }
    }

    protected void validateLink(DLRevisionHolder holder) {
        if (holder.getDLList() != this) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("DLRevisionList.5"), holder));
        }
    }

    public void addHead(DLRevisionHolder holder) {
        this.validateUnlink(holder);
        ++this.size;
        DLRevisionHolder head = this.getDLHead();
        head.setDLPrev(holder);
        holder.setDLNext(head);
        holder.setDLPrev(this);
        holder.setDLList(this);
        this.setDLHead(holder);
    }

    public void addTail(DLRevisionHolder holder) {
        this.validateUnlink(holder);
        ++this.size;
        DLRevisionHolder tail = this.getDLTail();
        tail.setDLNext(holder);
        holder.setDLPrev(tail);
        holder.setDLNext(this);
        holder.setDLList(this);
        this.setDLTail(holder);
    }

    public void remove(DLRevisionHolder holder) {
        this.validateLink(holder);
        --this.size;
        DLRevisionHolder prev = holder.getDLPrev();
        DLRevisionHolder next = holder.getDLNext();
        prev.setDLNext(next);
        holder.setDLPrev(null);
        holder.setDLNext(null);
        holder.setDLList(null);
        next.setDLPrev(prev);
    }

    public String toString() {
        return MessageFormat.format("DLRevisionList[size={0}]", this.size);
    }

    public int compareTo(long timeStamp) {
        throw new UnsupportedOperationException();
    }

    public long getCreated() {
        throw new UnsupportedOperationException();
    }

    public DLRevisionList getDLList() {
        throw new UnsupportedOperationException();
    }

    public CDOID getID() {
        throw new UnsupportedOperationException();
    }

    public RevisionHolder getNext() {
        throw new UnsupportedOperationException();
    }

    public RevisionHolder getPrev() {
        throw new UnsupportedOperationException();
    }

    public long getRevised() {
        throw new UnsupportedOperationException();
    }

    public int getVersion() {
        throw new UnsupportedOperationException();
    }

    public boolean isCurrent() {
        throw new UnsupportedOperationException();
    }

    public boolean isLoaded() {
        throw new UnsupportedOperationException();
    }

    public boolean isValid(long timeStamp) {
        throw new UnsupportedOperationException();
    }

    public void setNext(RevisionHolder next) {
        throw new UnsupportedOperationException();
    }

    public void setPrev(RevisionHolder prev) {
        throw new UnsupportedOperationException();
    }

    public InternalCDORevision getRevision() {
        throw new UnsupportedOperationException();
    }

    public void setRevision(InternalCDORevision revision) {
    }
}

