/*
 * Decompiled with CFR 0.152.
 */
package hbtutorial;

import hbtutorial.QuickStart;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.teneo.hibernate.HbDataStore;
import org.eclipse.example.library.Book;
import org.eclipse.example.library.BookCategory;
import org.eclipse.example.library.LibraryFactory;
import org.eclipse.example.library.LibraryPackage;
import org.eclipse.example.library.Writer;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;

public class Dynamic {
    public static void main(String[] args) {
        HbDataStore hbds = QuickStart.doQuickStart("DynamicLibrary");
        System.err.println(hbds.getMappingXML());
        EcoreFactory efactory = EcoreFactory.eINSTANCE;
        EcorePackage epackage = EcorePackage.eINSTANCE;
        EClass schoolBookEClass = efactory.createEClass();
        schoolBookEClass.setName("SchoolBook");
        EAttribute level = efactory.createEAttribute();
        level.setName("level");
        level.setEType((EClassifier)epackage.getEInt());
        schoolBookEClass.getEStructuralFeatures().add((Object)level);
        schoolBookEClass.getESuperTypes().add((Object)LibraryPackage.eINSTANCE.getBook());
        EClass courseEClass = efactory.createEClass();
        courseEClass.setName("Course");
        EAttribute courseName = efactory.createEAttribute();
        courseName.setName("courseName");
        courseName.setEType((EClassifier)epackage.getEString());
        courseEClass.getEStructuralFeatures().add((Object)courseName);
        EReference courseBook = efactory.createEReference();
        courseBook.setName("courseBook");
        courseBook.setEType((EClassifier)schoolBookEClass);
        courseBook.setContainment(false);
        courseEClass.getEStructuralFeatures().add((Object)courseBook);
        EPackage schoolPackage = efactory.createEPackage();
        schoolPackage.setName("elv");
        schoolPackage.setNsPrefix("elv");
        schoolPackage.setNsURI("http:///www.elver.org/School");
        schoolPackage.getEClassifiers().add((Object)courseEClass);
        schoolPackage.getEClassifiers().add((Object)schoolBookEClass);
        EPackage.Registry.INSTANCE.put((Object)schoolPackage.getNsURI(), (Object)schoolPackage);
        hbds.setEPackages(new EPackage[]{LibraryPackage.eINSTANCE, schoolPackage});
        hbds.initialize();
        System.err.println(hbds.getMappingXML());
        Writer writer = LibraryFactory.eINSTANCE.createWriter();
        writer.setName("Teacher");
        Book bk = (Book)schoolPackage.getEFactoryInstance().create(schoolBookEClass);
        bk.setAuthor(writer);
        bk.setTitle("Biografie van Multatuli");
        bk.setCategory(BookCategory.BIOGRAPHY);
        bk.setPages(500);
        bk.eSet((EStructuralFeature)level, (Object)new Integer(1));
        EObject course = schoolPackage.getEFactoryInstance().create(courseEClass);
        course.eSet((EStructuralFeature)courseName, (Object)"Dutch Literature Level 1");
        course.eSet((EStructuralFeature)courseBook, (Object)bk);
        SessionFactory sessionFactory = hbds.getSessionFactory();
        Session session = sessionFactory.openSession();
        Transaction tx = session.getTransaction();
        tx.begin();
        session.save((Object)bk);
        session.save((Object)writer);
        session.save((Object)course);
        tx.commit();
        tx.begin();
        Query qry = session.createQuery("from Book");
        List list = qry.list();
        Book schoolBook = null;
        for (Book book : list) {
            if (book.eClass() != schoolBookEClass) continue;
            if (schoolBook != null) {
                throw new Error("More than one schoolbook? Was the database not empty?");
            }
            schoolBook = book;
        }
        if (schoolBook == null) {
            throw new Error("No schoolbook??");
        }
        qry = session.createQuery("from Course where courseName='Dutch Literature Level 1'");
        list = qry.list();
        EObject eobject = (EObject)list.get(0);
        if (eobject.eClass() != courseEClass) {
            throw new Error("No Course?");
        }
        Book courseBk = (Book)eobject.eGet((EStructuralFeature)courseBook);
        if (courseBk != schoolBook) {
            throw new Error("No schoolbook?");
        }
        if ((Integer)courseBk.eGet((EStructuralFeature)level) != 1) {
            throw new Error("Incorrect level?");
        }
        tx.commit();
        session.close();
        URI uri1 = URI.createURI((String)"hibernate://?dsname=Library&query1=FROM Course");
        Resource res1 = new ResourceSetImpl().createResource(uri1);
        try {
            res1.load(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        eobject = (EObject)res1.getContents().get(0);
        ChangeRecorder cr = new ChangeRecorder(res1);
        eobject.eSet((EStructuralFeature)courseName, (Object)"English 1");
        System.out.println(eobject);
        ChangeDescription changeDescription = cr.endRecording();
        EMap objectChanges = changeDescription.getObjectChanges();
        System.out.println("change size: " + objectChanges.size());
        course.eSet((EStructuralFeature)courseName, (Object)"Dutch Literature Level 1");
    }
}

