/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.common.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Property;

public class SubclassEditorTreeViewer
extends CheckboxTreeViewer {
    private Class currentSelection;
    private boolean modifyMode = false;
    private boolean doneInitialSelections = false;
    private Property initProperty = null;

    public SubclassEditorTreeViewer(Composite parent) {
        super(parent);
        this.initViewer();
    }

    public SubclassEditorTreeViewer(Composite parent, int style) {
        super(parent, style);
        this.initViewer();
    }

    public SubclassEditorTreeViewer(Tree tree) {
        super(tree);
        this.initViewer();
    }

    private void initViewer() {
        this.setUseHashlookup(true);
        this.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                SubclassEditorTreeViewer.this.doCheckStateChanged(event.getElement());
            }
        });
        this.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                Widget item = SubclassEditorTreeViewer.this.findItem(event.getElement());
                if (item instanceof TreeItem) {
                    SubclassEditorTreeViewer.this.initializeItem((TreeItem)item);
                }
            }
        });
    }

    protected void doCheckStateChanged(Object element) {
        TreeItem treeItem;
        Widget item = null;
        if (this.isModifyMode() && !this.isDoneInitialSelections()) {
            this.initProperty = (Property)element;
            this.doInitSelection((Item[])this.getTree().getItems());
        } else {
            item = this.findItem(element);
        }
        if (item instanceof TreeItem && !this.hasItemSelected(treeItem = (TreeItem)item)) {
            treeItem.setGrayed(false);
            this.updateChildrenItems(treeItem);
            this.updateParentItems(treeItem.getParentItem());
        }
        this.recordCheckedClass(this.getTree().getItems());
    }

    private void doInitSelection(Item[] treeItems) {
        int i = 0;
        while (i < treeItems.length) {
            TreeItem item = (TreeItem)treeItems[i];
            if (item.getData() instanceof Property) {
                Property itemProperty = (Property)item.getData();
                if (itemProperty.getName().equals(this.initProperty.getName())) {
                    item.setChecked(true);
                    item.setGrayed(false);
                    if (!this.hasItemSelected(item)) {
                        item.setGrayed(false);
                        this.updateChildrenItems(item);
                        this.updateParentItems(item.getParentItem());
                        return;
                    }
                }
            } else if (item.getData() instanceof Class) {
                this.createChildren((Widget)item);
                this.doInitSelection(this.getChildren((Widget)item));
            }
            ++i;
        }
    }

    private void initializeItem(TreeItem item) {
        if (item.getChecked() && !item.getGrayed()) {
            this.updateChildrenItems(item);
        }
    }

    private void updateChildrenItems(TreeItem parent) {
        Item[] children = this.getChildren((Widget)parent);
        boolean state = parent.getChecked();
        int i = 0;
        while (i < children.length) {
            TreeItem child = (TreeItem)children[i];
            if (child.getData() != null && (child.getChecked() != state || child.getGrayed())) {
                if (child.getData() instanceof Property) {
                    child.setChecked(state);
                    child.setGrayed(false);
                } else if (child.getData() instanceof Class) {
                    child.setGrayed(true);
                }
                this.updateChildrenItems(child);
            }
            ++i;
        }
    }

    private void updateParentItems(TreeItem item) {
        if (item != null) {
            Item[] children = this.getChildren((Widget)item);
            boolean containsChecked = false;
            boolean containsUnchecked = false;
            int i = 0;
            while (i < children.length) {
                TreeItem curr = (TreeItem)children[i];
                containsChecked |= curr.getChecked();
                containsUnchecked |= !curr.getChecked() || curr.getGrayed();
                ++i;
            }
            item.setChecked(containsChecked);
            item.setGrayed(containsChecked && containsUnchecked);
            this.updateParentItems(item.getParentItem());
        }
    }

    public boolean setChecked(Object element, boolean state) {
        if (super.setChecked(element, state)) {
            this.doCheckStateChanged(element);
            return true;
        }
        return false;
    }

    public void setCheckedElements(Object[] elements) {
        super.setCheckedElements(elements);
        int i = 0;
        while (i < elements.length) {
            this.doCheckStateChanged(elements[i]);
            ++i;
        }
        if (this.isModifyMode()) {
            this.disableNodesForModify(this.getTree().getItems());
        }
    }

    private void disableNodesForModify(TreeItem[] treeItems) {
        TreeItem item = null;
        int i = 0;
        while (i < treeItems.length) {
            item = treeItems[i];
            if (item.getData() instanceof Property) {
                if (!item.getChecked()) {
                    item.setGrayed(true);
                }
            } else if (item.getData() instanceof Class) {
                item.setGrayed(true);
                this.createChildren((Widget)item);
                this.disableNodesForModify(item.getItems());
            }
            ++i;
        }
    }

    protected void setExpanded(Item item, boolean expand) {
        super.setExpanded(item, expand);
        if (expand && item instanceof TreeItem) {
            this.initializeItem((TreeItem)item);
        }
    }

    public Object[] getCheckedElements() {
        Object[] checked = super.getCheckedElements();
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < checked.length) {
            Item[] children;
            Object curr = checked[i];
            result.add(curr);
            Widget item = this.findItem(curr);
            if (item != null && (children = this.getChildren(item)).length == 1 && children[0].getData() == null) {
                this.collectChildren(curr, result);
            }
            ++i;
        }
        return result.toArray();
    }

    private void collectChildren(Object element, ArrayList result) {
        Object[] filteredChildren = this.getFilteredChildren(element);
        int i = 0;
        while (i < filteredChildren.length) {
            Object curr = filteredChildren[i];
            result.add(curr);
            this.collectChildren(curr, result);
            ++i;
        }
    }

    protected void handleTreeExpand(TreeEvent event) {
        this.createChildren(event.item);
        if (event.item.getData() != null) {
            this.fireTreeExpanded(new TreeExpansionEvent((AbstractTreeViewer)this, event.item.getData()));
        }
    }

    private boolean hasItemSelected(TreeItem inputItem) {
        boolean isChecked = false;
        if (inputItem != null && inputItem.getChecked()) {
            if (inputItem.getData() instanceof Class) {
                isChecked = this.handleClassSelection(inputItem);
            } else if (inputItem.getData() instanceof Property) {
                isChecked = this.handlePropertySelection(inputItem);
            }
        }
        return isChecked;
    }

    private boolean handleClassSelection(TreeItem inputItem) {
        boolean hasSelection = false;
        Object[] checkedArray = super.getCheckedElements();
        TreeItem parent = inputItem.getParentItem();
        if (parent != null) {
            TreeItem[] treeChildren = parent.getItems();
            TreeItem child = null;
            int i = 0;
            while (i < treeChildren.length) {
                child = treeChildren[i];
                if (child.getData() instanceof Class && child.getChecked() && !child.equals(inputItem)) {
                    hasSelection = true;
                    inputItem.setChecked(false);
                    inputItem.setGrayed(true);
                } else {
                    ArrayList<Object> treeList = new ArrayList<Object>();
                    treeList.add(parent.getData());
                    int j = 0;
                    while (j < treeChildren.length) {
                        if (treeChildren[j].getData() instanceof Class) {
                            treeList.add(treeChildren[j].getData());
                        }
                        ++j;
                    }
                    int k = 0;
                    while (k < checkedArray.length) {
                        if (checkedArray[k] instanceof Class && !treeList.contains(checkedArray[k])) {
                            hasSelection = true;
                            inputItem.setChecked(false);
                            inputItem.setGrayed(true);
                            break;
                        }
                        ++k;
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < checkedArray.length) {
                if (checkedArray[i] instanceof Class && !inputItem.getData().equals(checkedArray[i])) {
                    hasSelection = true;
                    inputItem.setChecked(false);
                    inputItem.setGrayed(true);
                    break;
                }
                ++i;
            }
        }
        return hasSelection;
    }

    private boolean handlePropertySelection(TreeItem inputItem) {
        boolean hasSelection = false;
        Object[] checkedArray = super.getCheckedElements();
        Class aCheckedClass = null;
        TreeItem parent = inputItem.getParentItem();
        if (parent != null) {
            TreeItem[] allItemsInTree = null;
            if (parent.getParentItem() != null) {
                allItemsInTree = parent.getParentItem().getItems();
                int i = 0;
                while (i < allItemsInTree.length) {
                    if (allItemsInTree[i].getData() instanceof Class && allItemsInTree[i].getChecked() && !parent.equals(allItemsInTree[i])) {
                        hasSelection = true;
                        inputItem.setChecked(false);
                        inputItem.setGrayed(true);
                    }
                    ++i;
                }
            } else {
                List propertyList = null;
                int i = 0;
                while (i < checkedArray.length) {
                    if (checkedArray[i] instanceof Class) {
                        aCheckedClass = (Class)checkedArray[i];
                        if (propertyList == null || propertyList.size() <= 0) {
                            propertyList = aCheckedClass.getOwnedAttributes();
                        } else {
                            propertyList.addAll(propertyList.size(), aCheckedClass.getOwnedAttributes());
                        }
                    }
                    ++i;
                }
                if (propertyList != null && !propertyList.isEmpty() && !propertyList.contains(inputItem.getData())) {
                    hasSelection = true;
                    inputItem.setChecked(false);
                    inputItem.setGrayed(true);
                }
            }
        }
        return hasSelection;
    }

    public Class getSelectedClass() {
        return this.currentSelection;
    }

    private void recordCheckedClass(TreeItem[] treeItems) {
        int j = 0;
        while (j < treeItems.length) {
            TreeItem item = treeItems[j];
            if (item.getData() instanceof Class && item.getChecked()) {
                this.currentSelection = (Class)item.getData();
                this.recordCheckedClass(item.getItems());
            }
            ++j;
        }
    }

    private boolean isDoneInitialSelections() {
        return this.doneInitialSelections;
    }

    protected void setDoneInitialSelections(boolean doneInitialSelections) {
        this.doneInitialSelections = doneInitialSelections;
    }

    protected boolean isModifyMode() {
        return this.modifyMode;
    }

    protected void setModifyMode(boolean modifyMode) {
        this.modifyMode = modifyMode;
    }
}

