/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.ui.navigator.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.action.ControlAction;
import org.eclipse.emf.edit.ui.action.CopyAction;
import org.eclipse.emf.edit.ui.action.CutAction;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.emf.edit.ui.action.PasteAction;
import org.eclipse.emf.edit.ui.action.RedoAction;
import org.eclipse.emf.edit.ui.action.UndoAction;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.emf.validation.service.ValidationEvent;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.emf.workspace.CompositeEMFOperation;
import org.eclipse.emf.workspace.EMFCommandOperation;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.emf.workspace.ResourceUndoContext;
import org.eclipse.emf.workspace.ui.actions.RedoActionWrapper;
import org.eclipse.emf.workspace.ui.actions.UndoActionWrapper;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mdht.uml.common.ui.saveable.ModelDocument;
import org.eclipse.mdht.uml.common.ui.saveable.ModelManager;
import org.eclipse.mdht.uml.common.ui.util.Selections;
import org.eclipse.mdht.uml.common.util.NamedElementUtil;
import org.eclipse.mdht.uml.common.util.UMLUtil;
import org.eclipse.mdht.uml.ui.navigator.UMLDomainNavigatorItem;
import org.eclipse.mdht.uml.ui.navigator.actions.DeleteUMLAction;
import org.eclipse.mdht.uml.ui.navigator.actions.SelectOriginalAction;
import org.eclipse.mdht.uml.ui.navigator.internal.l10n.Messages;
import org.eclipse.mdht.uml.ui.navigator.internal.plugin.Activator;
import org.eclipse.mdht.uml.ui.navigator.internal.plugin.Logger;
import org.eclipse.mdht.uml.validation.util.UMLDiagnostician;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Relationship;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class EditCommandsFactory
implements IPropertyListener {
    protected IWorkbenchPart activePart;
    protected DeleteUMLAction deleteAction;
    protected CutAction cutAction;
    protected CopyAction copyAction;
    protected PasteAction pasteAction;
    protected UndoAction undoAction;
    protected RedoAction redoAction;
    protected LoadResourceAction loadResourceAction;
    protected MyValidateAction validateAction;
    protected MyControlAction controlAction;
    protected SelectOriginalAction selectOriginalAction;

    public EditCommandsFactory() {
        this.init();
    }

    protected void init() {
        TransactionalEditingDomain editingDomain = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain("org.eclipse.mdht.uml.common.ui.EditingDomain");
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.deleteAction = new DeleteUMLAction((EditingDomain)editingDomain){

            public boolean updateSelection(IStructuredSelection selection) {
                return super.updateSelection(EditCommandsFactory.this.unwrap(selection));
            }
        };
        this.deleteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.cutAction = new CutAction((EditingDomain)editingDomain){

            public boolean updateSelection(IStructuredSelection selection) {
                return super.updateSelection(EditCommandsFactory.this.unwrap(selection));
            }
        };
        this.cutAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT"));
        this.copyAction = new CopyAction((EditingDomain)editingDomain){

            public boolean updateSelection(IStructuredSelection selection) {
                return super.updateSelection(EditCommandsFactory.this.unwrap(selection));
            }
        };
        this.copyAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.pasteAction = new PasteAction((EditingDomain)editingDomain){

            public boolean updateSelection(IStructuredSelection selection) {
                return super.updateSelection(EditCommandsFactory.this.unwrap(selection));
            }
        };
        this.pasteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.undoAction = new UndoActionWrapper();
        this.undoAction.setEditingDomain((EditingDomain)editingDomain);
        this.undoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
        this.redoAction = new RedoActionWrapper();
        this.redoAction.setEditingDomain((EditingDomain)editingDomain);
        this.redoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO"));
        this.validateAction = new MyValidateAction(this, (EditingDomain)editingDomain){

            public boolean updateSelection(IStructuredSelection selection) {
                return super.updateSelection(this.unwrap(selection));
            }
        };
        this.validateAction.setImageDescriptor(Activator.findImageDescriptor("icons/validate.gif"));
        this.controlAction = new MyControlAction(this, (EditingDomain)editingDomain){

            @Override
            public boolean updateSelection(IStructuredSelection selection) {
                return super.updateSelection(this.unwrap(selection));
            }
        };
        this.selectOriginalAction = new SelectOriginalAction();
    }

    private IStructuredSelection unwrap(IStructuredSelection selection) {
        ArrayList unwrapped = new ArrayList();
        for (Object item : selection) {
            if (item instanceof IAdaptable) {
                item = ((IAdaptable)item).getAdapter(EObject.class);
            }
            unwrapped.add(item);
        }
        return new StructuredSelection(unwrapped);
    }

    protected boolean removeAllReferencesOnDelete() {
        return true;
    }

    public void dispose() {
        this.deactivate();
    }

    public void shareGlobalActions(IActionBars actionBars, boolean isPropertyPage) {
        if (!isPropertyPage) {
            actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
            actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.cutAction);
            actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
            actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
        }
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        if (this.cutAction.isEnabled()) {
            menu.appendToGroup("group.edit", (IAction)this.cutAction);
        }
        if (this.copyAction.isEnabled()) {
            menu.appendToGroup("group.edit", (IAction)this.copyAction);
        }
        if (this.pasteAction.isEnabled()) {
            menu.appendToGroup("group.edit", (IAction)this.pasteAction);
        }
        if (this.deleteAction.isEnabled()) {
            menu.appendToGroup("group.edit", (IAction)this.deleteAction);
        }
        if (this.selectOriginalAction.isEnabled()) {
            menu.appendToGroup("group.edit", (IAction)this.selectOriginalAction);
        }
        if (this.validateAction.isEnabled()) {
            menu.appendToGroup("group.build", (IAction)this.validateAction);
        }
        if (this.controlAction.isEnabled()) {
            menu.appendToGroup("group.build", (IAction)this.controlAction);
        }
    }

    public IWorkbenchPart getActivePart() {
        return this.activePart;
    }

    public void setActivePart(IWorkbenchPart part) {
        if (part != this.activePart) {
            if (this.activePart != null) {
                this.deactivate();
                this.activePart = null;
            }
            this.activePart = part;
            if (this.activePart != null) {
                this.activate();
            }
        }
    }

    public void deactivate() {
        ISelectionProvider selectionProvider;
        this.activePart.removePropertyListener((IPropertyListener)this);
        this.deleteAction.setActiveWorkbenchPart(null);
        this.cutAction.setActiveWorkbenchPart(null);
        this.copyAction.setActiveWorkbenchPart(null);
        this.pasteAction.setActiveWorkbenchPart(null);
        this.undoAction.setActiveWorkbenchPart(null);
        this.redoAction.setActiveWorkbenchPart(null);
        if (this.loadResourceAction != null) {
            this.loadResourceAction.setActiveWorkbenchPart(null);
        }
        if (this.validateAction != null) {
            this.validateAction.setActiveWorkbenchPart(null);
        }
        if (this.controlAction != null) {
            this.controlAction.setActiveWorkbenchPart(null);
        }
        if (this.selectOriginalAction != null) {
            this.selectOriginalAction.setActiveWorkbenchPart(null);
        }
        ISelectionProvider iSelectionProvider = selectionProvider = this.activePart instanceof ISelectionProvider ? (ISelectionProvider)this.activePart : this.activePart.getSite().getSelectionProvider();
        if (selectionProvider != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.deleteAction);
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.cutAction);
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.copyAction);
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.pasteAction);
            if (this.validateAction != null) {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.validateAction);
            }
            if (this.controlAction != null) {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.controlAction);
            }
            if (this.selectOriginalAction != null) {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.selectOriginalAction);
            }
        }
    }

    public void activate() {
        ISelectionProvider selectionProvider;
        this.activePart.addPropertyListener((IPropertyListener)this);
        this.deleteAction.setActiveWorkbenchPart(this.activePart);
        this.cutAction.setActiveWorkbenchPart(this.activePart);
        this.copyAction.setActiveWorkbenchPart(this.activePart);
        this.pasteAction.setActiveWorkbenchPart(this.activePart);
        this.undoAction.setActiveWorkbenchPart(this.activePart);
        this.redoAction.setActiveWorkbenchPart(this.activePart);
        if (this.loadResourceAction != null) {
            this.loadResourceAction.setActiveWorkbenchPart(this.activePart);
        }
        if (this.validateAction != null) {
            this.validateAction.setActiveWorkbenchPart(this.activePart);
        }
        if (this.controlAction != null) {
            this.controlAction.setActiveWorkbenchPart(this.activePart);
        }
        if (this.selectOriginalAction != null) {
            this.selectOriginalAction.setActiveWorkbenchPart(this.activePart);
        }
        ISelectionProvider iSelectionProvider = selectionProvider = this.activePart instanceof ISelectionProvider ? (ISelectionProvider)this.activePart : this.activePart.getSite().getSelectionProvider();
        if (selectionProvider != null) {
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.deleteAction);
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.cutAction);
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.copyAction);
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.pasteAction);
            if (this.validateAction != null) {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.validateAction);
            }
            if (this.controlAction != null) {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.controlAction);
            }
            if (this.selectOriginalAction != null) {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.selectOriginalAction);
            }
        }
        this.update();
    }

    public void update() {
        ISelectionProvider selectionProvider = this.activePart instanceof ISelectionProvider ? (ISelectionProvider)this.activePart : this.activePart.getSite().getSelectionProvider();
        TransactionalEditingDomain editingDomain = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain("org.eclipse.mdht.uml.common.ui.EditingDomain");
        if (selectionProvider != null && editingDomain != null) {
            ISelection selection = selectionProvider.getSelection();
            StructuredSelection structuredSelection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : StructuredSelection.EMPTY;
            this.deleteAction.updateSelection((IStructuredSelection)structuredSelection);
            this.cutAction.updateSelection((IStructuredSelection)structuredSelection);
            this.copyAction.updateSelection((IStructuredSelection)structuredSelection);
            this.pasteAction.updateSelection((IStructuredSelection)structuredSelection);
            if (this.validateAction != null) {
                this.validateAction.updateSelection((IStructuredSelection)structuredSelection);
            }
            if (this.controlAction != null) {
                this.controlAction.updateSelection((IStructuredSelection)structuredSelection);
            }
            if (this.selectOriginalAction != null) {
                this.selectOriginalAction.updateSelection((IStructuredSelection)structuredSelection);
            }
        }
        this.undoAction.update();
        this.redoAction.update();
        if (this.loadResourceAction != null) {
            this.loadResourceAction.update();
        }
    }

    public void propertyChanged(Object source, int id) {
        this.update();
    }

    private class MyControlAction
    extends ControlAction {
        public MyControlAction(EditingDomain domain) {
            super(domain);
        }

        protected Resource getResource() {
            Shell shell = EditCommandsFactory.this.activePart.getSite().getShell();
            boolean existing = MessageDialog.openQuestion((Shell)shell, (String)Messages.ExistingControlledResource_dialogTitle, (String)Messages.ExistingControlledResource_dialogMessage);
            if (existing) {
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new LabelProvider(){

                    public String getText(Object element) {
                        return ((Resource)element).getURI().lastSegment();
                    }
                });
                dialog.setMessage(Messages.SelectControlledResource_dialogMessage);
                dialog.setFilter("*");
                dialog.setTitle(Messages.SelectControlledResource_dialogTitle);
                dialog.setElements(UMLUtil.getControlledResources((Resource)this.eObject.eResource()).toArray());
                return dialog.open() == 0 ? (Resource)dialog.getFirstResult() : null;
            }
            return super.getResource();
        }

        public boolean updateSelection(IStructuredSelection selection) {
            boolean result = false;
            if (!Selections.includesWrappers((IStructuredSelection)selection)) {
                result = super.updateSelection(selection) && this.eObject instanceof Element && !(this.eObject instanceof Association) && !(this.eObject.eContainer() instanceof Classifier);
            }
            return result;
        }

        public void run() {
            try {
                TransactionalEditingDomain ted = (TransactionalEditingDomain)this.domain;
                EcoreUtil.resolveAll((ResourceSet)ted.getResourceSet());
                CompositeEMFOperation operation = null;
                if (this.command == null) {
                    Resource resource = this.getResource();
                    if (resource == null) {
                        return;
                    }
                    operation = new CompositeEMFOperation(ted, Messages.ControlAction_label);
                    operation.addContext((IUndoContext)new ResourceUndoContext(ted, resource));
                    Resource eResource = this.eObject.eResource();
                    operation.addContext((IUndoContext)new ResourceUndoContext(ted, eResource));
                    final ArrayList<Object> controlledElements = new ArrayList<Object>();
                    EList resourceContents = resource.getContents();
                    operation.add((IUndoableOperation)new EMFCommandOperation(ted, (Command)new AddCommand((EditingDomain)ted, resourceContents, (Object)this.eObject)));
                    controlledElements.add((Element)this.eObject);
                    ModelDocument targetDocument = ModelManager.getManager().manage(resource);
                    if (targetDocument != null) {
                        targetDocument.setDirty(true);
                    }
                    if (this.eObject instanceof Class) {
                        for (Property ownedAttribute : ((Class)this.eObject).getOwnedAttributes()) {
                            Association association = ownedAttribute.getAssociation();
                            if (association == null) continue;
                            operation.add((IUndoableOperation)new EMFCommandOperation(ted, (Command)new AddCommand((EditingDomain)ted, resourceContents, (Object)association)));
                            controlledElements.add(association);
                        }
                    }
                    EList otherTargets = ((Element)this.eObject).getRelationships(UMLPackage.Literals.ASSOCIATION);
                    for (Relationship relationship : otherTargets) {
                        for (Element element : relationship.getRelatedElements()) {
                            ModelDocument sourceDocument;
                            if (element.eResource() == null || (sourceDocument = ModelManager.getManager().manage(element.eResource())) == null) continue;
                            sourceDocument.setDirty(true);
                        }
                    }
                    for (Element element : controlledElements) {
                        ModelDocument sourceDocument;
                        if (element.eResource() != null && (sourceDocument = ModelManager.getManager().manage(element.eResource())) != null) {
                            sourceDocument.setDirty(true);
                        }
                        for (EObject stereotypeApplication : element.getStereotypeApplications()) {
                            operation.add((IUndoableOperation)new EMFCommandOperation(ted, (Command)new AddCommand((EditingDomain)ted, resourceContents, (Object)stereotypeApplication)));
                        }
                        TreeIterator allProperContents = EcoreUtil.getAllProperContents((EObject)element, (boolean)true);
                        while (allProperContents.hasNext()) {
                            EObject content = (EObject)allProperContents.next();
                            if (!(content instanceof Element)) continue;
                            for (EObject stereotypeApplication : ((Element)content).getStereotypeApplications()) {
                                operation.add((IUndoableOperation)new EMFCommandOperation(ted, (Command)new AddCommand((EditingDomain)ted, resourceContents, (Object)stereotypeApplication)));
                            }
                        }
                    }
                    final URI uRI = UMLUtil.getPropertiesURI((Resource)eResource);
                    final String string = UMLUtil.readProperties((URI)uRI);
                    if (string != null) {
                        final URI resourcePropertiesURI = UMLUtil.getPropertiesURI((Resource)resource);
                        final String resourceProperties = UMLUtil.readProperties((URI)resourcePropertiesURI);
                        operation.add((IUndoableOperation)new AbstractEMFOperation(ted, ""){

                            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                                Map eResourceParsedProperties = UMLUtil.parseProperties((String)string);
                                Map<String, String> resourceParsedProperties = resourceProperties != null ? UMLUtil.parseProperties((String)resourceProperties) : new LinkedHashMap();
                                TreeIterator allProperContents = EcoreUtil.getAllProperContents((Collection)controlledElements, (boolean)true);
                                while (allProperContents.hasNext()) {
                                    String propertyKey;
                                    String property;
                                    EObject next = (EObject)allProperContents.next();
                                    if (!(next instanceof NamedElement) || (property = (String)eResourceParsedProperties.remove(propertyKey = NamedElementUtil.getLabelPropertyKey((NamedElement)((NamedElement)next)))) == null) continue;
                                    resourceParsedProperties.put(propertyKey, property);
                                }
                                UMLUtil.writeProperties((URI)uRI, (Map)eResourceParsedProperties);
                                if (!resourceParsedProperties.isEmpty()) {
                                    UMLUtil.writeProperties((URI)resourcePropertiesURI, resourceParsedProperties);
                                }
                                return Status.OK_STATUS;
                            }

                            protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                                UMLUtil.writeProperties((URI)uRI, (Map)UMLUtil.parseProperties((String)string));
                                URIConverter uriConverter = this.getEditingDomain().getResourceSet().getURIConverter();
                                if (uriConverter.exists(resourcePropertiesURI, null)) {
                                    if (resourceProperties == null) {
                                        try {
                                            uriConverter.delete(resourcePropertiesURI, null);
                                        }
                                        catch (IOException ioe) {
                                            return Status.CANCEL_STATUS;
                                        }
                                    } else {
                                        UMLUtil.writeProperties((URI)resourcePropertiesURI, (Map)UMLUtil.parseProperties((String)resourceProperties));
                                    }
                                }
                                return Status.OK_STATUS;
                            }

                            protected IStatus doRedo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                                return this.doExecute(monitor, info);
                            }
                        });
                    }
                } else {
                    operation = new CompositeEMFOperation(ted, Messages.UncontrolAction_label);
                    Resource eContainerResource = this.eObject.eContainer().eResource();
                    operation.addContext((IUndoContext)new ResourceUndoContext(ted, eContainerResource));
                    Resource eResource = this.eObject.eResource();
                    operation.addContext((IUndoContext)new ResourceUndoContext(ted, eResource));
                    final ArrayList<Object> uncontrolledElements = new ArrayList<Object>();
                    EList eResourceContents = eResource.getContents();
                    operation.add((IUndoableOperation)new EMFCommandOperation(ted, (Command)new RemoveCommand((EditingDomain)ted, eResourceContents, (Object)this.eObject)));
                    uncontrolledElements.add((Element)this.eObject);
                    ModelDocument sourceDocument = ModelManager.getManager().manage(eContainerResource);
                    if (sourceDocument != null) {
                        sourceDocument.setDirty(true);
                    }
                    if (this.eObject instanceof Class) {
                        for (Property ownedAttribute : ((Class)this.eObject).getOwnedAttributes()) {
                            Association association = ownedAttribute.getAssociation();
                            if (association == null) continue;
                            operation.add((IUndoableOperation)new EMFCommandOperation(ted, (Command)new RemoveCommand((EditingDomain)ted, eResourceContents, (Object)association)));
                            uncontrolledElements.add(association);
                        }
                    }
                    EList otherTargets = ((Element)this.eObject).getRelationships(UMLPackage.Literals.ASSOCIATION);
                    for (Relationship relationship : otherTargets) {
                        for (Element element : relationship.getRelatedElements()) {
                            Iterator targetDocument;
                            if (element.eResource() == null || (targetDocument = ModelManager.getManager().manage(element.eResource())) == null) continue;
                            targetDocument.setDirty(true);
                        }
                    }
                    EList eList = eContainerResource.getContents();
                    for (Element element : uncontrolledElements) {
                        ModelDocument targetDocument;
                        if (element.eResource() != null && (targetDocument = ModelManager.getManager().manage(element.eResource())) != null) {
                            targetDocument.setDirty(true);
                        }
                        for (EObject stereotypeApplication : element.getStereotypeApplications()) {
                            operation.add((IUndoableOperation)new EMFCommandOperation(ted, (Command)new AddCommand((EditingDomain)ted, eList, (Object)stereotypeApplication)));
                        }
                        TreeIterator allProperContents = EcoreUtil.getAllProperContents((EObject)element, (boolean)true);
                        while (allProperContents.hasNext()) {
                            EObject content = (EObject)allProperContents.next();
                            if (!(content instanceof Element)) continue;
                            for (EObject stereotypeApplication : ((Element)content).getStereotypeApplications()) {
                                operation.add((IUndoableOperation)new EMFCommandOperation(ted, (Command)new AddCommand((EditingDomain)ted, eList, (Object)stereotypeApplication)));
                            }
                        }
                    }
                    final URI uRI = UMLUtil.getPropertiesURI((Resource)eResource);
                    final String eResourceProperties = UMLUtil.readProperties((URI)uRI);
                    if (eResourceProperties != null) {
                        final URI eContainerResourcePropertiesURI = UMLUtil.getPropertiesURI((Resource)eContainerResource);
                        final String eContainerResourceProperties = UMLUtil.readProperties((URI)eContainerResourcePropertiesURI);
                        operation.add((IUndoableOperation)new AbstractEMFOperation(ted, ""){

                            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                                Map eResourceParsedProperties = UMLUtil.parseProperties((String)eResourceProperties);
                                Map<String, String> eContainerResourceParsedProperties = eContainerResourceProperties != null ? UMLUtil.parseProperties((String)eContainerResourceProperties) : new LinkedHashMap();
                                TreeIterator allProperContents = EcoreUtil.getAllProperContents((Collection)uncontrolledElements, (boolean)true);
                                while (allProperContents.hasNext()) {
                                    String propertyKey;
                                    String property;
                                    EObject next = (EObject)allProperContents.next();
                                    if (!(next instanceof NamedElement) || (property = (String)eResourceParsedProperties.remove(propertyKey = NamedElementUtil.getLabelPropertyKey((NamedElement)((NamedElement)next)))) == null) continue;
                                    eContainerResourceParsedProperties.put(propertyKey, property);
                                }
                                UMLUtil.writeProperties((URI)uRI, (Map)eResourceParsedProperties);
                                if (!eContainerResourceParsedProperties.isEmpty()) {
                                    UMLUtil.writeProperties((URI)eContainerResourcePropertiesURI, eContainerResourceParsedProperties);
                                }
                                return Status.OK_STATUS;
                            }

                            protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                                UMLUtil.writeProperties((URI)uRI, (Map)UMLUtil.parseProperties((String)eResourceProperties));
                                URIConverter uriConverter = this.getEditingDomain().getResourceSet().getURIConverter();
                                if (uriConverter.exists(eContainerResourcePropertiesURI, null)) {
                                    if (eContainerResourceProperties == null) {
                                        try {
                                            uriConverter.delete(eContainerResourcePropertiesURI, null);
                                        }
                                        catch (IOException ioe) {
                                            return Status.CANCEL_STATUS;
                                        }
                                    } else {
                                        UMLUtil.writeProperties((URI)eContainerResourcePropertiesURI, (Map)UMLUtil.parseProperties((String)eContainerResourceProperties));
                                    }
                                }
                                return Status.OK_STATUS;
                            }

                            protected IStatus doRedo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                                return this.doExecute(monitor, info);
                            }
                        });
                    }
                }
                try {
                    IWorkspaceCommandStack commandStack = (IWorkspaceCommandStack)ted.getCommandStack();
                    operation.addContext(commandStack.getDefaultUndoContext());
                    commandStack.getOperationHistory().execute((IUndoableOperation)operation, (IProgressMonitor)new NullProgressMonitor(), (IAdaptable)EditCommandsFactory.this.activePart);
                }
                catch (ExecutionException ee) {
                    Logger.logException(ee);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e.getCause());
            }
        }
    }

    private class MyValidateAction
    extends ValidateAction {
        public MyValidateAction(EditingDomain editingDomain) {
            this.domain = editingDomain;
            this.eclipseResourcesUtil = new MyResourcesUtil();
        }

        public boolean isEnabled() {
            if (this.selectedObjects == null) {
                return false;
            }
            return super.isEnabled();
        }

        protected Diagnostician createDiagnostician(AdapterFactory adapterFactory, IProgressMonitor progressMonitor) {
            return new UMLDiagnostician(adapterFactory, progressMonitor);
        }

        public void run() {
            for (Object object : this.selectedObjects) {
                if (!(object instanceof EObject)) continue;
                this.eclipseResourcesUtil.deleteMarkers(object);
                break;
            }
            super.run();
            ArrayList<EObject> targets = new ArrayList<EObject>();
            for (Object object : this.selectedObjects) {
                if (!(object instanceof EObject)) continue;
                targets.add((EObject)object);
            }
            ModelValidationService.getInstance().broadcastValidationEvent(new ValidationEvent(EvaluationMode.BATCH, null, targets, Status.OK_STATUS, Collections.singleton("org.eclipse.mdht.uml.ui.validation.refresh")));
        }

        protected void handleDiagnostic(Diagnostic diagnostic) {
            List data;
            this.fixed_handleDiagnostic(diagnostic);
            if (!diagnostic.getChildren().isEmpty() && !(data = ((Diagnostic)diagnostic.getChildren().get(0)).getData()).isEmpty() && data.get(0) instanceof EObject) {
                Viewer viewer;
                IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
                UMLDomainNavigatorItem item = new UMLDomainNavigatorItem((EObject)data.get(0), null, null);
                if (part instanceof ISetSelectionTarget) {
                    ((ISetSelectionTarget)part).selectReveal((ISelection)new StructuredSelection((Object)item));
                } else if (part instanceof IViewerProvider && (viewer = ((IViewerProvider)part).getViewer()) != null) {
                    viewer.setSelection((ISelection)new StructuredSelection((Object)item), true);
                }
            }
        }

        protected void fixed_handleDiagnostic(Diagnostic diagnostic) {
            List data;
            int severity = diagnostic.getSeverity();
            String title = null;
            String message = null;
            if (severity == 4 || severity == 2) {
                title = EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationProblems_title");
                message = EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationProblems_message");
            } else {
                title = EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationResults_title");
                message = EMFEditUIPlugin.INSTANCE.getString(severity == 0 ? "_UI_ValidationOK_message" : "_UI_ValidationResults_message");
            }
            int result = 0;
            if (diagnostic.getSeverity() == 0) {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)title, (String)message);
                result = 1;
            } else {
                result = DiagnosticDialog.open((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)title, (String)message, (Diagnostic)diagnostic);
            }
            if (this.eclipseResourcesUtil != null && !diagnostic.getChildren().isEmpty() && (data = ((Diagnostic)diagnostic.getChildren().get(0)).getData()).get(0) instanceof EObject) {
                EObject firstEObject = (EObject)data.get(0);
                Resource resource = firstEObject.eResource();
                if (resource != null) {
                    this.eclipseResourcesUtil.deleteMarkers((Object)resource);
                }
                if (result == 0) {
                    Viewer viewer;
                    IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
                    if (part instanceof ISetSelectionTarget) {
                        ((ISetSelectionTarget)part).selectReveal((ISelection)new StructuredSelection((Object)firstEObject));
                    } else if (part instanceof IViewerProvider && (viewer = ((IViewerProvider)part).getViewer()) != null) {
                        viewer.setSelection((ISelection)new StructuredSelection((Object)firstEObject), true);
                    }
                    if (resource != null) {
                        for (Object childDiagnostic : diagnostic.getChildren()) {
                            this.eclipseResourcesUtil.createMarkers(resource, (Diagnostic)childDiagnostic);
                        }
                    }
                }
            }
        }

        public class MyResourcesUtil
        extends ValidateAction.EclipseResourcesUtil {
            protected void adjustMarker(IMarker marker, Diagnostic diagnostic, Diagnostic parentDiagnostic) throws CoreException {
                List data;
                super.adjustMarker(marker, diagnostic, parentDiagnostic);
                if (!diagnostic.getData().isEmpty() && (data = diagnostic.getData()).get(0) instanceof NamedElement) {
                    NamedElement element = (NamedElement)data.get(0);
                    if (element instanceof ValueSpecification && element.eContainer() instanceof Property) {
                        element = (Property)element.eContainer();
                        marker.setAttribute("uri", (Object)EcoreUtil.getURI((EObject)element).toString());
                    }
                    marker.setAttribute("location", (Object)element.getQualifiedName());
                }
            }
        }
    }
}

