/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.edit.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.mdht.uml.common.util.NamedElementUtil;
import org.eclipse.mdht.uml.edit.IUMLTableProperties;
import org.eclipse.mdht.uml.edit.internal.Logger;
import org.eclipse.mdht.uml.edit.provider.UML2ExtendedAdapterFactory;
import org.eclipse.mdht.uml.edit.provider.operations.NamedElementOperations;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.edit.providers.ParameterItemProvider;

public class ParameterExtItemProvider
extends ParameterItemProvider
implements ITableItemLabelProvider,
ICellModifier {
    public ParameterExtItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public Object getImage(Object object) {
        return super.getImage(object);
    }

    protected String getName(NamedElement namedElement) {
        AdapterFactory adapterFactory = this.getAdapterFactory();
        return adapterFactory instanceof UML2ExtendedAdapterFactory && ((UML2ExtendedAdapterFactory)adapterFactory).isShowBusinessNames() ? NamedElementUtil.getBusinessName((NamedElement)namedElement) : namedElement.getName();
    }

    public String getText(Object object) {
        Parameter parameter = (Parameter)object;
        String name = this.getName((NamedElement)parameter);
        if (name == null || name.length() == 0) {
            name = this.getString("_UI_Parameter_type");
        }
        StringBuffer label = new StringBuffer();
        label.append(name);
        if (parameter.getType() != null) {
            label.append(" : ").append(this.getName((NamedElement)parameter.getType()));
        }
        label.append(this.displayMultiplicity((MultiplicityElement)parameter));
        String defaultValue = parameter.getDefault();
        if (defaultValue != null && defaultValue.length() > 0) {
            label.append(" = ");
            label.append(defaultValue);
        }
        return label.toString();
    }

    protected String displayMultiplicity(MultiplicityElement multElement) {
        StringBuffer multDisplay = new StringBuffer();
        if (this.checkDisplayRange(multElement)) {
            multDisplay.append(" [");
            multDisplay.append(multElement.getLower());
            multDisplay.append("..");
            multDisplay.append(multElement.getUpper() == -1 ? "*" : Integer.toString(multElement.getUpper()));
            multDisplay.append("]");
        }
        return multDisplay.toString();
    }

    protected boolean checkDisplayRange(MultiplicityElement multElement) {
        return multElement.getLower() != 1 || multElement.getUpper() != 1;
    }

    public Collection<Element> getChildren(Object object) {
        Parameter parameter = (Parameter)object;
        ArrayList<Element> children = new ArrayList<Element>();
        children.addAll((Collection<Element>)parameter.getOwnedComments());
        return children;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(StructuralFeature.class)) {
            case 10: 
            case 17: 
            case 19: 
            case 21: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    public Object getColumnImage(Object object, int columnIndex) {
        Parameter parameter = (Parameter)object;
        Type type = parameter.getType();
        switch (columnIndex) {
            case 0: {
                return this.getImage(parameter);
            }
            case 1: {
                IItemLabelProvider provider;
                if (type == null || (provider = (IItemLabelProvider)this.getAdapterFactory().adapt((Notifier)type, IItemLabelProvider.class)) == null) break;
                return provider.getImage((Object)type);
            }
        }
        return null;
    }

    public String getColumnText(Object object, int columnIndex) {
        Parameter parameter = (Parameter)object;
        switch (columnIndex) {
            case 0: {
                return this.getName((NamedElement)parameter);
            }
            case 1: {
                return parameter.getType() == null ? null : this.getName((NamedElement)parameter.getType());
            }
            case 2: {
                return this.displayColumnMultiplicity((MultiplicityElement)parameter);
            }
            case 6: {
                if (parameter.getDefaultValue() != null) {
                    return parameter.getDefaultValue().stringValue();
                }
                return "";
            }
        }
        return null;
    }

    protected String displayColumnMultiplicity(MultiplicityElement multElement) {
        StringBuffer multDisplay = new StringBuffer();
        multDisplay.append(multElement.getLower());
        multDisplay.append("..");
        multDisplay.append(multElement.getUpper() == -1 ? "*" : Integer.toString(multElement.getUpper()));
        return multDisplay.toString();
    }

    public boolean canModify(Object element, String property) {
        if (IUMLTableProperties.NAME_PROPERTY.equals(property)) {
            return true;
        }
        if (IUMLTableProperties.TYPE_PROPERTY.equals(property)) {
            return true;
        }
        if ("multiplicity".equals(property)) {
            return true;
        }
        return IUMLTableProperties.DEFAULT_VALUE_PROPERTY.equals(property);
    }

    public Object getValue(Object element, String property) {
        Parameter parameter = (Parameter)element;
        if (IUMLTableProperties.NAME_PROPERTY.equals(property)) {
            return parameter.getName();
        }
        if (IUMLTableProperties.TYPE_PROPERTY.equals(property)) {
            return parameter.getType();
        }
        if ("multiplicity".equals(property)) {
            return this.displayColumnMultiplicity((MultiplicityElement)parameter);
        }
        if (IUMLTableProperties.DEFAULT_VALUE_PROPERTY.equals(property)) {
            if (parameter.getDefaultValue() != null) {
                return parameter.getDefaultValue().stringValue();
            }
            return "";
        }
        return null;
    }

    public void modify(Object element, final String property, final Object value) {
        final Parameter parameter = (Parameter)element;
        if (IUMLTableProperties.NAME_PROPERTY.equals(property) || IUMLTableProperties.VISIBILITY_PROPERTY.equals(property)) {
            NamedElementOperations.modify(element, property, value);
            return;
        }
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)parameter);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "temp"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    if (IUMLTableProperties.TYPE_PROPERTY.equals(property) && value instanceof Classifier) {
                        this.setLabel("Set Parameter Type");
                        parameter.setType((Type)((Classifier)value));
                    } else if (IUMLTableProperties.DEFAULT_VALUE_PROPERTY.equals(property) && value instanceof String) {
                        String newValue;
                        this.setLabel("Set Default Value");
                        if (parameter.getDefaultValue() != null) {
                            parameter.getDefaultValue().destroy();
                        }
                        if ((newValue = (String)value) != null && newValue.trim().length() > 0) {
                            LiteralString literal = UMLFactory.eINSTANCE.createLiteralString();
                            literal.setValue(newValue);
                            parameter.setDefaultValue((ValueSpecification)literal);
                        }
                    } else if ("multiplicity".equals(property) && value instanceof String) {
                        this.setLabel("Set Multiplicity");
                        ParameterExtItemProvider.this.setMultiplicity((MultiplicityElement)parameter, value.toString());
                    } else {
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            try {
                IWorkspaceCommandStack commandStack = (IWorkspaceCommandStack)editingDomain.getCommandStack();
                operation.addContext(commandStack.getDefaultUndoContext());
                commandStack.getOperationHistory().execute((IUndoableOperation)operation, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException ee) {
                Logger.logException(ee);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private void setMultiplicity(MultiplicityElement multiplicityElement, String value) {
        int lower = 1;
        int upper = 1;
        StringTokenizer stk = new StringTokenizer(value, ". ");
        if (stk.hasMoreTokens()) {
            lower = this.parseMultiplicityRangeToken(stk.nextToken());
            if (!stk.hasMoreTokens()) {
                if (lower == -1) {
                    lower = 0;
                    upper = -1;
                } else {
                    upper = lower;
                }
            } else {
                upper = this.parseMultiplicityRangeToken(stk.nextToken());
                if (stk.hasMoreTokens()) {
                    throw new IllegalArgumentException("illegal range specification: " + value);
                }
            }
        }
        if (multiplicityElement.getLowerValue() != null) {
            multiplicityElement.getLowerValue().destroy();
        }
        if (multiplicityElement.getUpperValue() != null) {
            multiplicityElement.getUpperValue().destroy();
        }
        multiplicityElement.setUpper(upper);
        multiplicityElement.setLower(lower);
    }

    private int parseMultiplicityRangeToken(String token) {
        block3: {
            try {
                if (!token.equalsIgnoreCase("n") && !token.equals("*") && !token.equalsIgnoreCase("unbounded")) break block3;
                return -1;
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("illegal range bound: " + token);
            }
        }
        return Integer.parseInt(token);
    }
}

