/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.ui.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mdht.uml.cda.core.util.CDAProfileUtil;
import org.eclipse.mdht.uml.common.ui.search.IElementFilter;
import org.eclipse.mdht.uml.common.ui.search.ModelSearch;
import org.eclipse.mdht.uml.term.core.profile.CodeSystemVersion;
import org.eclipse.mdht.uml.term.core.profile.ValueSetVersion;
import org.eclipse.mdht.uml.term.core.util.TermProfileUtil;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class UpdateProfileVersionAction
implements IObjectActionDelegate {
    private NamedElement namedElement;
    private List<CodeSystemVersion> codeSystems = new ArrayList<CodeSystemVersion>();
    private List<ValueSetVersion> valueSets = new ArrayList<ValueSetVersion>();

    public void run(IAction action) {
        this.cacheTerminology();
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.namedElement);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "Update CDA Profile"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    TreeIterator iterator = EcoreUtil.getAllContents(Collections.singletonList(UpdateProfileVersionAction.this.namedElement));
                    while (iterator != null && iterator.hasNext()) {
                        Object child = iterator.next();
                        if (child instanceof Package) {
                            Package umlPackage = (Package)child;
                            Profile cdaProfile = CDAProfileUtil.getCDAProfile((ResourceSet)umlPackage.eResource().getResourceSet());
                            try {
                                umlPackage.applyProfile(cdaProfile);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (!(child instanceof Property)) continue;
                        Property property = (Property)child;
                        Stereotype vocabSpec = CDAProfileUtil.getAppliedCDAStereotype((Element)property, (String)"VocabSpecification");
                        if (vocabSpec != null) {
                            UpdateProfileVersionAction.this.updateVocabSpecification(property);
                        }
                        iterator.prune();
                    }
                    return Status.OK_STATUS;
                }
            };
            try {
                IWorkspaceCommandStack commandStack = (IWorkspaceCommandStack)editingDomain.getCommandStack();
                operation.addContext(commandStack.getDefaultUndoContext());
                commandStack.getOperationHistory().execute((IUndoableOperation)operation, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException ee) {
                ee.printStackTrace();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.namedElement = null;
        if (((IStructuredSelection)selection).size() == 1) {
            Object selected = ((IStructuredSelection)selection).getFirstElement();
            if (selected instanceof IAdaptable) {
                selected = ((IAdaptable)selected).getAdapter(EObject.class);
            }
            if (selected instanceof NamedElement) {
                this.namedElement = (NamedElement)selected;
            }
        }
        action.setEnabled(this.namedElement != null);
    }

    private void cacheTerminology() {
        Profile ctsProfile = TermProfileUtil.getTerminologyProfile((ResourceSet)this.namedElement.eResource().getResourceSet());
        if (ctsProfile == null) {
            return;
        }
        final Stereotype codeSystemVersionStereotype = (Stereotype)ctsProfile.getOwnedType("CodeSystemVersion");
        final Stereotype valueSetVersionStereotype = (Stereotype)ctsProfile.getOwnedType("ValueSetVersion");
        IElementFilter codeSystemFilter = new IElementFilter(){

            public boolean accept(Element element) {
                return element instanceof Enumeration && element.isStereotypeApplied(codeSystemVersionStereotype);
            }
        };
        IElementFilter valueSetFilter = new IElementFilter(){

            public boolean accept(Element element) {
                return element instanceof Enumeration && element.isStereotypeApplied(valueSetVersionStereotype);
            }
        };
        List codeSystemEnums = ModelSearch.findAllOf((ResourceSet)this.namedElement.eResource().getResourceSet(), (IElementFilter)codeSystemFilter);
        List valueSetEnums = ModelSearch.findAllOf((ResourceSet)this.namedElement.eResource().getResourceSet(), (IElementFilter)valueSetFilter);
        for (Element element : codeSystemEnums) {
            CodeSystemVersion codeSystemVersion = (CodeSystemVersion)element.getStereotypeApplication(codeSystemVersionStereotype);
            if (codeSystemVersion == null) continue;
            this.codeSystems.add(codeSystemVersion);
        }
        for (Element element : valueSetEnums) {
            ValueSetVersion valueSetVersion = (ValueSetVersion)element.getStereotypeApplication(valueSetVersionStereotype);
            if (valueSetVersion == null) continue;
            this.valueSets.add(valueSetVersion);
        }
    }

    private CodeSystemVersion findCodeSystem(String identifier) {
        if (identifier != null) {
            for (CodeSystemVersion codeSystem : this.codeSystems) {
                if (!codeSystem.getIdentifier().equals(identifier)) continue;
                return codeSystem;
            }
        }
        return null;
    }

    private ValueSetVersion findValueSet(String identifier) {
        if (identifier != null) {
            for (ValueSetVersion valueSet : this.valueSets) {
                if (!valueSet.getIdentifier().equals(identifier)) continue;
                return valueSet;
            }
        }
        return null;
    }

    private void updateVocabSpecification(Property property) {
        Profile cdaProfile = CDAProfileUtil.getAppliedCDAProfile((Element)property);
        Stereotype vocabSpecification = CDAProfileUtil.getAppliedCDAStereotype((Element)property, (String)"VocabSpecification");
        String identifier = (String)property.getValue(vocabSpecification, "codeSystem");
        String name = (String)property.getValue(vocabSpecification, "codeSystemName");
        String version = (String)property.getValue(vocabSpecification, "codeSystemVersion");
        String code = (String)property.getValue(vocabSpecification, "code");
        String displayName = (String)property.getValue(vocabSpecification, "displayName");
        Object severity = property.getValue(vocabSpecification, "severity");
        String message = (String)property.getValue(vocabSpecification, "message");
        Stereotype propertyValidation = cdaProfile.getOwnedStereotype("PropertyValidation");
        Stereotype codeSystemConstraint = cdaProfile.getOwnedStereotype("CodeSystemConstraint");
        Stereotype valueSetConstraint = cdaProfile.getOwnedStereotype("ValueSetConstraint");
        if (codeSystemConstraint == null || valueSetConstraint == null) {
            return;
        }
        CodeSystemVersion codeSystemVersion = this.findCodeSystem(identifier);
        ValueSetVersion valueSetVersion = this.findValueSet(identifier);
        if (property.isStereotypeApplicable(codeSystemConstraint) && (code != null || codeSystemVersion != null)) {
            property.applyStereotype(codeSystemConstraint);
            if (codeSystemVersion != null) {
                property.setValue(codeSystemConstraint, "reference", (Object)codeSystemVersion);
            } else {
                System.err.println("Cannot find code system: " + name + " ID: " + identifier);
                property.setValue(codeSystemConstraint, "identifier", (Object)identifier);
                property.setValue(codeSystemConstraint, "name", (Object)name);
                property.setValue(codeSystemConstraint, "version", (Object)version);
            }
            property.setValue(codeSystemConstraint, "code", (Object)code);
            property.setValue(codeSystemConstraint, "displayName", (Object)displayName);
            property.setValue(codeSystemConstraint, "severity", severity);
            property.setValue(codeSystemConstraint, "message", (Object)message);
            property.unapplyStereotype(vocabSpecification);
        } else if (property.isStereotypeApplicable(valueSetConstraint) && (identifier != null || name != null)) {
            property.applyStereotype(valueSetConstraint);
            if (valueSetVersion != null) {
                property.setValue(valueSetConstraint, "reference", (Object)valueSetVersion);
            } else {
                System.err.println("Cannot find value set: " + name + " ID: " + identifier);
                property.setValue(valueSetConstraint, "identifier", (Object)identifier);
                property.setValue(valueSetConstraint, "name", (Object)name);
                property.setValue(valueSetConstraint, "version", (Object)version);
            }
            property.setValue(valueSetConstraint, "severity", severity);
            property.setValue(valueSetConstraint, "message", (Object)message);
            property.unapplyStereotype(vocabSpecification);
        } else if (property.isStereotypeApplicable(propertyValidation) && !property.isStereotypeApplied(propertyValidation)) {
            property.applyStereotype(propertyValidation);
            property.setValue(propertyValidation, "severity", severity);
            property.setValue(propertyValidation, "message", (Object)message);
            property.unapplyStereotype(vocabSpecification);
        }
    }
}

