/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Map;
import org.immutables.value.Value;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.ImmutableLogConfig;

@JsonDeserialize(builder=ImmutableLogConfig.Builder.class)
@Value.Immutable
public interface LogConfig {
    @JsonProperty(value="Type")
    public String logType();

    @JsonProperty(value="Config")
    @Nullable
    public Map<String, String> logOptions();

    public static LogConfig create(String logType) {
        return ImmutableLogConfig.builder().logType(logType).build();
    }

    public static LogConfig create(String logType, Map<String, String> logOptions) {
        return ((ImmutableLogConfig.Builder)ImmutableLogConfig.builder().logType(logType).logOptions(logOptions)).build();
    }

    public static Builder builder() {
        return ImmutableLogConfig.builder();
    }

    public static interface Builder {
        public Builder logType(String var1);

        public Builder logOptions(Map<String, ? extends String> var1);

        public LogConfig build();
    }
}

