/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.DockerImagePullFailedException;
import org.eclipse.linuxtools.docker.core.DockerOperationCancelledException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerProgressDetail;
import org.eclipse.linuxtools.docker.core.IDockerProgressHandler;
import org.eclipse.linuxtools.docker.core.IDockerProgressMessage;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.core.DockerMessages;
import org.eclipse.linuxtools.internal.docker.core.ProgressJob;
import org.eclipse.linuxtools.internal.docker.core.ProgressJob2;

public class DefaultImagePullProgressHandler
implements IDockerProgressHandler {
    private static final String IMAGE_DOWNLOAD_COMPLETE = "ImageDownloadComplete.msg";
    private static final String IMAGE_DOWNLOADING_JOBNAME = "ImageDownloadingJobName.msg";
    private static final String IMAGE_DOWNLOADING_IMAGE = "ImageDownloadingImage.msg";
    private static final String IMAGE_DOWNLOADING = "ImageDownloading.msg";
    private static final String IMAGE_VERIFYING_CHECKSUM = "ImageVerifyingChecksum.msg";
    private static final String IMAGE_EXTRACTING_JOBNAME = "ImageExtractingJobName.msg";
    private static final String IMAGE_EXTRACTING_IMAGE = "ImageExtractingImage.msg";
    private static final String IMAGE_EXTRACTING = "ImageExtracting.msg";
    private static final String IMAGE_PULLING = "ImagePulling.msg";
    private static final String IMAGE_PULL_COMPLETE = "ImagePullComplete.msg";
    private static final String IMAGE_DOWNLOADING_ALREADY_EXISTS = "ImageDownloadingAlreadyExists.msg";
    private static final String IMAGE_DOWNLOADING_VERIFIED = "ImageDownloadingVerified.msg";
    private String image;
    private DockerConnection connection;
    private IProgressMonitor monitor;
    private boolean cancelled = false;
    private Map<String, ProgressJob> progressJobs = new ConcurrentHashMap<String, ProgressJob>();

    public DefaultImagePullProgressHandler(IDockerConnection connection, String image, IProgressMonitor monitor) {
        this.image = image;
        this.connection = (DockerConnection)connection;
        this.monitor = monitor;
    }

    private void handleCancellation(IDockerProgressMessage message) throws DockerOperationCancelledException, DockerImagePullFailedException {
        for (Map.Entry<String, ProgressJob> entry : this.progressJobs.entrySet()) {
            IStatus res = entry.getValue().getResult();
            if (res == null) continue;
            this.progressJobs.remove(entry.getKey());
            if (res.isOK()) continue;
            this.cancelled = true;
        }
        if (this.monitor != null && this.monitor.isCanceled()) {
            this.cancelled = true;
        }
        if (message.error() != null) {
            this.cancelled = true;
        }
        if (this.cancelled) {
            for (ProgressJob progressJob : this.progressJobs.values()) {
                progressJob.cancel();
            }
            if (message.error() != null) {
                throw new DockerImagePullFailedException(this.image, message.error());
            }
            throw new DockerOperationCancelledException();
        }
    }

    @Override
    public void processMessage(IDockerProgressMessage message) throws DockerException {
        this.handleCancellation(message);
        String id = message.id();
        if (id == null) {
            return;
        }
        ProgressJob p = this.progressJobs.get(id);
        if (p == null) {
            String status = message.status();
            if (!status.contains(DockerMessages.getString(IMAGE_PULLING))) {
                if (status.equals(DockerMessages.getString(IMAGE_DOWNLOAD_COMPLETE)) || status.contains(DockerMessages.getString(IMAGE_DOWNLOADING_ALREADY_EXISTS)) || status.contains(DockerMessages.getString(IMAGE_DOWNLOADING_VERIFIED)) || status.contains(DockerMessages.getString(IMAGE_VERIFYING_CHECKSUM)) || status.equals(DockerMessages.getString(IMAGE_PULL_COMPLETE))) {
                    this.connection.getImages(true);
                } else if (status.startsWith(DockerMessages.getString(IMAGE_DOWNLOADING))) {
                    IDockerProgressDetail detail = message.progressDetail();
                    if (detail == null || detail.total() == 0L) {
                        ProgressJob2 newJob = new ProgressJob2(DockerMessages.getFormattedString(IMAGE_DOWNLOADING_JOBNAME, this.image), DockerMessages.getFormattedString(IMAGE_DOWNLOADING_IMAGE, id));
                        newJob.setUser(false);
                        newJob.setPriority(30);
                        newJob.schedule();
                        this.progressJobs.put(id, newJob);
                    } else {
                        ProgressJob newJob = new ProgressJob(DockerMessages.getFormattedString(IMAGE_DOWNLOADING_JOBNAME, this.image), DockerMessages.getFormattedString(IMAGE_DOWNLOADING_IMAGE, id));
                        newJob.setUser(false);
                        newJob.setPriority(30);
                        newJob.schedule();
                        this.progressJobs.put(id, newJob);
                    }
                } else if (status.startsWith(DockerMessages.getString(IMAGE_EXTRACTING))) {
                    IDockerProgressDetail detail = message.progressDetail();
                    if (detail == null || detail.total() == 0L) {
                        ProgressJob2 newJob = new ProgressJob2(DockerMessages.getFormattedString(IMAGE_EXTRACTING_JOBNAME, this.image), DockerMessages.getFormattedString(IMAGE_EXTRACTING_IMAGE, id));
                        newJob.setUser(false);
                        newJob.setPriority(30);
                        newJob.schedule();
                        this.progressJobs.put(id, newJob);
                    } else {
                        ProgressJob newJob = new ProgressJob(DockerMessages.getFormattedString(IMAGE_EXTRACTING_JOBNAME, this.image), DockerMessages.getFormattedString(IMAGE_EXTRACTING_IMAGE, id));
                        newJob.setUser(false);
                        newJob.setPriority(30);
                        newJob.schedule();
                        this.progressJobs.put(id, newJob);
                    }
                }
            }
        } else {
            IDockerProgressDetail detail;
            String status = message.status();
            if (status.equals(DockerMessages.getString(IMAGE_DOWNLOAD_COMPLETE)) || status.contains(DockerMessages.getString(IMAGE_DOWNLOADING_ALREADY_EXISTS)) || status.contains(DockerMessages.getString(IMAGE_DOWNLOADING_VERIFIED)) || status.contains(DockerMessages.getString(IMAGE_VERIFYING_CHECKSUM)) || status.contains(DockerMessages.getString(IMAGE_PULL_COMPLETE))) {
                p.setPercentageDone(100);
                this.progressJobs.remove(id);
                this.connection.getImages(true);
            } else if (status.startsWith(DockerMessages.getString(IMAGE_DOWNLOADING))) {
                IDockerProgressDetail detail2 = message.progressDetail();
                if (detail2 != null) {
                    if (p instanceof ProgressJob2) {
                        ((ProgressJob2)p).setStatusMessage(message.progress());
                    } else if (detail2.current() > 0L && detail2.total() > 0L) {
                        long percentage = detail2.current() * 100L / detail2.total();
                        p.setPercentageDone((int)percentage);
                    }
                }
            } else if (status.startsWith(DockerMessages.getString(IMAGE_EXTRACTING)) && (detail = message.progressDetail()) != null) {
                if (p instanceof ProgressJob2) {
                    ((ProgressJob2)p).setStatusMessage(message.progress());
                } else if (detail.current() > 0L && detail.total() > 0L) {
                    long percentage = detail.current() * 100L / detail.total();
                    p.setPercentageDone((int)percentage);
                }
            }
        }
    }
}

