/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.Volume;
import org.mandas.docker.client.messages.VolumeList;

final class ImmutableVolumeList
implements VolumeList {
    @Nullable
    private final List<Volume> volumes;
    @Nullable
    private final List<String> warnings;

    private ImmutableVolumeList(@Nullable List<Volume> volumes, @Nullable List<String> warnings) {
        this.volumes = volumes;
        this.warnings = warnings;
    }

    @Override
    @JsonProperty(value="Volumes")
    @Nullable
    public List<Volume> volumes() {
        return this.volumes;
    }

    @Override
    @JsonProperty(value="Warnings")
    @Nullable
    public List<String> warnings() {
        return this.warnings;
    }

    public final ImmutableVolumeList withVolumes(Volume ... elements) {
        if (elements == null) {
            return new ImmutableVolumeList(null, this.warnings);
        }
        List<Volume> newValue = Arrays.asList(elements) == null ? null : ImmutableVolumeList.createUnmodifiableList(false, ImmutableVolumeList.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableVolumeList(newValue, this.warnings);
    }

    public final ImmutableVolumeList withVolumes(@Nullable Iterable<? extends Volume> elements) {
        if (this.volumes == elements) {
            return this;
        }
        List<Volume> newValue = elements == null ? null : ImmutableVolumeList.createUnmodifiableList(false, ImmutableVolumeList.createSafeList(elements, true, false));
        return new ImmutableVolumeList(newValue, this.warnings);
    }

    public final ImmutableVolumeList withWarnings(String ... elements) {
        if (elements == null) {
            return new ImmutableVolumeList(this.volumes, null);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableVolumeList.createUnmodifiableList(false, ImmutableVolumeList.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableVolumeList(this.volumes, newValue);
    }

    public final ImmutableVolumeList withWarnings(@Nullable Iterable<String> elements) {
        if (this.warnings == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableVolumeList.createUnmodifiableList(false, ImmutableVolumeList.createSafeList(elements, true, false));
        return new ImmutableVolumeList(this.volumes, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableVolumeList && this.equalTo(0, (ImmutableVolumeList)another);
    }

    private boolean equalTo(int synthetic, ImmutableVolumeList another) {
        return Objects.equals(this.volumes, another.volumes) && Objects.equals(this.warnings, another.warnings);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.volumes);
        h += (h << 5) + Objects.hashCode(this.warnings);
        return h;
    }

    public String toString() {
        return "VolumeList{volumes=" + String.valueOf(this.volumes) + ", warnings=" + String.valueOf(this.warnings) + "}";
    }

    public static ImmutableVolumeList copyOf(VolumeList instance) {
        if (instance instanceof ImmutableVolumeList) {
            return (ImmutableVolumeList)instance;
        }
        return ImmutableVolumeList.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    static final class Builder {
        private List<Volume> volumes = null;
        private List<String> warnings = null;

        private Builder() {
        }

        public final Builder from(VolumeList instance) {
            List<String> warningsValue;
            Objects.requireNonNull(instance, "instance");
            List<Volume> volumesValue = instance.volumes();
            if (volumesValue != null) {
                this.addAllVolumes(volumesValue);
            }
            if ((warningsValue = instance.warnings()) != null) {
                this.addAllWarnings(warningsValue);
            }
            return this;
        }

        public final Builder volume(Volume element) {
            if (this.volumes == null) {
                this.volumes = new ArrayList<Volume>();
            }
            this.volumes.add(Objects.requireNonNull(element, "volumes element"));
            return this;
        }

        public final Builder volumes(Volume ... elements) {
            if (this.volumes == null) {
                this.volumes = new ArrayList<Volume>();
            }
            for (Volume element : elements) {
                this.volumes.add(Objects.requireNonNull(element, "volumes element"));
            }
            return this;
        }

        @JsonProperty(value="Volumes")
        public final Builder volumes(@Nullable Iterable<? extends Volume> elements) {
            if (elements == null) {
                this.volumes = null;
                return this;
            }
            this.volumes = new ArrayList<Volume>();
            return this.addAllVolumes(elements);
        }

        public final Builder addAllVolumes(Iterable<? extends Volume> elements) {
            Objects.requireNonNull(elements, "volumes element");
            if (this.volumes == null) {
                this.volumes = new ArrayList<Volume>();
            }
            for (Volume volume : elements) {
                this.volumes.add(Objects.requireNonNull(volume, "volumes element"));
            }
            return this;
        }

        public final Builder warning(String element) {
            if (this.warnings == null) {
                this.warnings = new ArrayList<String>();
            }
            this.warnings.add(Objects.requireNonNull(element, "warnings element"));
            return this;
        }

        public final Builder warnings(String ... elements) {
            if (this.warnings == null) {
                this.warnings = new ArrayList<String>();
            }
            for (String element : elements) {
                this.warnings.add(Objects.requireNonNull(element, "warnings element"));
            }
            return this;
        }

        @JsonProperty(value="Warnings")
        public final Builder warnings(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.warnings = null;
                return this;
            }
            this.warnings = new ArrayList<String>();
            return this.addAllWarnings(elements);
        }

        public final Builder addAllWarnings(Iterable<String> elements) {
            Objects.requireNonNull(elements, "warnings element");
            if (this.warnings == null) {
                this.warnings = new ArrayList<String>();
            }
            for (String element : elements) {
                this.warnings.add(Objects.requireNonNull(element, "warnings element"));
            }
            return this;
        }

        public ImmutableVolumeList build() {
            return new ImmutableVolumeList(this.volumes == null ? null : ImmutableVolumeList.createUnmodifiableList(true, this.volumes), this.warnings == null ? null : ImmutableVolumeList.createUnmodifiableList(true, this.warnings));
        }
    }
}

