/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.transformations.properties.extension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jwt.transformations.properties.extension.FeatureFullDescription;
import org.eclipse.jwt.transformations.properties.extension.ProxyFactory;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.ui.WorkbenchException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFBasedMultiExtensionHelper<T> {
    public static final String PACKAGE_NAME = "packageName";
    public static final String CLASS_NAME = "className";
    public static final String FEATURE_NAME = "featureName";
    private static Logger log = Logger.getLogger(EMFBasedMultiExtensionHelper.class);
    private boolean initialized = false;
    private String extensionPoint;
    private ProxyFactory<T> proxyFactory;
    private Map<FeatureFullDescription, T> extensionPointEntries = new HashMap<FeatureFullDescription, T>();
    private Map<FeatureFullDescription, List<T>> extensionObjects = new HashMap<FeatureFullDescription, List<T>>();

    public EMFBasedMultiExtensionHelper(String extensionPointId, ProxyFactory<T> proxyFactory) {
        this.extensionPoint = extensionPointId;
        this.proxyFactory = proxyFactory;
    }

    private void processExtensionPoint() throws WorkbenchException {
        log.debug("Processing extension point " + this.extensionPoint);
        IConfigurationElement[] confElements = Platform.getExtensionRegistry().getConfigurationElementsFor(this.extensionPoint);
        int m = 0;
        while (m < confElements.length) {
            IConfigurationElement member = confElements[m];
            String featureName = member.getAttribute(FEATURE_NAME);
            String className = member.getAttribute(CLASS_NAME);
            String packageName = member.getAttribute(PACKAGE_NAME);
            log.info("JWT Extension - found PropertyDescriptor at " + this.extensionPoint + ": {" + packageName + "}" + className + "/" + featureName);
            T proxy = this.proxyFactory.createProxy(member);
            this.extensionPointEntries.put(new FeatureFullDescription(featureName, className, packageName), proxy);
            ++m;
        }
    }

    private synchronized void init() {
        if (!this.initialized) {
            try {
                this.processExtensionPoint();
            }
            catch (WorkbenchException workbenchException) {
                Logger.getLogger(EMFBasedMultiExtensionHelper.class).severe("Could not process extension point for custom PropertyDescriptor");
            }
            this.initialized = true;
        }
    }

    private void computeExtensionsFor(FeatureFullDescription currentFeature) {
        this.init();
        ArrayList<T> res = new ArrayList<T>();
        for (FeatureFullDescription availableFeature : this.extensionPointEntries.keySet()) {
            if (!currentFeature.isFeatureFromSuperclass(availableFeature)) continue;
            res.add(this.extensionPointEntries.get(availableFeature));
        }
        this.extensionObjects.put(currentFeature, res);
    }

    public List<T> getObject(FeatureFullDescription feature) {
        if (!this.extensionObjects.containsKey(feature)) {
            this.computeExtensionsFor(feature);
        }
        return this.extensionObjects.get(feature);
    }
}

