/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.se.cache.xml.disableselective;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.se.cache.xml.disableselective.Customer;
import com.sun.ts.tests.jpa.se.cache.xml.disableselective.Order;
import java.util.Properties;
import javax.persistence.Cache;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", (Throwable)e);
        }
    }

    public void containsTest() throws EETest.Fault {
        boolean pass2;
        boolean pass1;
        block10: {
            pass1 = false;
            pass2 = false;
            if (this.cachingSupported) {
                try {
                    EntityManager em2 = this.getEntityManager();
                    EntityTransaction et = this.getEntityTransaction();
                    et.begin();
                    Order order = new Order(1, 101);
                    em2.persist((Object)order);
                    TestUtil.logTrace((String)("persisted Order " + order));
                    Customer cust = new Customer("1", "one");
                    em2.persist((Object)cust);
                    TestUtil.logTrace((String)("persisted Customer " + cust));
                    em2.flush();
                    et.commit();
                    EntityManagerFactory emf = this.getEntityManagerFactory();
                    Cache cache = emf.getCache();
                    if (cache != null) {
                        boolean b1 = cache.contains(Order.class, (Object)1);
                        if (b1) {
                            TestUtil.logTrace((String)("Cache returned: " + b1 + ", therefore cache does contain order " + order));
                            pass1 = true;
                        } else {
                            TestUtil.logErr((String)("Cache returned: " + b1 + ", therefore cache does not contain order " + order));
                        }
                        boolean b2 = cache.contains(Customer.class, (Object)"1");
                        if (!b2) {
                            TestUtil.logTrace((String)("Cache returned: " + b2 + ", therefore cache does not contain Customer " + cust));
                            pass2 = true;
                        } else {
                            TestUtil.logErr((String)("Cache returned: " + b2 + ", therefore cache does contain Customer " + cust));
                        }
                        break block10;
                    }
                    TestUtil.logErr((String)"Cache returned was null");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                }
            } else {
                TestUtil.logMsg((String)"Cache not supported, bypassing test");
                pass1 = true;
                pass2 = true;
            }
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("containsTest failed");
        }
    }

    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM CUSTOMER_TABLE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

