/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.model;

import com.sun.tdk.signaturetest.model.MemberType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Modifier
implements Serializable {
    private static final Map knownModifiers = new HashMap();
    public static final Modifier ABSTRACT = new Modifier("abstract", 1024, 1024, true);
    public static final Modifier PUBLIC = new Modifier("public", 1, 1, true);
    public static final Modifier PRIVATE = new Modifier("private", 2, 2, true);
    public static final Modifier PROTECTED = new Modifier("protected", 4, 4, true);
    public static final Modifier STATIC = new Modifier("static", 8, 8, true);
    public static final Modifier FINAL = new Modifier("final", 16, 16, true);
    public static final Modifier SYNCHRONIZED = new Modifier("synchronized", 32, 32, false);
    public static final Modifier NATIVE = new Modifier("native", 256, 256, false);
    public static final Modifier INTERFACE = new Modifier("interface", 512, 512, true);
    public static final Modifier TRANSIENT = new Modifier("transient", 128, 128, false);
    public static final Modifier VOLATILE = new Modifier("volatile", 64, 64, true);
    public static final Modifier ENUM = new Modifier("!enum", 16384, 0, true);
    public static final Modifier FIELD_ENUM = new Modifier("!fld_enum", 16384, 0, false);
    public static final Modifier ANNOTATION = new Modifier("!annotation", 8192, 0, true);
    public static final Modifier VARARGS = new Modifier("!varargs", 128, 0, true);
    public static final Modifier BRIDGE = new Modifier("!bridge", 64, 0, false);
    public static final Modifier HASDEFAULT = new Modifier("!hasdefault", 0x2000000, 0, true);
    public static final Modifier ACC_SUPER = new Modifier("acc_super", 32, 0, false);
    public static final Modifier ACC_SYNTHETIC = new Modifier("acc_synthetic", 4096, 0, false);
    public static final Modifier ACC_STRICT = new Modifier("acc_strict", 2048, 2048, false);
    private final String name;
    private final int value;
    private boolean isTracked;

    public String toString() {
        return this.name;
    }

    public boolean isTracked() {
        return this.isTracked;
    }

    public int getValue() {
        return this.value;
    }

    public void setTracked(boolean isTracked) {
        this.isTracked = isTracked;
    }

    public static Modifier getModifier(String name) {
        return (Modifier)knownModifiers.get(name);
    }

    public static Modifier[] getAllModifiers() {
        return knownModifiers.values().toArray(new Modifier[0]);
    }

    public static int scanModifiers(List elems) {
        Modifier m;
        int result = 0;
        while (elems.size() > 0 && (m = Modifier.getModifier((String)elems.get(0))) != null) {
            result |= m.value;
            elems.remove(0);
        }
        return result;
    }

    public static boolean hasModifier(int modifiers, Modifier m) {
        return (modifiers & m.value) != 0;
    }

    static int addModifier(int modifiers, Modifier m) {
        return modifiers | m.value;
    }

    static int removeModifier(int modifiers, Modifier m) {
        return modifiers & ~m.value;
    }

    public static String toString(MemberType type, int modifiers, boolean trackedOnly) {
        StringBuffer buf = new StringBuffer();
        Modifier[] applicableModifiers = type.getApplicableModifiers();
        boolean addSpace = false;
        for (int i = 0; i < applicableModifiers.length; ++i) {
            Modifier m = applicableModifiers[i];
            if ((m.value & modifiers) == 0 || trackedOnly && !m.isTracked()) continue;
            if (addSpace) {
                buf.append(' ');
            }
            addSpace = true;
            buf.append(m.name);
        }
        return buf.toString();
    }

    private Modifier(String name, int vmID, int reflID, boolean isTracked) {
        if (vmID != reflID && reflID != 0) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.value = vmID;
        this.isTracked = isTracked;
        knownModifiers.put(name, this);
    }

    public Modifier(String name, boolean isTracked) {
        Modifier[] ms = Modifier.getAllModifiers();
        int v = 0;
        for (int i = 0; i < ms.length; ++i) {
            if (ms[i].name.equals(name)) {
                throw new IllegalArgumentException("Name " + name + " is already used");
            }
            v |= ms[i].getValue();
        }
        if ((v = this.highestOneBit(~v)) == 0) {
            throw new IllegalArgumentException("No room for the new modifier " + name);
        }
        this.name = name;
        this.value = v;
        this.isTracked = isTracked;
        knownModifiers.put(name, this);
    }

    private int highestOneBit(int i) {
        i |= i >> 1;
        i |= i >> 2;
        i |= i >> 4;
        i |= i >> 8;
        i |= i >> 16;
        return i - (i >>> 1);
    }
}

