/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewmodel.core.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.incquery.runtime.api.GenericPatternMatch;
import org.eclipse.incquery.viewmodel.core.ViewModelManager;
import org.eclipse.incquery.viewmodel.traceability.Trace;
import org.eclipse.incquery.viewmodel.traceability.TraceabilityUtil;

public final class ViewModelUtil {
    private ViewModelUtil() {
    }

    public static <T extends EObject> T create(EClass eClass, EObject eContainer, EReference cReference) {
        EObject eObject = EcoreUtil.create((EClass)eClass);
        if (cReference.isMany()) {
            ((EList)eContainer.eGet((EStructuralFeature)cReference)).add((Object)eObject);
        } else {
            eContainer.eSet((EStructuralFeature)cReference, (Object)eObject);
        }
        return (T)eObject;
    }

    public static void trace(ViewModelManager manager, String id, Set<EObject> targets, Object ... sources) {
        Collection<EObject> eoList = ViewModelUtil.selectEObjects(sources);
        Collection<Object> oList = ViewModelUtil.selectObjects(sources);
        TraceabilityUtil.createTrace(manager.getTraceability(), id, eoList, oList, targets);
    }

    public static Collection<EObject> delete(GenericPatternMatch match) {
        Trace trace = (Trace)match.get("<trace>");
        ArrayList ret = Lists.newArrayList(trace.getTargets());
        EcoreUtil.delete((EObject)trace);
        return ret;
    }

    public static EObject target(GenericPatternMatch match) {
        Trace trace = (Trace)match.get("<trace>");
        return (EObject)trace.getTargets().get(0);
    }

    private static Collection<EObject> selectEObjects(Object[] sources) {
        return Arrays.asList(Collections2.filter(Arrays.asList(sources), (Predicate)new Predicate<Object>(){

            public boolean apply(Object source) {
                return source instanceof EObject;
            }
        }).toArray(new EObject[0]));
    }

    private static Collection<Object> selectObjects(Object[] sources) {
        return Collections2.filter(Arrays.asList(sources), (Predicate)new Predicate<Object>(){

            public boolean apply(Object source) {
                return !(source instanceof EObject);
            }
        });
    }

    public static ResourceSet getOrCreateResourceSet(Notifier baseNotifier) {
        if (baseNotifier instanceof EObject) {
            EObject eObject = (EObject)baseNotifier;
            Resource r = ViewModelUtil.createResourceForEObject(eObject);
            return r.getResourceSet();
        }
        if (baseNotifier instanceof Resource) {
            Resource r = (Resource)baseNotifier;
            return ViewModelUtil.createResourceSetForResource(r.getResourceSet(), r);
        }
        if (baseNotifier instanceof ResourceSet) {
            return (ResourceSet)baseNotifier;
        }
        throw new IllegalArgumentException("Cannot get or create ResourceSet for " + baseNotifier.getClass() + " type");
    }

    private static Resource createResourceForEObject(EObject root) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource r = resourceSet.createResource(URI.createURI((String)(String.valueOf(root.getClass().getSimpleName()) + "Resource")));
        r.getContents().add((Object)root);
        return r;
    }

    private static ResourceSet createResourceSetForResource(ResourceSet resourceSet, Resource r) {
        if (resourceSet == null) {
            resourceSet = new ResourceSetImpl();
            resourceSet.getResources().add((Object)r);
        }
        return resourceSet;
    }
}

