/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.model.converters;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.observable.list.ComputedList;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Annotation;
import org.eclipse.incquery.patternlanguage.patternLanguage.VariableValue;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.viewers.runtime.model.Containment;
import org.eclipse.incquery.viewers.runtime.model.Item;

public class ContainmentList
extends ComputedList {
    private String containerParameterName;
    private String destParameterName;
    private Multimap<Object, Item> itemMap;
    private IObservableList patternMatchList;

    public ContainmentList(Annotation itemAnnotation, Multimap<Object, Item> itemMap2, IObservableList patternMatchList) {
        Preconditions.checkArgument((boolean)"ContainsItem".equals(itemAnnotation.getName()), (Object)"The converter should be initialized using a Edge annotation.");
        this.itemMap = itemMap2;
        this.containerParameterName = ((VariableValue)CorePatternLanguageHelper.getFirstAnnotationParameter((Annotation)itemAnnotation, (String)"container")).getValue().getVar();
        this.destParameterName = ((VariableValue)CorePatternLanguageHelper.getFirstAnnotationParameter((Annotation)itemAnnotation, (String)"item")).getValue().getVar();
        this.patternMatchList = patternMatchList;
    }

    public List<Containment> calculate() {
        ArrayList<Containment> edgeList = new ArrayList<Containment>();
        for (Object _match : this.patternMatchList) {
            IPatternMatch match = (IPatternMatch)_match;
            Object sourceValue = match.get(this.containerParameterName);
            Object destValue = match.get(this.destParameterName);
            for (Object _sourceItem : this.itemMap.get(sourceValue)) {
                Item sourceItem = (Item)_sourceItem;
                for (Object _destItem : this.itemMap.get(destValue)) {
                    Item destItem = (Item)_destItem;
                    Containment edge = new Containment(sourceItem, destItem, match);
                    edgeList.add(edge);
                }
            }
        }
        return edgeList;
    }
}

