/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.model;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.incquery.databinding.runtime.observables.ObservableLabelFeature;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.viewers.runtime.model.Edge;
import org.eclipse.incquery.viewers.runtime.model.Item;
import org.eclipse.incquery.viewers.runtime.model.ViewerDataFilter;
import org.eclipse.incquery.viewers.runtime.model.ViewerDataModel;
import org.eclipse.incquery.viewers.runtime.model.ViewerStateList;
import org.eclipse.incquery.viewers.runtime.model.ViewerStateSet;
import org.eclipse.incquery.viewers.runtime.model.listeners.IViewerLabelListener;
import org.eclipse.incquery.viewers.runtime.model.listeners.IViewerStateListener;

public abstract class ViewerState {
    private static boolean setMode = false;
    protected boolean hasExternalViewerDataModel = false;
    protected Multimap<Object, Item> itemMap;
    protected Multimap<Item, Item> childrenMap;
    protected Map<Item, Item> parentMap;
    protected ViewerDataModel model;
    protected ListenerList stateListeners = new ListenerList();
    protected ListenerList labelListeners = new ListenerList();
    protected IChangeListener labelChangeListener = new IChangeListener(){

        public void handleChange(ChangeEvent event) {
            Object element = ((ObservableLabelFeature)event.getSource()).getContainer();
            Object[] objectArray = ViewerState.this.labelListeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object _listener = objectArray[n2];
                IViewerLabelListener listener = (IViewerLabelListener)_listener;
                if (element instanceof Item) {
                    Item item = (Item)element;
                    listener.labelUpdated(item, ((Item)element).getLabel().getValue().toString());
                } else if (element instanceof Edge) {
                    Edge edge = (Edge)element;
                    listener.labelUpdated(edge, ((Edge)element).getLabel().getValue().toString());
                }
                ++n2;
            }
        }
    };

    public static ViewerState newInstance(ResourceSet set, IncQueryEngine engine, Collection<Pattern> patterns, ViewerDataFilter filter, Collection<ViewerStateFeature> features) {
        if (setMode) {
            return new ViewerStateSet(set, engine, patterns, filter, features);
        }
        return new ViewerStateList(set, engine, patterns, filter, features);
    }

    public static ViewerState newInstance(ViewerDataModel model, ViewerDataFilter filter, Collection<ViewerStateFeature> features) {
        ViewerState s = null;
        s = setMode ? new ViewerStateSet(model, filter, features) : new ViewerStateList(model, filter, features);
        s.hasExternalViewerDataModel = true;
        return s;
    }

    public Collection<Item> getChildren(Item parent) {
        return this.childrenMap.get((Object)parent);
    }

    public Item getParent(Item child) {
        return this.parentMap.get(child);
    }

    public void addStateListener(IViewerStateListener listener) {
        this.stateListeners.add((Object)listener);
    }

    public void removeStateListener(IViewerStateListener listener) {
        this.stateListeners.remove((Object)listener);
    }

    public void addLabelListener(IViewerLabelListener listener) {
        this.labelListeners.add((Object)listener);
    }

    public void removeLabelListener(IViewerLabelListener listener) {
        this.labelListeners.remove((Object)listener);
    }

    public Collection<Item> getItemsFor(Object target) {
        return this.itemMap.get(target);
    }

    public abstract IObservableCollection getItems();

    public abstract IObservableCollection getEdges();

    public abstract IObservableCollection getContainments();

    public void dispose() {
        if (!this.getItems().isDisposed()) {
            for (Object _item : this.getItems()) {
                Item item = (Item)_item;
                item.getLabel().removeChangeListener(this.labelChangeListener);
                item.dispose();
            }
            this.getItems().dispose();
        }
        if (!this.getEdges().isDisposed()) {
            for (Object _edge : this.getEdges()) {
                Edge edge = (Edge)_edge;
                edge.getLabel().removeChangeListener(this.labelChangeListener);
                edge.dispose();
            }
            this.getEdges().dispose();
        }
        if (!this.getContainments().isDisposed()) {
            this.getContainments().dispose();
        }
        this.stateListeners.clear();
        this.labelListeners.clear();
        if (!this.hasExternalViewerDataModel) {
            this.model.dispose();
        }
    }

    public boolean isDisposed() {
        return this.getItems().isDisposed() || this.getEdges().isDisposed() || this.getContainments().isDisposed();
    }

    public static enum ViewerStateFeature {
        EDGE,
        CONTAINMENT;

    }
}

